<?php
	class site{
		private $html='5';
		private $charset='utf-8';
		private $wys;
		private $wyss;
		private $doctype;
		private $title='';
		private $xml='';
		private $meta='';
		private $metaType='';
		private $metaContent='';
		private $s='';
		private $scriptSrc='';
		private $scriptType='';
		
		
		function setDoctype($type){
			$this->html=$type;
			switch($type){
				case '5':
					$this->doctype='<!DOCTYPE HTML><html>';
					$this->s='/';
					break;
				case '4frameset':
					$this->doctype='<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN" "http://www.w3.org/TR/html4/frameset.dtd"><html>';
					break;
				case '4strict':
					$this->doctype='<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd"><html>';				
					break;
				case 'xstrict':
					$this->doctype='<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"><html xmlns="http://www.w3.org/1999/xhtml">';
					$this->s='/';					
					break;
				case 'xtransitional':
					$this->doctype='<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"><html xmlns="http://www.w3.org/1999/xhtml">';
					$this->s='/';
					break;
				case 'xframeset':
					$this->doctype='<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Frameset//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-frameset.dtd"><html xmlns="http://www.w3.org/1999/xhtml">';
					$this->s='/';
					break;
				default:
					$this->doctype='<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd"><html>';
					break;			
			}		
		}
		function getDoctype(){
			echo $this->doctype;
		}

		function setCharset($char=''){
			$this->setMeta('Content-Type','text/html; charset='.$char);
			$this->charset=$char;
		}		
		function setMeta($type='',$content=''){
			$this->metaType[]=$type;
			$this->metaContent[]=$content;
		}
		function getMeta($nr=''){
			if(is_int($nr)){
				if($this->html!='5'){
					echo "<meta http-equiv='{$this->metaType[$nr]}' content='{$this->metaContent[$nr]}'{$this->s}>";
				}else{
					echo "<meta charset='{$this->charset}'>";	
				}
				$this->wys[$nr]=true;
			}else{
				for($i=0;$i<count($this->metaContent);$i++){
					if($this->wys[$i]!=true){
						echo "<meta http-equiv='{$this->metaType[$i]}' content='{$this->metaContent[$i]}'{$this->s}>";
					}
				}
			}
		}
		function setScript($src='',$type='text/javascript'){
			$this->scriptSrc[]=$src;
			$this->scriptType[]=$type;
		}
		function getScript($nr=''){
			if(is_int($nr)){
				echo "<script src='{$this->scriptSrc[$nr]}' type='{$this->scriptType[$nr]}'></script>";
				$this->wyss[$nr]=true;
			}else{
				for($i=0;$i<count($this->scriptSrc);$i++){
					if($this->wyss[$i]!=true){
						echo "<script src='{$this->scriptSrc[$i]}' type='{$this->scriptType[$i]}'></script>";
					}
				}
			}
		}
		function setTitle($title=''){
			$this->title=$title;
		}
		function getTitle(){
			echo "<title>{$this->title}</title>";
		}
		function generate($wh=''){
			if(($wh!=''&&$wh=='head')||$wh==''){
				echo $this->xml;
				$this->getDoctype();
					echo "<head>";
						$this->getMeta(0);
						$this->getTitle();
						$this->getMeta();
						$this->getScript();
					echo "</head>";
					echo "<body>";
			}
			if(($wh!=''&&$wh=='foot')||$wh==''){
					echo"</body>";
				echo "</html>";
			}
		}
		function _debug(){
			echo "<pre>";
			try{
				printf($this->metaType);
				printf($this->metaContent);
				printf($this->scriptSrc);
				printf($this->scriptType);
			} catch (Exception $e) {
				echo 'Err: '.$e->getMessage()."\n";
			}
			echo "</pre>";
		}
	}
?>