<?php

/*
Author: Luke Ring (skywalkervsthematrix@hotmail.com)


Copyright luke ring 2003, may be copied or modified without
consent as long as this message remains in tact

honeyPot creates random email addresses

usage:

$addresses = new honeyPot(); //create with default values, variables are self explanitary

$addresses->createAddressArray(); //outputs an array of the generated addresses
$addresses->displayAddresses(); //echos list of generated addresses to the page
$addresses->displayTimeTaken(); //shows time taken for last usage of displayAddresses() or createAddressArray()
*/

class honeyPot {
	//define word lengths
	var $umin;
	var $umax;
	var $dmin;
	var $dmax;
	//define address count
	var $addresses;
	var $userfordomain;
	var $emails;
	var $countrys;
	
	var $timestart;
	var $lasttime;
	
	function honeyPot($usermin = 3, $usermax = 15, $addresses = 10, $userfordomain = false, $domainmin = 3, $domainmax = 15){
		$this->umin = $usermin;
		$this->umax = $usermax;
		$this->addresses = $addresses;
		$this->userfordomain = $userfordomain;
		$this->dmin = $domainmin;
		$this->dmax = $domainmax;
		$this->countrys = array("",".ac",".ad",".ae",".af",".ag",".ai",".al",".am",".an",".ao",".aq",".ar",".as",".at",".au",".aw",".az",".ba",".bb",".bd",".be",".bf",".bg",".bh",".bi",".bj",".bm",".bn",".bo",".br",".bs",".bt",".bv",".bw",".by",".bz",".ca",".cc",".cd",".cf",".cg",".ch",".ci",".ck",".cl",".cm",".cn",".co",".cr",".cu",".cv",".cx",".cy",".cz",".de",".dj",".dk",".dm",".do",".dz",".ec",".ee",".eg",".eh",".er",".es",".et",".fi",".fj",".fk",".fm",".fo",".fr",".ga",".gd",".ge",".gf",".gg",".gh",".gi",".gl",".gm",".gn",".gp",".gq",".gr",".gs",".gt",".gu",".gw",".gy",".hk",".hm",".hn",".hr",".ht",".hu",".id",".ie",".il",".im",".in",".io",".iq",".ir",".is",".it",".je",".jm",".jo",".jp",".ke",".kg",".kh",".ki",".km",".kn",".kp",".kr",".kw",".ky",".kz",".la",".lb",".lc",".li",".lk",".lr",".ls",".lt",".lu",".lv",".ly",".ma",".mc",".md",".mg",".mh",".mk",".ml",".mm",".mn",".mo",".mp",".mq",".mr",".ms",".mt",".mu",".mv",".mw",".mx",".my",".mz",".na",".nc",".ne",".nf",".ng",".ni",".nl",".no",".np",".nr",".nu",".nz",".om",".pa",".pe",".pf",".pg",".ph",".pk",".pl",".pm",".pn",".pr",".ps",".pt",".pw",".py",".qa",".re",".ro",".ru",".rw",".sa",".sb",".sc",".sd",".se",".sg",".sh",".si",".sj",".sk",".sl",".sm",".sn",".so",".sr",".st",".sv",".sy",".sz",".tc",".td",".tf",".tg",".th",".tj",".tk",".tm",".tn",".to",".tp",".tr",".tt",".tv",".tw",".tz",".ua",".ug",".uk",".um",".us",".uy",".uz",".va",".vc",".ve",".vg",".vi",".vn",".vu",".wf",".ws",".ye",".yt",".yu",".za",".zm",".zw");
		$this->types = array("com","org","gov","mil","net");
	}
	
	function createAddressArray(){
		list($low, $high) = explode(" ", microtime());
		$this->timestart = $high + $low;
		$i=0;
		$addressarray = array();
		while($i<$this->addresses){
			$addressarray[] = $this->makeAddress();
			$i++;
		}
		list($low, $high) = explode(" ", microtime());
		$timetaken = $high + $low;
		$this->lasttime = $timetaken - $this->timestart;
		return $addressarray;
	}
	function displayAddresses(){
		list($low, $high) = explode(" ", microtime());
		$this->timestart = $high + $low;
		$i=0;
		$addressstring = "";
		while($i<$this->addresses){
			$addressstring .= $this->makeAddress() . "<br>";
			$i++;
		}
		echo $addressstring;
		list($low, $high) = explode(" ", microtime());
		$timetaken = $high + $low;
		$this->lasttime = $timetaken - $this->timestart;
		return $addressstring;
	}
	function makeAddress(){
		$user = $this->createRandString();
		if($this->userfordomain == false){
			$domain = $this->createRandString("domain");
		}else{
			$domain = $user;
		}
		
		$address = $user . "@" . $domain . "." . $this->createType();
		$country = $this->createCountry();
		if($country != ""){
			$address .= $country;
		}
		
		return $address;
	}
	
	function createRandString($type = "user"){
		srand((double) microtime() * 948625);
		if($type=="user"){
			$length = rand($this->umin, $this->umax);
		}else{
			$length = rand($this->dmin, $this->dmax);
		}
		$string = "";
		$numbersmin = 48;
		$numbersmax = 57;
		$lowercaselettersmin = 97;
		$lowercaselettersmax = 122;
		$whichset = 0;
		while($length >= 0){
			$set = rand(0,100);
			if($set < 5){
				$string .= "_";
			}elseif($set < 32){
				$string .= chr(rand($numbersmin, $numbersmax));
			}else{
				$string .= chr(rand($lowercaselettersmin, $lowercaselettersmax));
			}
			
			$length--;
		}
		
		return $string;
	}
	function createType(){
		srand ((double) microtime() * 845676);
		$tid = rand(0, count($this->types)-1);
		return $this->types[$tid];
	}
	function createCountry(){
		srand ((double) microtime() * 375797);
		$cid = rand(0, count($this->countrys)-1);
		return $this->countrys[$cid];
	}
	function displayTimeTaken(){
		echo "\n<br>Time Taken: " . $this->lasttime . "s";
	}
}

?>