<html>
<head>
	<title></title>
</head>

<body>

<?php
// Include class
include ( "./class.xerror.php" );

// Initialize a new xError object...
$x = new xError();

// Import error definitions...
$x->importDefinitions ( "./errors01.txt" );

// Set the templates for fatal and non-fatal errors...
$x->setTemplates ( "./fatal.html", "./non-fatal.html" );

// Set the error log...
$x->setLogFile ( "./error_log.txt" );

// Yes, we do log fatal errors...
$x->logFatalErrors ( true );

// The contents shown, if no fatal error occurs...
echo "If you see this message, no fatal errors occurred...";

// Raise some errors (uncomment the last one to see how a fatal error is handled
$x->raiseError ( "x100" );
$x->raiseError ( "x109" );
$x->raiseError ( "x105" );
$x->raiseError ( "x106" );
//$x->raiseError ( "x200" );

// Write the contents of the error stack (non-fatal errors only, since no fatal
// error has occurred if the script got executed to this point...
$x->writeLog();

// Clean-up the error stack and return it's content...
$y = $x->flushErrors();

// Check if any errors occurred...
echo ( count ( $y ) > 0 ) ? "<hr />However, some <b>non-fatal</b> errors did occur:<br /><br />" : "";

// Display an error message containing the errors from the error stack...
// (Optionally you can use the 'displayNonFatalError' method to display non-fatal errors)
foreach ( $y as $error )
{
        echo $error['time'] . " - <b>" . $error['code'] . "</b> : " . $error['user'];
        echo ( $error['suggestions'] ) ? "<br /><b>Suggestions:</b> <i>" . $error['suggestions'] . "</i>" : "";
        echo "<br /><br />";
}
echo "<hr />";
?>

</body>
</html>