<?PHP
// ---------------------------------------
// full horizontal banner creation script
// This script will resize a picture to fit the screen width
// height / width ratio is kept as is
// picture format is also kept as is (if GIF, it will remain in GIF)

// retrieving phone resolution
$width=$_GET['phone_w'];
$height=$_GET['phone_h'];

// retrieving original image width and height
$image_file=$_GET['file'];
$image_size=getimagesize("$image_file");
$image_width=$image_size[0];
$image_height=$image_size[1];
$image_extension=substr($image_file,-3);
// retrieving target image mode
// hz_strech = horizontal stretch, keep height ratio
// fl_strech = full stretch, image completely fitting destination screen
// fl_strech can generate distortion
// hf_strech = picture will take 50% of screen width, height ratio will be kept
// if no strech mode is define, htstrech will be chosen by default

$stretch_mode=$_GET['stretch'];
if ($stretch_mode=="")
	{
		$stretch_mode="hz_stretch";
	}

// determining destination image size
switch ($stretch_mode)
	{
		case "hz_stretch":
		$destination_width=$width-8;
		$image_ratio=$image_height/$image_width;
		$destination_height=round($destination_width*$image_ratio,0);
		break;
		
		case "fl_stretch":
		$destination_width=$width;
		$destination_height=$height;
		
		break;
		
		case "hf_stretch":
		$destination_width=round($width/2,0);
		$image_ratio=$image_height/$image_width;
		$destination_height=round($destination_width*$image_ratio,0);
		break;
	}

// Only JPG and GIF are treated here but feel free to add other formats
switch ($image_extension)
	{
		case "gif":
		$image_new=imagecreate($destination_width,$destination_height);
		$image_current=imagecreatefromgif($image_file);
		imagecopyresampled($image_new,$image_current,0,0,0,0,$destination_width,$destination_height,$image_width,$image_height);
		header("Content-Type: image/gif");
		imagegif($image_new);	
		break;
		
		case "jpg":
		$image_new=imagecreatetruecolor($destination_width,$destination_height);
		$image_current=imagecreatefromjpeg($image_file);
		imagecopyresampled($image_new,$image_current,0,0,0,0,$destination_width,$destination_height,$image_width,$image_height);
		header("Content-Type: image/jpg");
		imagejpeg($image_new, null,90);
		break;
	}




?>