<?php
require_once( 'ABC_RSS.php' );


$destination_file ='rss.xml';


$rss = new ABC_RSS();

try {

	// All possible channel elements
	
	$channel =array(); 
	$channel['title']          ='News.dom';
	$channel['link']           ='http://www.news.dom/'; 
	$channel['description']    ='All the News You Can Stand'; 
	$channel['language']       ='en-us'; 
	$channel['copyright']      ='Copyright 2010-2012, News.dom'; 
	$channel['managingEditor'] ='editor@news.dom (John Smith)';
	$channel['webMaster']      ='webmaster@news.dom (Jane Doe)'; 
	$channel['pubDate']        =date( DATE_RSS ); 
	$channel['lastBuildDate']  =date( DATE_RSS ); 
	
	$channel['category'] =array();
	$channel['category'][] =array( 'content' =>'news', 'domain'  =>'local,regional,national,world' );
	$channel['category'][] =array( 'content' =>'sports', 'domain'  =>'local,regional,national' );
	$channel['category'][] =array( 'content' =>'entertainment', 'domain'  =>'local,regional,national' );
	
	$channel['generator'] ='ABC_RSS PHP Class'; 
	$channel['docs']      ='http://blogs.law.harvard.edu/tech/rss';
	
	$channel['cloud'] = array();
	$channel['cloud']['domain']            ='rpc.news.dom';
	$channel['cloud']['port']              ='80';
	$channel['cloud']['path']              ='/RPC2';
	$channel['cloud']['registerProcedure'] ='pingMe';
	$channel['cloud']['protocol']          ='soap';
	
	$channel['ttl'] = '60';
	
	$channel['image'] =array();
	$channel['image']['url']    ='http://www.news.dom/logo.jpg';
	$channel['image']['title']  ='News.dom';
	$channel['image']['link']   ='http://www.news.dom/';
	$channel['image']['width']  ='88';
	$channel['image']['height'] ='31';
	
	$channel['rating'] ='(PICS-1.1 "http://www.gcf.org/v2.5" '. 
											'l r (suds 0.5 density 0 color/hue 1) '.
											'r (subject 2 density 1 color/hue 1))';
	
	$channel['textInput'] =array();
	$channel['textInput']['title']       ='Search';
	$channel['textInput']['description'] ='Find an article on News.dom';
	$channel['textInput']['name']        ='q';
	$channel['textInput']['link']        ='http://www.news.dom/search/';
	
	$channel['skipHours'] ='0,1,2,3';
	$channel['skipDays']  ='Saturday';
	
	if ( !$rss->set_channel( $channel ))
	{
		$errors =&$rss->errors;
		throw new Exception( 'Unable to set the RSS channel.' );
	}
	
	
	// All possible item elements
	
	$item =array(); 
	$item['title']       ='New Water Park Makes Big Splash in Local Economy'; 
	$item['description'] ='Reporter Peter Griffin talks to Bob Smith, the owner-operator '.
												'of Quahog\'s new water recreation park, Wetworld.';
	$item['link']        ='http://www.news.dom/headlines/';
	$item['author']      ='Peter Griffin'; 
	
	$item['category'] =array();
	$item['category'][] =array( 'content' =>'news', 'domain'  =>'local' );
	$item['category'][] =array( 'content' =>'entertainment', 'domain'  =>'local' );
	
	$item['comments'] ='http://www.news.dom/comments/?article=7836453'; 
	
	$item['enclosure'] =array(); 
	$item['enclosure']['url']    ='http://www.news.dom/video/?id=68737';
	$item['enclosure']['length'] ='12216320'; 
	$item['enclosure']['type']   ='video/quicktime';
	
	$item['guid'] =array();
	$item['guid']['isPermaLink'] ='true';
	$item['guid']['content']     ='http://www.news.dom/articles/?id=7836453';
	
	$item['pubDate'] ='Sun, 19 May 2002 15:21:36 GMT';
	
	if ( !$rss->set_item( $item ))
	{
		$errors =&$rss->errors;
		throw new Exception( 'Unable to set the RSS item.' );
	}
	
	
	if ( !$rss->export( 'write', $destination_file ))
	{
		$errors =&$rss->errors;
		throw new Exception( 'Unable to write the RSS file.' );
	}
}

catch ( Exception $e ) { $errors[] =$e->getMessage(); }

if ( !empty( $errors ))
	foreach ( $errors as $error )
		printf( "<p>%s</p>", $error );
		
else 
	print '<p>The RSS was created without errors.</p>';
?>