    <?php
    //Insieme di Funzioni per estrarre i dati da phpBB3
    //Nome: OCphBB
    //Versione: 0.1beta
    //Autore: Luca Melloni (alias: Orebla) http://www.orebla.it
    //Licenza: Creative Commons (http://creativecommons.org/licenses/by-nc-nd/2.5/it/)
    //Note: ------

    //Definizioni iniziali
    define('IN_PHPBB', true);
    $phpbb_root_path = (defined('PHPBB_ROOT_PATH')) ? PHPBB_ROOT_PATH : './';
    $phpEx = substr(strrchr(__FILE__, '.'), 1);
    include($phpbb_root_path . 'common.' . $phpEx);
    include('config.php');
    //Inizio Sessione
    $user->session_begin();
    $auth->acl($user->data);
    $user->setup();

    //ULTIMI ARGOMENTI INSERITI NEL FORUM
    //Utilizzo:
    //$ordine = ASC (crescente) o DESC (decrescente, DEFAULT)
    //$numero = numero mess visualizzati (DEFAULT = 5)
    //$stile = stile personalizzato della lista (DEFAULT = <li>)
    //$formato_data = segue lo stile della funzione date() di PHP (DEFAUKT = 01 January 1970)
    function last_topic($ordine = "DESC", $numero = "5", $stile = "<li>\n", $formato_data = "j F Y"){
    global $phpbb_root_path, $db;

    $lista = '';
    $sql = "SELECT topic_id,forum_id,topic_last_post_id,topic_last_post_time, topic_title, topic_last_poster_name
              FROM ".TOPICS_TABLE."
                 ORDER BY topic_last_post_time ".$ordine."
                  LIMIT 0 ,".$numero;
                 
                 
    $result = $db->sql_query($sql);

    $lista .= "<ul>\n";
    while($row = $db->sql_fetchrow($result)){

    $lista .= $stile."<a href='".$phpbb_root_path."viewtopic.php?f=".$row['forum_id']."&t=".$row['topic_id']."#p".$row['topic_last_post_id']."'>".$row['topic_title']."</a>\n
    <br>\n
    Inviato da <a href='".$phpbb_root_path."memberlist.php?mode=viewprofile&un=".$row['topic_last_poster_name']."'><b>".$row['topic_last_poster_name']."</b></a>, il " . date($formato_data, $row['topic_last_post_time']) . "</li>\n";
    }

    $lista .= "</ul>\n";     
    $db->sql_freeresult($result);

    return $lista;
    }
    //----------------------------------------------------------


    //ULTIMI MESSAGGI INSERITI NEL FORUM
    //Utilizzo:
    //$ordine = ASC (crescente) o DESC (decrescente, DEFAULT)
    //$numero = numero mess visualizzati (DEFAULT = 5)
    //$stile = stile personalizzato della lista (DEFAULT = <li>)
    //$formato_data = segue lo stile della funzione date() di PHP (DEFAULT = 01 January 1970)
    function last_mess($ordine = 'DESC', $numero = 5, $stile = "<li>\n", $formato_data = "j F Y"){
    global $phpbb_root_path, $db;

    $lista_mess = '';

    $sql = "SELECT post_id, topic_id,forum_id, post_time, post_subject, poster_id, user_id, username
                  FROM ".POSTS_TABLE.", ".USERS_TABLE."
                    WHERE poster_id = user_id
                  ORDER BY post_time ".$ordine."
                  LIMIT 0 ,".$numero;

    $result = $db->sql_query($sql);

    $lista_mess .= "<ul>\n";
    while($row = $db->sql_fetchrow($result)){

    $lista_mess . $stile."<a href='".$phpbb_root_path."viewtopic.php?f=".$row['forum_id']."&t=".$row['topic_id']."#p".$row['post_id']."'>".$row['post_subject']."</a>\n
    <br>\n
    Inviato da <a href='".$phpbb_root_path."memberlist.php?mode=viewprofile&un=".$row['username']."'><b>".$row['username']."</b></a>, il " . date($formato_data, $row['post_time']) . "</li>\n";
    }
       
    $db->sql_freeresult($result);
    $lista_mess .= "</ul>\n";
    }
    //----------------------------------------------------------

    //MOSTRA STATISTICHE FORUM
    /*
    Utilizzo: forum_stats($opzione) sostituire $opzione con l'opzione voluta, NON accetta più opzioni,
    esempio: echo "Numero totale utenti: ".forum_stats(3);
    1 -> per mostrare l'username dell'ultimo iscritto
    2 -> per mostrare l'id dell'ultimo iscritto
    3 -> per mostrare il numero totale di utenti
    4 -> per mostrare il link alla pagina del profilo dell'ultimo iscritto
    5 -> per mostrare il totale degli argomenti presenti nel forum
    NESSUNA OPZIONE -> per mostrare il numero totale di messaggi nel forum
    */
    function forum_stats($opzione){
    global $config,$phpbb_root_path;

    switch($opzione)
    {
    //1=mostra username dell'ultimo utente iscritto
    case 1:
    return $config['newest_username'];
    break;

    //2=mostra l'id dell'ultimo utente iscritto
    case 2:
    return $config['newest_user_id'];
    break;

    //3=mostra il numero totale di utenti
    case 3:
    return $config['num_users'];
    break;

    //4=mostra il link al profilo dell'ultimo utente iscritto
    case 4:
    $indirizzo = '<a href="'.$phpbb_root_path.'memberlist.php?mode=viewprofile&u='.$config['newest_user_id'].'">'.$config['newest_username'].'</a>';
    return $indirizzo;
    break;

    //5=mostra il numero totale di argomenti
    case 5:
    return $config['num_topics'];
    break;

    //Se non viene impostata nessuna opzione mostra il numero totale di messaggi
    default:
    return $config['num_posts'];
    break;
    }


    }
    //----------------------------------------------------------

    //NUMERO UTENTI OSPITI ATTUALMENTE ONLINE
    //Utilizzo: Mostra il numero di ospiti presenti sul forum, restituisce un numero
    //per tanto si utilizza come una variabile numerica: echo guest_online();
    function guest_online(){
    global $db;

    $sql = 'SELECT COUNT(DISTINCT session_ip) as num_guests
                FROM ' . SESSIONS_TABLE . '
                WHERE session_user_id = ' . ANONYMOUS . '
                   AND session_time >= ' . (time() - ($config['load_online_time'] * 60));

       $result = $db->sql_query($sql);
       $guest_counter = (int) $db->sql_fetchfield('num_guests');
       $db->sql_freeresult($result);
       
       //restituisco il valore
       return $guest_counter;
    }
    //----------------------------------------------------------

    //VERIFICA SE L'UTENTE E' LOGGATO O NO
    //Utilizzo: restituisce TRUE se l'utente ha effettuato il login o FALSE se non l'ho fatto
    function r_area(){
    global $user;

    if ($user->data['is_registered']){
    return TRUE;
    }else{
    return FALSE;
    }

    }
    //----------------------------------------------------------

    ?>

