<?php
// ZebraFeeds - copyright (c) 2006 Laurent Cazalet
// http://www.cazalet.org/zebrafeeds
//


/* initialization for both admin and user areas */

// hidden settings, no GUI for these
define('ZF_DEFAULT_NEWS_COUNT', 3);
define('ZF_DEFAULT_REFRESH_TIME', 60);
define('ZF_DYNAMICNEWSLENGTH', 500); // news longer than that will be dynamically obtained. 0 to disable. Requires compatible templates. 
define('ZF_SESSION_DURATION', 900); // 15 minutes before unmarking items as new
define('ZF_VISITOR_COOKIE_EXPIRATION',60*60*24*30); //30 days
define('ZF_FORCE_ENCODED_CONTENT', 'yes'); // stored in cache. if this is changed, it will be active only after cache is refreshed
define('ZF_GROUP_BY_DAY', 'yes'); // if yes, items are grouped by day in non-per-channel views
define('ZF_MAX_SUMMARY_LENGTH', 700); // if feed-provided summary is longer, let's truncate
define('ZF_SUMMARY_TRUNCATED_LENGTH', 150); // if truncate summary, here's the remaining length
define('ZF_SHOWCREDITS', 'yes');
/*--------------------------*/

global $zf_path;
error_reporting(0);

set_magic_quotes_runtime(0);
$zf_path = str_replace("\\", "/", dirname(__FILE__)) . "/";

require_once($zf_path . 'config.php');
if (ZF_USEOPML == 'yes') {
    require_once($zf_path . 'includes/opml.php');
}
require_once($zf_path . 'includes/common.php');

setlocale(LC_ALL, ZF_LOCALE);
define('ZF_VER', '1.2');
define('ZF_USERAGENT',"ZebraFeeds/".ZF_VER." (http://www.cazalet.org/zebrafeeds)");

define("ZF_DATADIR",'data');
define("ZF_OPMLDIR",'categories');

define("ZF_CACHEDIR",ZF_DATADIR.'/cache');

define('MAGPIE_OUTPUT_ENCODING', ZF_ENCODING);
define('MAGPIE_USER_AGENT', ZF_USERAGENT);
define('MAGPIE_CACHE_DIR', $zf_path.ZF_CACHEDIR);


/* debug values for ZF_DEBUG
 2: interface with Magpie
 4: feed aggregation
 6: run time
 7: history, session and cookies
10: OPLM read
*/

define('ZF_DEBUG', 0);
define('MAGPIE_DEBUG', 0);

//Defaults
function defaultConfig($name,$value) {

    if (!defined($name)) {
        define($name,$value);
    }
}

//default values for parameters with a UI
defaultConfig('ZF_LOGINTYPE', 'server');
defaultConfig('ZF_LOCALE', 'english');
defaultConfig('ZF_OWNEREMAIL', '');
defaultConfig('ZF_OWNERNAME', '');
defaultConfig('ZF_PUBDATEFORMAT', '%x, %X');
defaultConfig('ZF_DATEFORMAT', '%x');
defaultConfig('ZF_REFRESHMODE','automatic');
defaultConfig('ZF_RENDERMODE','automatic');
defaultConfig('ZF_NEWITEMS','no');
defaultConfig('ZF_NOFUTURE','no');
defaultConfig('ZF_HOMEURL','');
defaultConfig('ZF_USEOPML', 'yes');
defaultConfig('ZF_ENCODING', 'UTF-8');
defaultConfig('ZF_DISPLAYERROR', 'no');
defaultConfig('ZF_TEMPLATE', 'infojunkie');
defaultConfig('ZF_HOMELIST', 'sample');


//error_reporting(E_ERROR | E_WARNING | E_PARSE);
//error_reporting (E_ALL ^ E_NOTICE);
if (ZF_DEBUG) {
    error_reporting (E_ALL);
	global $zf_debugData;
	$zf_debugData['clock'][] = microtime();
	if (function_exists('getrusage')) {
		$dat = getrusage();
		$zf_debugData['utime_before'] = $dat["ru_utime.tv_sec"].$dat["ru_utime.tv_usec"];
		$zf_debugData['stime_before'] = $dat["ru_stime.tv_sec"].$dat["ru_stime.tv_usec"];	
	}

	
}
?>
