<?php
// ZebraFeeds - copyright (c) 2006 Laurent Cazalet
// http://www.cazalet.org/zebrafeeds
//
// zFeeder 1.6 - copyright (c) 2003-2004 Andrei Besleaga
// http://zvonnews.sourceforge.net
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

if (zfAuth()==false) exit;

/* we would need this to clear the history file */
//require_once($zf_path . 'includes/history.php');

function sortChannelsByName($channels) {
    /* sort channels list by setting the array key to the position */
    $sortedchannels = array();
    foreach($channels as $i => $channel) {
        if ($channel['xmlurl'] != '') {
            /* tackle duplicate names */
            if (isset($sortedchannels[$channel['title']]) || (strlen($channel['title'])) == 0) {
                $title = $channel['title']. ' ('.$channel['position'].')';
            } else {
                $title = $channel['title'];
            } 
            /*echo $title.' -- ';*/
            $sortedchannels[$title] = $channel;
            /* but we need to keep the original index to identify the feed, next time we need it in 
            a copy/delete operation */
            $sortedchannels[$title]['opmlindex'] = $i;
        }
    }
    ksort($sortedchannels);
    return $sortedchannels; 
}

function sortChannelsByPosition($channels) {
    /* sort channels list by setting the array key to the position */
    $sortedChannels = array();
    foreach($channels as $i => $channel) {
        if ($channel['xmlurl'] != '') {
            $sortedchannels[$channel['position']] = $channel;
            /* but we need to keep the original index to identify the feed, next time we need it in 
            a copy/delete operation */
            $sortedchannels[$channel['position']]['opmlindex'] = $i;
        }
    }
    ksort($sortedchannels);
    return $sortedchannels; 
}



/* function to be called while displaying the channel table
channel are sorted according to their position
arg : channel, an array of feeds (got from opml functions)
*/
function displayChannelList($channels) {

    $channelcount = count($channels);

    if ($channelcount > 0) {
        $htmldata = <<<EOD
<div class="sub-line">
	<input type="checkbox" name="actionbox{i}" value="checkbox"/>
	<span class="link" title="Edit feed properties" onclick="showEditForm({i}); return false;">
		<span id="title{i}" class="{class}">{chantitle}</span>
	</span>&nbsp;
	<a href="javascript:open('{htmlurl}')" title="Open the publisher site in a new window" onclick="window.open('{htmlurl}'); return false;"><img src="{zfurl}/images/extlink.png" border="0" alt="website"/></a>
</div>
EOD;


        $returndata = '';
        foreach($channels as $key => $channel) {
            $tempdata = '';
            $tempdata = str_replace("{i}", $channel['opmlindex'], $htmldata);
            $channel['title'];
            if ($channel['issubscribed'] != 'yes' ) {
                $class = 'unsubscribed';
            } else {
                $class = 'subscribed';
            }
            $tempdata = str_replace("{zfurl}", ZF_URL, $tempdata);
            $tempdata = str_replace("{class}", $class, $tempdata);
            $tempdata = str_replace("{chantitle}", $channel['title'], $tempdata);
            $tempdata = str_replace("{htmlurl}", htmlentities($channel['htmlurl']), $tempdata);

            echo $tempdata;
        }
    } else {
        echo "Subscription list empty";
    }

}

/* function to be called while displaying the channel edit form
arg : channel, an array of feeds (got from opml functions)
*/
function displayChannelEditForm($channels) {

    $channelcount = count($channels);

    if ($channelcount > 0) {
        $htmldata = <<<EOD
<div class="editfeed" id="editform{i}" style="display:none;">
	<form action="#">
    	<label for="chantitle">Title:</label>&nbsp;<br/>
		<input type="text" size="50" name="chantitle" id="chantitle{i}" value="{chantitle}" /><br/><br/>
		<label for="xmlurl"> feed URL:</label><br/>
		<input type="text" size="50" id="xmlurl{i}" name="xmlurl" value="{xmlurl}" />
		<a href="javascript:open('{xmlurl}')" title="Open the feed in a new window" onclick="window.open('{xmlurl}'); return false;"><img src="{zfurl}/images/feed.png" border="0" alt="RSS/ATOM feed"/></a>
		<br/><br/>
		<label for="description">Description</label><br/>
		<textarea rows="2" cols="40" id="description{i}" name="description">{description}</textarea><br/><br/>
		<br/><br/>
		<table border="0">
			<tr>
			<td><label for="subscribed">Subscribed</label></td>
			<td><input type="checkbox" name="issubscribed" {issubscribed} value="Subscribed" title="Subscribed to this feed"/></td>
			</tr>
			<tr>
			<td><label for="position">Position:</label></td>
			<td><input name="position" type="text" size="3" value="{position}"/></td>
			<td></td>
			</tr>
			<tr>
			<td><label for="refreshtime">Refresh time:</label></td>
			<td><input name="refreshtime" type="text" size="4" value="{refreshtime}"/>&nbsp;minutes</td>
			</tr>
			<tr>
			<td><label for="showeditems">Shown items:</label></td>
			<td><input name="showeditems" type="text" size="4" value="{showeditems}"/></td>
			</tr>
		</table>
		<div align="center" style="margin-top: 15px;">
			<input type="button" name="save" value="Save" onclick="saveChannel({i}, this.form); return false;"/>&nbsp;
			<input type="reset" name="reset" value="Reset"/>
		</div>
	</form>
</div>
EOD;


        $returndata = '';
        foreach($channels as $key => $channel) {
            $tempdata = '';
            $tempdata = str_replace("{i}", $channel['opmlindex'], $htmldata);
            
            $tempdata = str_replace("{zfurl}", ZF_URL, $tempdata);
            $tempdata = str_replace("{xmlurl}", htmlentities($channel['xmlurl']), $tempdata);
            $tempdata = str_replace("{description}", htmlentities($channel['description']), $tempdata);
            $tempdata = str_replace("{chantitle}", htmlentities($channel['title']), $tempdata);
            $tempdata = str_replace("{xmlurl}", htmlentities($channel['xmlurl']), $tempdata);
            $tempdata = str_replace("{position}", $channel['position'], $tempdata);
            $tempdata = str_replace("{refreshtime}", $channel['refreshtime'], $tempdata);
            $tempdata = str_replace("{showeditems}", $channel['showeditems'], $tempdata);
            if ($channel['issubscribed'] == 'yes') {
                $tempdata = str_replace('{issubscribed}', 'checked="checked"', $tempdata);
            } else {
                $tempdata = str_replace('{issubscribed}', '', $tempdata);
            }
            echo $tempdata;
        }
    }

}

// if we come from the zebrabar, zflist is in the _GET array
/*if (isset($_GET['zflist']) && $_GET['zflist']!='') {
    $_POST['zflist'] = $_GET['zflist'];
}*/

// first thing to do: load the current list file in memory
$currentListName = zf_getCurrentListName();

if (!empty($currentListName)) {
    $list = new opml($currentListName);
}

/* ------------------
handling of actions
--------------------*/
// all results formated in a block

/* save: not used anymore
*/
if ( ($_POST['save'] == 'save changes') || ($_POST['save2'] == 'save changes') ) {

    echo '<div id="core">';
    if ($list->load()) {

        $list->options['viewmode'] = $_POST["zfviewmode"];
        $list->options['trimtype'] = $_POST["zftrimtype"];
        $list->options['trimsize'] = $_POST["zftrimsize"];
        if ($list->save()) {
            displayStatus($list->lastResult);
        } else {
            displayStatus($list->lastError);
        }
        displayGotoButton($list->name);
    }
    echo '</div>';
//----------------------------------------------------------------------------
/* delete feeds */
} elseif ($_POST['delete'] == 'delete') {
    echo '<div id="core">';
    if ($list->load()) {
        $done = 0;
        // make a copy
        //$newList = $list;
        echo "Deleting feeds <ul>";
        $initialCount = count($list->channels);
        for($i = 0;$i < $initialCount; $i++) {
            if ($_POST["actionbox$i"] == 'checkbox') {
                echo '<li>'.$list->channels[$i]['title'].'</li>';
                /*also delete the history file
                $hst = new history($list->channels[$i]['xmlurl']);
                $hst->delete();*/
                $list->removeChannelAtPos($i);
               $done++;
            }
        }
        echo "</ul>";
        if ($done > 0) {
            if ($list->save()) {
                displayStatus($list->lastResult);
            } else {
                displayStatus($list->lastError);
            }
            displayGotoButton($list->name);
        } else {
            displayStatus("No channel selected");
        }
    } else {
        displayStatus("Error opening the subscription list for reading !");
    }
    echo '</div>';
    //----------------------------------------------------------------------------
    /* create list */
} elseif ($_POST['createlist'] == 'Create new list...') {
    echo '<div id="core">';
    $list = new opml($_POST['newlistname']);
    if ($list->create()) {
        displayStatus($list->lastResult);
        displayGotoButton($list->name);
    } else {
        displayStatus($list->lastError);
    }
    echo '</div>';
//----------------------------------------------------------------------------
/* delete list */
} elseif ($_POST['deletelist'] == 'Delete current list') {
    echo '<div id="core">';
    if ($list->delete()) {
        displayStatus($list->lastResult);
        displayGotoButton();
    } else {
        displayStatus($list->lastError);
        displayGotoButton($list->name);
    }
    echo '</div>';
//----------------------------------------------------------------------------
/* rename list */
} elseif ($_POST['renamelist'] == 'Rename list...') {
    echo '<div id="core">';
    if ($list->rename($_POST['listnewname'])) {
        displayStatus($list->lastResult);
        displayGotoButton($_POST['listnewname']);
    } else {
        displayStatus($list->lastError);
        displayGotoButton($list->name);
    }
    echo '</div>';
//----------------------------------------------------------------------------
/*copy feeds to another list */
} elseif ($_POST['move'] == 'move') {
    echo '<div id="core">';
    $targetList = new opml($_POST['zfdestlist']);
    
    if ($list->load() && $targetList->load()) {

        $done = 0;
        $nextpos = $targetList->getNextPosition();
        
        /* see which feeds have been selected */
        echo "Moving channels to <strong>".$targetList->name."</strong><ul>";
        $initialCount = count($list->channels) ;
        
        for($i = 0;$i < $initialCount;$i++) {
            if ($_POST["actionbox$i"] == 'checkbox') {
                $movingChannel = $list->channels[$i];
                echo '<li>'.$movingChannel['title'].'</li>';
                $movingChannel['position'] = $nextpos++;
                $targetList->channels[] = $movingChannel;
                $list->removeChannelAtPos($i);
                $done++;
            }
        }
        echo "</ul>";
        
        if ($done > 0) {
            if ($targetList->save()) {
                if ($list->save()) {
                    displayStatus ($targetList->lastResult.'<br/>'.$list->lastResult);
                    displayGotoButton($targetList->name);
                } else {
                    displayStatus($list-lastError);
                    displayGotoButton($list->name);
                }
                
            } else {
                displayStatus($targetList->lastError);
                displayGotoButton($targetList->name);
            }
        } else {
            displayStatus("No channel selected");
        }
        
    } else {
        displayStatus("Error opening the subscription list(s) for reading !");
    }
    echo '</div>';

//----------------------------------------------------------------------------
/* copy feeds to another list */
} elseif ($_POST['copy'] == 'copy') {
    echo '<div id="core">';
    $targetList = new opml($_POST['zfdestlist']);
    
    if ($list->load() && $targetList->load()) {

        $done = 0;
        $nextpos = $targetList->getNextPosition();
        
        /* see which feeds have been selected */
        echo 'Copying channels to <strong>'.$targetList->name."</strong><ul>";
        $initialCount = count($list->channels) ;
        
        for($i = 0;$i < $initialCount;$i++) {
            if ($_POST["actionbox$i"] == 'checkbox') {
                $movingChannel = $list->channels[$i];
                echo '<li>'.$movingChannel['title'].'</li>';
                $movingChannel['position'] = $nextpos++;
                $targetList->channels[] = $movingChannel;
                $done++;
            }
        }
        echo '</ul>';
        
        if ($done > 0) {
            if ($targetList->save()) {
                displayStatus($targetList->lastResult);
                displayGotoButton($targetList->name);
            } else {
                displayStatus($targetList->lastError);
                displayGotoButton($targetList->name);
            }
        } else {
            displayStatus("No channel selected");
        }
        
    } else {
        displayStatus("Error opening the subscription list(s) for reading !");
    }

    echo '</div>';

} else {
//----------------------------------------------------------------------------
/* default case : display channels table, with list control form on top */

    
?>
	<div id="core">
	<div id="listsform" align="center">
		<form name="zflists" action="<?php echo $_SERVER['PHP_SELF'];?>?zfaction=subscriptions" method="post">
			<?php
				if (!empty($currentListName)) {
					
				?>
				&nbsp; Display list: &nbsp;
			<select name="zflist" onchange="this.form.submit();">
				<?php echo zf_ListsFormElements($currentListName); ?>
			</select>
			&nbsp;
			<input name="deletelist" type="submit" id="deletelist" value="Delete current list" onclick="return confirm('Are you sure you want delete the list: <?php echo $currentListName;?>?')"/>
			<input name="listnewname" type="hidden" id="listnewname"/>
        <input name="renamelist" type="submit" id="renamelist" value="Rename list..." onclick="var name = prompt('New name', '<?php echo $currentListName; ?>'); if (name) {document.getElementById('listnewname').value = name; return true;} else {return false;}"/>
			&nbsp;
			<a href="<?php echo $list->getURL(); ?>">Export OPML file</a>
			<?php
				} else {
					echo "No list available ";
				}
			?>
			&nbsp;
			<input name="newlistname" type="hidden" id="createlistname"/>
			<input name="createlist" type="submit" id="createlist" value="Create new list..." onclick="var name = prompt('Name of the new list'); if (name) {document.getElementById('createlistname').value = name; return true;} else {return false;}"/>
	</form>
	</div>

  
<?php
    if ($list->load() ) {
        if ($list->options['viewmode'] == 'feed' ) {
            $sortedChannels = sortChannelsByPosition($list->channels);
        } else {
            $sortedChannels = sortChannelsByName($list->channels);
        }
?>
		<script language="JavaScript" type="text/javascript">
			var currentid = -1;
			/* 0: id; 1:title; 2; subscribed */
			var channeldata = new Array(3);
			var savedtitle  ='';
			var savedid = -1;
			var savebutton;
			function showEditForm(id) {
				if (currentid != id) {
					if (currentid != -1) {
						toggleVisibleById('editform' + currentid);
					}
					currentid = id;
					toggleVisibleById('editform' + currentid);
				}

				/* hide the last operation result */
				document.getElementById('opresult').style.display = 'none';
				/* make sure its save button is enabled*/
				//savebutton = document.getElementById('editform' + currentid).elements["save"];
				//savebutton.disabled = false;
			}
			
			function toggleChecks() {
				void(d=document);
				void(el=d.getElementsByTagName('INPUT'));
				for(i=0;i<el.length;i++) { 
					if(document.subscriptionsform.checkboxall.checked==1) { 
						void(el[i].checked=1) 
					} else {
						void(el[i].checked=0)
					}
				}
			}
			
			function onUpdateViewMode(index) {
				switch (index) { 
					case 1: 
						document.getElementById('trimoptions').style.display='inline'; 
						break;

					default:
						document.getElementById('trimoptions').style.display='none'; 
						break;
				}
			}


			function saveChannel(id, aform) {
				var title  = encodeURIComponent(aform.elements["chantitle"].value);
				var xmlurl = encodeURIComponent(aform.elements["xmlurl"].value);
				var description = encodeURIComponent(aform.elements["description"].value);
                
				var position = aform.elements["position"].value;
				if (aform.elements["issubscribed"].checked) {
					var issubscribed = 'yes';
				} else { 
					var issubscribed = 'no';
				}
				var showeditems = aform.elements["showeditems"].value;
				var refreshtime = aform.elements["refreshtime"].value;
				
				savebutton = aform.elements["save"];
				savebutton.disabled = true;
				
				var statusbox = document.getElementById('opresult');
				statusbox.style.display = 'none';
				statusbox.innerHTML = '';

				// keep title and id in memory to update them later
				// flawed if we have a fast updater user
				channeldata[0] = id;
				channeldata[1] = aform.elements["chantitle"].value;
				channeldata[2] = issubscribed;
				
				http.open('POST', 'cmd.php', true);
				http.setRequestHeader("Content-type","application/x-www-form-urlencoded");
				
				http.onreadystatechange = onSaveCallback;
				var query= "action=savechannel&index=" + id
								+ "&list=" + encodeURIComponent('<?php echo $currentListName; ?>') 
								+ "&title=" + title
								+ "&xmlurl=" + xmlurl
								+ "&description=" + description
								+ "&position=" + position
								+ "&issubscribed=" + issubscribed
								+ "&showeditems=" + showeditems
								+ "&refreshtime=" + refreshtime;
				http.send(query);
			}
			
			function onSaveCallback() {
				if (http.readyState == 4) { // Complete
					if (http.status == 200) { // OK response
						var statusbox = document.getElementById('opresult');
						statusbox.innerHTML = http.responseText;
						statusbox.style.display = 'block';
						savebutton.disabled = false;
						/* update channel list */
						var titletext = document.getElementById('title'+channeldata[0]);
						titletext.innerHTML = channeldata[1];
						if (channeldata[2] == 'yes') {
							titletext.className = 'subscribed';
						} else {
							titletext.className = 'unsubscribed';
						}
					}
				}
			}
				
		</script>
		<script language="Javascript" type="text/javascript" src="../zfcontrol.js"></script>
		<script language="Javascript" type="text/javascript" src="../zfclientside.js"></script>
		<div id="subscriptions">
			<form name="subscriptionsform" action="<?php echo $_SERVER['PHP_SELF'] . '?zfaction=subscriptions';?>" method="post">
				<input name="zflist" type="hidden" id="zflist" value="<?php echo $currentListName;?>"/>
				<div class="editfeed">
					Default view
					<select name="zfviewmode" onchange="index=this.selectedIndex; onUpdateViewMode(index);">
						<option value="feed" <?php echo ($list->options['viewmode'] == 'feed') ? 'selected="selected"' : '';?> >By channel</option>
						<option value="trim" <?php echo ($list->options['viewmode'] == 'trim') ? 'selected="selected"' : '';?> >View only last...</option>
						<option value="date" <?php echo ($list->options['viewmode'] == 'date') ? 'selected="selected"' : '';?> >By date - view all news)</option>
					</select>
					<div id="trimoptions" style="display: <?php echo ($list->options['viewmode'] == 'trim')? 'inline' : 'none'; ?>">
						<input name="zftrimsize" type="text" size="3" value="<?php echo $list->options['trimsize']; ?>"/>
						<select name="zftrimtype">
							<option value="days" <?php echo ($list->options['trimtype'] == 'days') ? 'selected="selected"' : '';?> >days</option>
							<option value="news" <?php echo ($list->options['trimtype'] == 'news') ? 'selected="selected"' : '';?> >news</option>
							<option value="hours" <?php echo ($list->options['trimtype'] == 'hours') ? 'selected="selected"' : '';?> >hours</option>
						</select>
					</div>
					<input name="save" type="submit" id="save" value="save changes" style="position: absolute; right: 40px;"/>
				</div>
				<div id="chancolumn">
					<div style="margin-top:10px; margin-bottom: -15px;margin-left: 13px">
						<input type="checkbox" name="checkboxall" value="checkbox" title="check/uncheck all" onclick="Javascript:toggleChecks()"/> toggle all
					<?php echo ($list->options['viewmode'] == 'feed')?'<span style="position: relative; left: 60px; color: #aaa">
						<small><em>Sorted by position</em></small> </span>':'';?>
					</div>
					<div id="chanlist">
						<?php displayChannelList($sortedChannels);?>
					</div>

                <?php    if (count($sortedChannels) > 0) { ?>

					<div>
						<strong>Selection:</strong> <br/>
						<ul>
                <?php  $liststr = listExceptCateg($currentListName);
                  if (strlen($liststr) > 0) { ?>
						
						<li>Send to list:&nbsp;
						<select name="zfdestlist">
						<?php
							echo listExceptCateg($currentListName);
						?>
						</select>

						<input name="copy" type="submit" id="copy" value="copy" onclick="if (!confirm('Are you sure you want to copy the selected feeds?')) {return false;}"/>
						<input name="move" type="submit" id="move" value="move" onclick="if (!confirm('Are you sure you want to move the selected feeds?')) {return false;}"/>
						<!--span class="link" title="Copy selected feeds to another list" onclick="if (confirm('Are you sure you want to copy the selected feeds?')) {document.getElementById('copy').click()};return false;">Copy</span>
						<span class="link" title="Move selected feeds to another list" onclick="if (confirm('Are you sure you want to move the selected feeds?')) {document.getElementById('move').click()};return false;">Move</span-->
						</li>
			     <?php } ?>
						<li>
						<input name="delete" type="submit" id="delete" value="delete" onclick="if (!confirm('Are you sure you want to delete the selected feeds?')) {return false;}"/>
						<!--span class="link" title="Delete selected feeds" onclick="if (confirm('Are you sure you want to delete the selected feeds?')) {document.getElementById('delete').click()};return false;">Delete</span-->
						</li></ul>
					</div>
                <?php } ?>
				</div>
			</form>
			<div id="editcolumn" >
				<?php displayChannelEditForm($sortedChannels);?>
					<div id="opresult">
					</div>
			</div>  
		</div>
	</div>
<?php
	} else {
			echo '<div id="core">';
			displayStatus($list->lastError);
			echo '</div>';
	}
 } 
?>
