<?php
// ZebraFeeds - copyright (c) 2006 Laurent Cazalet
// http://www.cazalet.org/zebrafeeds
//
// zFeeder 1.6 - copyright (c) 2003-2004 Andrei Besleaga
// http://zvonnews.sourceforge.net
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


/* template for the admin page */

/* initialization part */
require_once('../init.php');
require_once($zf_path.'admin/adminfuncs.php');
ini_set("user_agent",ZF_USERAGENT);

$zfaction = isset($_GET['zfaction']) ? $_GET['zfaction'] : '';

if ($zfaction == 'logout')
    zfLogout();

    
zfLogin();


?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

	<html>
	<head>
	<title>ZebraFeeds admin panel</title>
	<link rel="stylesheet" type="text/css" href="admin.css"/>
	</head>
	<body>


	<div id="top">
<div class="normaltext"><a href="http://cazalet.org/zebrafeeds"><img src="<?php echo ZF_URL;?>/images/logo_admin.png" border="0" alt="ZebraFeeds"/></a></div>
       <div class="normaltext">administration panel</div>
			<a href="<?php echo $_SERVER['PHP_SELF'] . '?zfaction=logout';?>">Logout</a>
                <br/>
	</div>
<div id="header">
			<ul class="tabs">
		<li <?php if ($zfaction == '') echo " class=\"active\"";?>>
			<a href="<?php echo $_SERVER['PHP_SELF'];?>">Main</a>
		</li>
		<?php if (ZF_USEOPML == 'yes') 
            echo "<li"; if ($zfaction == "addnew") echo " class=\"active\""; echo ">"; 
			echo "<a href=\"" . $_SERVER['PHP_SELF'] . "?zfaction=addnew\">Add new</a></li>";?>
		<?php if (ZF_USEOPML == 'yes')
            echo "<li"; if ($zfaction == "subscriptions") echo " class=\"active\""; echo ">";
			echo "<a href=\"" . $_SERVER['PHP_SELF'] . "?zfaction=subscriptions\">Subscriptions</a></li>";?>
        <?php echo "<li"; if ($zfaction == "config") echo " class=\"active\""; echo ">" ?>
			<a href="<?php echo $_SERVER['PHP_SELF'] . '?zfaction=config';?>">Config</a>
		</li>
		<?php if (ZF_USEOPML == 'yes') 
            echo "<li"; if ($zfaction == "importlist") echo " class=\"active\""; echo ">";
			echo "<a href=\"" . $_SERVER['PHP_SELF'] . "?zfaction=importlist\">Import feed list</a></li>";?>
		<li <?php if ($zfaction == "updates") echo " class=\"active\""; ?>>
			<a href="<?php echo $_SERVER['PHP_SELF'] . '?zfaction=updates';?>">Updates</a>
		</li>
		<?php if (defined('ZF_HOMEURL') && strlen(ZF_HOMEURL)>0) 
			if ($zfaction == 'subscriptions') {
                echo '<li><a href="'.ZF_HOMEURL.'?zflist='.urlencode(zf_getCurrentListName()).'">View website</a></li>';
            } else {
                echo '<li><a href="'.ZF_HOMEURL.'">View website</a></li>';
            }?>
        
		</ul>
		
	
</div>
<?php
// after the normal header for all admin pages, select now what we gonna show

	if ($zfaction == 'subscriptions') {
        include($zf_path.'admin/subscriptions.php');
    } elseif ($zfaction == 'addnew') {
        include($zf_path.'admin/addnewfeed.php');
    } elseif ($zfaction == 'importlist') {
        include($zf_path.'admin/importlist.php');
	} elseif ($zfaction == 'config') {
        include($zf_path.'admin/changeconfig.php');
	} elseif ($zfaction == 'updates') {
   
        echo '<div id="core"><h3>Updates</h3>';
        echo "Your ZebraFeeds version: " . ZF_VER . "<br/><br/>";
        @$update = readfile('http://www.cazalet.org/zebrafeeds/latest.php');
        if (!$update)
            echo "Error: could not open update file.<br/><br/>You can check it manually at: <a href=\"http://cazalet.org/zebrafeeds/latest.php\">http://cazalet.org/zebrafeeds/latest.php</a>.";
        echo '<br/><br/></div>';
	} elseif ($zfaction == 'cleanold') {
       $size = clearOldData($zf_path.ZF_DATADIR, 60*60*24*14, "hst");
       $size += clearOldData(MAGPIE_CACHE_DIR, 60*60*24*14);
        echo '<div id="core"><h3>Clean up</h3>';
        echo "Cleared cache and history files older than 2 weeks.<br/>";
        $size = sprintf("%01.2f KiloBytes",$size / 1024);
        echo "$size recovered on server.";
        echo '<br/><br/></div>';
	} elseif ($zfaction == 'flush') {
       $size = clearOldData($zf_path.ZF_DATADIR, 0, "hst");
       $size += clearOldData(MAGPIE_CACHE_DIR, 0);
        echo '<div id="core"><h3>Clean up</h3>';
        echo "Flushed cache and history files.<br/>";
        $size = sprintf("%01.2f KiloBytes",$size / 1024);
        echo "$size recovered on server.";
        echo '<br/><br/></div>';
    } else { 

        // repeat of top bar 
?>

	<div id="core">
		 <h3>Welcome <?php echo ZF_ADMINNAME;?> !</h3>
		<div class="normaltext">
			<div id="startmenu">
			<?php if (ZF_USEOPML == 'yes') { 
					?>
				<div class="menuitem">
				Manage your subscriptions lists. <ul><li><?php displayGotoButton('');?></li>
				<li><a href="<?php echo $_SERVER['PHP_SELF'] . '?zfaction=addnew'; ?>">Subscribe</a> to a feed.</li>
					</ul>
				</div>
			<?php } ?>
				<div class="menuitem"> Manage cached data
					<ul>
					<li>
						<a href="<?php echo $_SERVER['PHP_SELF'] . '?zfaction=cleanold';?>" onclick="return confirm('Are you sure you want to delete old cache and history data?');">Clean up</a>
						- clean up caches and history older than 2 weeks. 
					</li>
					<li>
						<a href="<?php echo $_SERVER['PHP_SELF'] . '?zfaction=flush';?>" onclick="return confirm('Are you sure you want to delete ALL cache and history data?');">Flush!</a>
						- flush ALL caches and history. 
					</li>
					</ul>
				</div>
				<div class="menuitem">
					<ul>
					<li><a href="<?php echo $_SERVER['PHP_SELF'] . '?zfaction=config';?>">Config</a>
						- Edit ZebraFeeds configuration</li>
					<li><a href="<?php echo $_SERVER['PHP_SELF'] . '?zfaction=updates';?>">Check for updates</a></li>
					</ul>
				</div>
			</div>
		</div>
	</div>

<?php 
    }
// Standard footer for all admin pages
?>
    <div id="bottom">
          powered by <a href="http://cazalet.org/zebrafeeds">ZebraFeeds <?php echo ZF_VER;?></a>
          - &copy;2006-2009 by Laurent Cazalet
    </div>
</body>
</html>
