<?php
class Xml_Export {
public static function __table($econfig){
		if(empty($econfig['table'])){
			$db = new Mysql_DB();
			$tables = $db->tables;
		}else{
			$tables[] = $econfig['table'];
		}
		$dump .= self::beginXML();
		$dbname = self::getDBname();
		$dump .= self::beginDbXML($dbname);
		foreach ($tables as $table){
			if(is_object($table)){
				$tbl = $table->Name;
			}else{
				$tbl = $table;
			}
			$dump .= self::exportTableXML($econfig, $tbl);
		}
		$dump .= self::endDbXML($dbname);
		return $dump;
	}
	protected function getDBname(){
		global $link;
		$mysqlOBJ = new Mysql_Data_Handler($link, '', true);
		return $mysqlOBJ->__dataScalar("select DATABASE();");
	}
	protected function beginXML(){
		global $link;
		$mysqlOBJ = new Mysql_Data_Handler($link, '', true);
		$dbcharset = $mysqlOBJ->__dataScalar("SHOW VARIABLES LIKE 'character\_set\_database';");
		return "<?xml version=\"1.0\" encoding=\"{$dbcharset}\" ?>"."\n";
		
	}
	protected function beginDbXML($dbname){
		return "<{$dbname}>\n";
	}
	protected function endDbXML($dbname){
		return "</{$dbname}>";
	}
	protected function exportTableXML($econfig, $table){
		global $link;
		$mysqlOBJ = new Mysql_Data_Handler($link, '', true);
		$result = $mysqlOBJ->__dataTable("SELECT * FROM {$table}");
		$num_rows   = $mysqlOBJ->__dataNum_rows();
		$num_fields = $mysqlOBJ->__dataNum_fields();
		if($num_rows != false){
			foreach ($result as $red){
				$x = 0;
				$data .= "\t<{$table}>\n";
				foreach ($red as $key=>$val){
					$field_name = $key;
					$data .= "\t\t<{$field_name}>".htmlspecialchars($red[$field_name])."</{$field_name}>\n";
				}
				$data .= "\t</{$table}>\n";
				
			}
		}
	return htmlspecialchars($data);
	}
}

?>