<?php
class Mysql_DB{
	public $dbname;
	public $server_info;
	public $tables = array();
	
	public function __construct(){
		$this->getdbname();
		$this->gettables();
		$this->get_server_info();
	}
	private function getdbname(){
		global $link;
		$sql = "SELECT DATABASE();";
		$mysqlOBJ = new Mysql_Data_Handler($link, '', true);
		$this->dbname = $mysqlOBJ->__dataScalar($sql);
	}
	private function gettables(){
		global $link;
		$sql = "SHOW TABLES";
		$mysqlOBJ = new Mysql_Data_Handler($link, '', true);
		foreach ($mysqlOBJ->__dataTable($sql) as $table){
			foreach ($table as $value){
				$this->tables[] = new Mysql_Table($value);
			}
		}
	}
	private function get_server_info(){
		global $link;
		$sql = "SELECT VERSION();";
		$mysqlOBJ = new Mysql_Data_Handler($link, '', true);
		$version = $mysqlOBJ->__dataScalar($sql);
		preg_match('/[0-9\.]*/', $version, $matches);
		$this->server_info = $matches[0];
	}
	
}

class Mysql_Table{
	
	protected $link;
	
	public $Name;
	public $Engine;
	public $Version;
	public $Row_Format;
	public $Rows;
	public $Avg_rows_lenght;
	public $Data_lenght;
	public $Max_data_lenght;
	public $Index_length;
	public $Data_free ;
	public $Auto_increment ;
	public $Create_time ;
	public $Update_time ;
	public $Check_time ;
	public $Collation;
	public $Checksum;
	public $Create_options ;
	public $Comment;
	
	
	
	public $structure;
	public $indexes;
	
	public function __construct($name){
		$this->Name = $name;
		$this->get_field_names();
		$this->get_keys();
		$this->get_table_status();
		
	}
	private function get_table_status(){
		global $link;
		$sql = "SHOW TABLE STATUS WHERE Name = '".$this->Name."'";
		$mysqlOBJ = new Mysql_Data_Handler($link, '', true);
		$cols = $mysqlOBJ->__dataRow($sql);
			
		$this->Engine 			= $cols['Engine'];
		$this->Version			= $cols['Version'];
		$this->Row_format 		= $cols['Row_format'];
		$this->Rows 			= $cols['Rows'];
		$this->Avg_row_length 	= $cols['Avg_row_length'];
		$this->Data_length 		= $cols['Data_length'];
		$this->Max_data_length 	= $cols['Max_data_length'];
		$this->Index_length 	= $cols['Index_length'];
		$this->Data_free  		= $cols['Data_free'];
		$this->Auto_increment  	= $cols['Auto_increment'];
		$this->Create_time  	= $cols['Create_time'];
		$this->Update_time  	= $cols['Update_time'];
		$this->Check_time  		= $cols['Check_time'];
		$this->Collation 		= $cols['Collation'];
		$this->Checksum		 	= $cols['Checksum'];
		$this->Create_options  	= $cols['Create_options'];
		$this->Comment 			= $cols['Comment'];
		
	}
	private function get_field_names(){
		global $link;
		$sql = "SHOW FULL COLUMNS FROM ".$this->Name;
		$mysqlOBJ = new Mysql_Data_Handler($link, '', true);
		foreach ($mysqlOBJ->__dataTable($sql) as $cols){
			$this->structure[] = 	new Mysql_Table_Structure($cols);
		}
	}
	private function get_keys(){
		global $link;
		$sql = "SHOW KEYS FROM  ".$this->Name;
		$mysqlOBJ = new Mysql_Data_Handler($link, '', true);
		foreach ($mysqlOBJ->__dataTable($sql) as $cols){
			$this->indexes[] = new Mysql_Table_Index($cols);
		}
	}
}

class Mysql_Table_Structure{
	
	public $Field;
	public $Type;
	public $Collation;
	public $Null;
	public $Key;
	public $Default;
	public $Extra;
	public $Key_name;

	public function __construct($cols){
		$this->Field = $cols['Field'];
		$this->Type = $cols['Type'];
		$this->Collation = $cols['Collation'];
		$this->Null = $cols['Null'];
		$this->Key = $cols['Key'];
		$this->Default = $cols['Default'];
		$this->Extra = $cols['Extra'];
		$this->Key_name = $cols['Key_name'];
	}
	
}

class Mysql_Table_Index{
	
	public $Non_unique;
	public $Key_name;
	public $Seq_in_index;
	public $Column_name;
	public $Collation;
	public $Cardinality;
	public $Sub_part;
	public $Packed;
	public $Null;
	public $Index_type;
	public $Comment;
	
	public function __construct($cols){
		$this->Non_unique 	=  $cols['Non_unique'];
		$this->Key_name 	=  $cols['Key_name'];
		$this->Seq_in_index =  $cols['Seq_in_index'];
		$this->Column_name 	=  $cols['Column_name'];
		$this->Collation 	=  $cols['Collation'];
		$this->Cardinality	=  $cols['Cardinality'];
		$this->Sub_part 	=  $cols['Sub_part'];
		$this->Packed 		=  $cols['Packed'];
		$this->Null 		=  $cols['Null'];
		$this->Index_type 	=  $cols['Index_type'];
		$this->Comment 		=  $cols['Comment'];
	}
}
class Mysql_Table_Value extends Mysql_Table_Structure{
	public $value;
	public function __construct($cols){
		parent::__construct($cols);
		$this->value = $cols['value'];
	}
}
?>