<?php
/*
 * Db_Conncet v2.0.1
 */
class Db_Connect{
	
	protected $dbtype;
	protected $dbhost;
	protected $dbuser;
	protected $dbpass;
	protected $dbname;
	protected $dbport;
	protected $link;
	
	public function __construct(){
		$numargs = func_num_args();
		$config = func_get_arg(0);
        if ($numargs == 1 && is_array($config) && count($config) == 6) {
           
			$this->Init($config);
			
			
        }else{
        	exit('Error: Configuration parameter is missing!');
        	 
        }
		
	}
	public function __connect(){
		return $this->Dbtype();
	}
	
	private function Init($config){
		$this->dbtype = strtolower($config['type']);
		$this->dbhost = $config['host'];
		$this->dbuser = $config['user'];
		$this->dbpass = $config['pass'];
		$this->dbname = $config['name'];
		$this->dbport = $config['port'];
	}
	
	private function Dbtype(){
		switch($this->dbtype){
			case "mysql": 
				$this->link = mysql_connect($this->dbhost, $this->dbuser, $this->dbpass);
				if($this->link === false){
					$error = 'Error: Can not connect to database!';
					return $error;
				}
				if(mysql_select_db($this->dbname, $this->link) === false){
					$error = 'Error: Can not use this Database!';
					return $error;
				}
				return true;
			break;
			case "postgresql": 
				$this->link = @pg_connect("host=".$this->dbhost." dbname=".$this->dbname." port=".$this->dbport." user=".$this->dbuser." password=".$this->dbpass);
			break;
			case "oracle":
				$this->link = @OCILogon($this->dbuser, $this->dbpass, $this->dbname); 
			break;
			case "sqlite":
				$this->link = sqlite_open($this->dbname) or die('Error: Can not use this Database!');
			break;
			case "mssql":
				$this->link = @mssql_connect($this->dbhost, $this->dbuser, $this->dbpass) or die('Error: Can not connect to database!');
				@mssql_select_db($this->dbname) or die('Error: Can not use this Database!');
			break;
			default:
				exit("Error: Database Type Not Specified [MySql, MSSql, Oracle, PostGreSql, SqLite]");
		} // switch
				
	}
	public function __getLink(){
		return $this->link;
	}
}
?>