<?php
/**
 * File v1.0
 *
 * PHP versions 5
 *
 * Class File is based on PEAR's FILE class v 1.38
 * 
 * @link        http://pear.php.net/package/File
 * 
 */
require_once 'PEAR.php';
if (!defined('FILE_MAX_LINE_READSIZE')) {
    define('FILE_MAX_LINE_READSIZE', 40960, true);
}

/**
 * Whether file locks should block
 */
if (!defined('FILE_LOCKS_BLOCK')) {
    define('FILE_LOCKS_BLOCK', true, true);
}

/**
 * Mode to use for reading from files
 */
define('FILE_MODE_READ', 'rb', true);

/**
 * Mode to use for truncating files, then writing
 */
define('FILE_MODE_WRITE', 'wb', true);

/**
 * Mode to use for appending to files
 */
define('FILE_MODE_APPEND', 'ab', true);

/**
 * Use this when a shared (read) lock is required
 */
define('FILE_LOCK_SHARED', LOCK_SH | (FILE_LOCKS_BLOCK ? 0 : LOCK_NB), true);

/**
 * Use this when an exclusive (write) lock is required
 */
define('FILE_LOCK_EXCLUSIVE', LOCK_EX | (FILE_LOCKS_BLOCK ? 0 : LOCK_NB), true);

class File extends PEAR{
	
	public function __file_exists($filename){
        if (file_exists($filename)) {
            return true;
        }
		return false;
    }
	public function __write($filename, $data, $mode = FILE_MODE_WRITE, $lock = false){
        $fp = File::getFilePointer($filename, $mode, $lock);
        if (PEAR::isError($fp)) {
            return $fp;
        }

        if (false === $bytes = @fwrite($fp, $data, strlen($data))) {
        	@fclose($fp);
            return PEAR::raiseError("Cannot write data: '$data' to file: '$filename'");
        }

        return $bytes;
    }
    
    
    
    protected function getFilePointer($filename, $mode, $lock = false){
        $filePointers = &PEAR::getStaticProperty('File', 'filePointers');

        // Win32 is case-insensitive
        if (OS_WINDOWS) {
            $filename = strtolower($filename);
        }

        // check if file pointer already exists
        if (!isset($filePointers[$filename][$mode]) ||
            !is_resource($filePointers[$filename][$mode])) {

            // check if we can open the file in the desired mode
            switch ($mode)
            {
                case FILE_MODE_READ:
                    if (!preg_match('/^.+(?<!file):\/\//i', $filename) &&
                        !file_exists($filename)) {
                        return PEAR::raiseError("File does not exist: $filename");
                    }
                break;

                case FILE_MODE_APPEND:
                case FILE_MODE_WRITE:
                    if (file_exists($filename)) {
                        if (!is_writable($filename)) {
                            return PEAR::raiseError("File is not writable: $filename");
                        }
                    } elseif (!is_writable($dir = dirname($filename))) {
                        return PEAR::raiseError("Cannot create file in directory: $dir");
                    }
                break;

                default:
                    return PEAR::raiseError("Invalid access mode: $mode");
            }

            // open file
            $filePointers[$filename][$mode] = @fopen($filename, $mode);
            if (!is_resource($filePointers[$filename][$mode])) {
                return PEAR::raiseError('Failed to open file: ' . $filename);
            }
        }

        // lock file
        if ($lock) {
            $lock = $mode == FILE_MODE_READ ? FILE_LOCK_SHARED : FILE_LOCK_EXCLUSIVE;
            $locks = &PEAR::getStaticProperty('File', 'locks');
            if (@flock($filePointers[$filename][$mode], $lock)) {
                $locks[] = &$filePointers[$filename][$mode];
            } elseif (FILE_LOCKS_BLOCK) {
                return PEAR::raiseError("File already locked: $filename");
            } else {
                return PEAR::raiseError("Could not lock file: $filename");
            }
        }

        return $filePointers[$filename][$mode];
    }
}
?>