<?php
class Session{

	private $loggedin;
	public $id_user;

	public function __construct(){
		session_cache_limiter('nocache');
		session_cache_expire(30);
		session_name("dbmanager");
		session_start();
		$this->checkStatus();
	}
	public function __isLoggedIn(){
		return $this->loggedin;
	}
	public function __login($user){
		if($user){
			$this->id_user = $_SESSION['id_user'] = $user;
			$this->loggedin = true;
		}
	}
	public function __logout(){
		unset($_SESSION['id_user']);
		unset($this->id_user);
		$this->loggedin = false;
	}

	private function checkStatus(){
		if(isset($_SESSION['id_user'])){
			$this->id_user = $_SESSION['id_user'];
			$this->loggedin = true;
		}else{
			unset($this->id_user);
			$this->loggedin = false;
		}
	}
}
?>