<?php
//gzip settings
//ini_set('zlib.output_compression', 'On');

session_start();
$approot = '';


//check for config file.
if (!file_exists($approot.'_includes/config.inc.php')) {
	//send to install
	include($approot.'install.php');
	exit();
}

// now that all is well, include config files.
require_once($approot.'_includes/config.inc.php');
require_once($approot.'_includes/settings.inc.php');

//admin section redirections
if (isset($_GET['admin']) && $afbAccount->account['account_admin'] == 'yes'){
	//jump to admin
	include($approot.'_includes/admin/index.php');
	exit();
}


//check for previews and downloads.
if (isset($_GET['preview'])){
	include($approot.'_includes/preview.php');
	exit();
} elseif (isset($_GET['download'])){
	include($approot.'_includes/download.php');
	exit();
}

?><!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title><?php echo $settings['site_name']; ?> :: <?php echo strtolower(trim($_SERVER['HTTP_HOST'],'/')); ?></title>
	<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
	<style type="text/css" media="all">@import "<?php echo THEMEDIR; ?>style.css.php";</style>
	<script type="text/javascript" src="<?php echo BASEURL; ?>_js/core.js.php"></script>
	<script type="text/javascript" src="<?php echo BASEURL; ?>_js/afb.js.php"></script>
	<script type="text/javascript" src="<?php echo THEMEDIR; ?>theme.js.php"></script>
	<!--[if IE 7]>
	<link href="<?php echo THEMEDIR; ?>ie7.css.php" rel="stylesheet" type="text/css" media="screen, projection" />
	<![endif]-->
	<!--[if IE 6]>
	<link href="<?php echo THEMEDIR; ?>ie6.css.php" rel="stylesheet" type="text/css" media="screen, projection" />
	<![endif]-->
	<!--[if lt IE 6]>
	<link href="<?php echo THEMEDIR; ?>ie5.css.php" rel="stylesheet" type="text/css" media="screen, projection" />
	<![endif]-->
</head>

<body id="body">
	<div id="wrapper">
		
		<div id="head">
			<div id="head_left">
				&nbsp;
			</div>
			
			<h2><?php echo $settings['site_name']; ?></h2>

			<div id="head_right">
				&nbsp;
			</div>
			
			<div id="menu">
				<ul>
					<li><a href="javascript:void(null);" title="<?php echo getLangTerm('shares',false); ?>" id="shares_link"><span><?php echo getLangTerm('shares',false); ?></span></a></li>
					<li><a href="javascript:void(null);" title="<?php echo getLangTerm('view',false); ?>" id="views_link" style="display:none;"><span><?php echo getLangTerm('view',false); ?></span></a></li>
					<li><a href="javascript:void(null);" title="<?php echo getLangTerm('login',false); ?>" id="login_link"<?php if (isset($afbAccount)) { ?> style="display:none;"<?php } ?>><span><?php echo getLangTerm('login',false); ?></span></a></li>
					<li><a href="javascript:void(null);" title="<?php echo getLangTerm('logout',false); ?>" id="logout_link"<?php if (isset($afbAccount)) { ?> style="display:block;"<?php } else { ?> style="display:none;"<?php } ?>><span><?php echo getLangTerm('logout',false); ?></span></a></li>
					<li><a href="javascript:void(null);" title="<?php echo getLangTerm('file-operations',false); ?>" id="fileops_link" style="display:none;"><span><?php echo getLangTerm('file-operations',false); ?></span></a></li>
					<li><a href="javascript:void(null);" title="<?php echo getLangTerm('upload-here',false); ?>" id="upload_link" style="display:none;"><span><?php echo getLangTerm('upload-here',false); ?></span></a></li>
					<li><a href="<?php echo BASEURL; ?>index.php?admin" title="<?php echo getLangTerm('administration',false); ?>" id="admin_link"<?php if ($afbAccount->account['account_admin'] == 'yes'){ ?> style="display:block;"<?php } else { ?> style="display:none;"<?php } ?>><span><?php echo getLangTerm('administration',false); ?></span></a></li>
				</ul>
			</div>

		</div> <!-- end head -->
		
		
		<div id="main">
			<div id="main_left">
				&nbsp;
			</div>
			<div id="main_head">
				<p><?php echo getLangTerm('home',false); ?></p>
			</div>
			<div id="main_container">
				<div id="preview_pane">
					<div class="container" id="preview_pane_container">
						&nbsp;
					</div>
					<a href="javascript:void(null);" id="hide_pp">Hide Preview Pane</a>
				</div>
				<div id="main_content" class="view_details">
					
					<?php echo $settings['home_html']; ?>
				</div>
			</div>
			<div id="main_right">
				&nbsp;
			</div>
		</div> <!-- end main -->
		
		<div id="foot">
			<div id="foot_left">
				<p><?php 
					if (isset($afbAccount)) {
						echo getLangTerm('logged-in-as',false).' '.$afbAccount->account['account_name'];
					} else {
						echo getLangTerm('not-logged-in',false);
					}
				?></p>
			</div>
			<div id="foot_right">
				<p><?php
				if(strlen(trim($settings['site_footer'])) > 0) {
					if (strlen(trim($settings['site_footer_link'])) > 0) {
						?><a href="<?php echo $settings['site_footer_link']; ?>" title="<?php echo $settings['site_footer']; ?>"><?php echo $settings['site_footer']; ?></a><?php
					} else {
						echo $settings['site_footer'];
					}
				} else {
					?>&nbsp;<?php
				}
				?>
				</p>
			</div>
		</div> <!-- end foot -->
		
	</div> <!-- end wrapper -->
	<?php echo $settings['end_html']; ?>
</body>
</html>
