<?php
// ***********************************************************************************************
// AFB CLASS
// -----------------------------------------------------------------------------------------------
//ini_set('zlib.output_compression', 'On');
session_start();

$approot = '../';

//check for config file.
if (file_exists($approot.'_includes/config.inc.php')) {
	// now that all is well, include config files.
	require_once($approot.'_includes/config.inc.php');
	require_once($approot.'_includes/settings.inc.php');
}

header("Content-type: text/js");
?>
var AFB = new function() {
	
	this.errMsg = false;
	this.xmlFile = '<?php echo BASEURL; ?>_ajax.php';
	this.shares = new Array();
	this.currentShare = 0;
	this.currentPath = '/';
	this.downloading = false;
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// winLoad
	this.winLoad = function(e){
		AFB.getShares();
	} //end winLoad
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// getShares
	this.getShares = function(){
		getUrl(AFB.xmlFile+'?getShares',null,AFB.cbGetShares,function(){
			//ajax call has failed or timed out.
			//display error.
			AFB.errMsg = '<?php echo getLangTerm('no-connect'); ?>';
			THEME.showError(AFB.errMsg);
		});
	} //end getShares
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// cbGetShares
	this.cbGetShares = function(xhr){
		var err = checkResultForErr(xhr);
		if (err){
			//display error.
			AFB.errMsg = err;
			THEME.showError(unescape(AFB.errMsg));
			return;
		}
		
		//reinitialize
		AFB.shares = new Array();
		var xml = xhr.responseXML;
		var cnt = xmlTag('count',xml);
		if(parseInt(cnt)>0){
			var srs = xmlTags('share',xml);
			for(var i=0;i<srs.length;i++){
				AFB.shares[AFB.shares.length] = new Array(xmlTag('id',srs[i]),xmlTag('name',srs[i]),xmlTag('description',srs[i]),xmlTag('perm_list',srs[i]),xmlTag('perm_write',srs[i]),xmlTag('perm_download',srs[i]),xmlTag('perm_modify',srs[i]));
			}
		}
		THEME.updateShareList(AFB.shares);
		
	} //end getShares
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//loadShare - called by the theme class.
	this.loadShare = function(id,path){
		if (!id || id < 1){
			var id = AFB.currentShare;
		}
		if(!path){
			var path = '/';
		}
		
		AFB.currentPath = path;
		
		getUrl(AFB.xmlFile+'?getShare&share='+id+'&path='+escape(path),id,AFB.cbLoadShare,function(){
			//ajax call has failed or timed out.
			//display error.
			AFB.errMsg = '<?php echo getLangTerm('no-connect'); ?>';
			THEME.loadShare(false);
			THEME.showError(AFB.errMsg);
		});
	} //end loadShare
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// cbLoadShare
	this.cbLoadShare = function(xhr){
		var err = checkResultForErr(xhr);
		if (err){
			//display error.
			AFB.errMsg = unescape(err);
			THEME.loadShare(false);
			THEME.showError(AFB.errMsg);
			
			return;
		}
		
		//set current share id
		AFB.currentShare = xhr.argument;
		
		//return the xml to the theme class.
		THEME.loadShare(xhr.responseXML);
		
	} //end cbLoadShare
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// getPreviewInfo
	this.getPreviewInfo = function(path){
		if (!path){
			var path = AFB.currentPath;
		}

		getUrl(AFB.xmlFile+'?getPreviewInfo&share='+AFB.currentShare+'&path='+path,path,AFB.cbGetPreviewInfo,function(){
			//ajax call has failed or timed out.
			if (!AFB.downloading){
				//display error.
				AFB.errMsg = '<?php echo getLangTerm('no-connect'); ?>';
				THEME.hidePreviewLoading();
				THEME.showError(AFB.errMsg);
			} else {
				AFB.getPreviewInfo(path);
				AFB.downloading = false;
			}
		});
	} //end getPreviewInfo
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// cbGetPreviewInfo
	this.cbGetPreviewInfo = function(xhr){
		var err = checkResultForErr(xhr);
		if (err){
			THEME.loadPreview();
			return;
		}
		
		//return the xml to the theme class.
		THEME.loadPreview(xhr.responseXML);
	} //end cbGetPreviewInfo
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//download
	this.download = function(path){
		//check if we have permission to download
		for(var i=0;i<AFB.shares.length;i++){
			if(AFB.shares[i][0] == AFB.currentShare){
				var share = AFB.shares[i];
				break;
			}
		}
		if(share){
			if(typeof(share[5]) == 'string' && parseInt(share[5]) == 1){
				AFB.downloading = true;
				window.location='index.php?download='+path+'&share='+AFB.currentShare;
			}else{
				THEME.showError('<?php echo getLangTerm('no-dl-perms'); ?>');
			}
		}
	} //end download
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//saveDir
	this.saveDir = function(name){
		getUrl(AFB.xmlFile+'?createDir&share='+AFB.currentShare+'&path='+urlencode(AFB.currentPath)+'&dir='+urlencode(name),name,AFB.cbSaveDir,function(){
			//ajax call has failed or timed out.
			//display error.
			AFB.errMsg = '<?php echo getLangTerm('no-connect'); ?>';
			THEME.hideMLoad();
			THEME.showError(AFB.errMsg);
		});
	} // end saveDir
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//cbSaveDir
	this.cbSaveDir = function(xhr){
		var err = checkResultForErr(xhr);
		if (err){
			//display error.
			THEME.hideMLoad();
			THEME.showError(unescape(err));
			return;
		}
		THEME.insertDir(xhr.responseXML);
	} //end cbSaveDir
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//deleteitem
	this.deleteitem = function(type,path){
		getUrl(AFB.xmlFile+'?delete&t='+type+'&share='+AFB.currentShare+'&path='+urlencode(path),path,AFB.cbDeleteitem,function(){
			//ajax call has failed or timed out.
			//display error.
			AFB.errMsg = '<?php echo getLangTerm('no-connect'); ?>';
			THEME.hideMLoad();
			THEME.showError(AFB.errMsg);
		});
	} //end deleteitem
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//cbDeleteitem
	this.cbDeleteitem = function(xhr){
		var err = checkResultForErr(xhr);
		if (err){
			//display error.
			THEME.hideMLoad();
			THEME.showError(unescape(err));
			return;
		}
		THEME.returnDelete(xhr.responseXML);
	} //end cbDeleteitem
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//saveRename
	this.saveRename = function(type,path,text){
		getUrl(AFB.xmlFile+'?rename&t='+type+'&share='+AFB.currentShare+'&path='+urlencode(path)+'&to='+urlencode(text),text,AFB.cbSaveRename,function(){
			//ajax call has failed or timed out.
			//display error.
			AFB.errMsg = '<?php echo getLangTerm('no-connect'); ?>';
			THEME.hideMLoad();
			THEME.showError(AFB.errMsg);
		});
	} //end saveRename
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//cbSaveRename
	this.cbSaveRename = function(xhr){
		var err = checkResultForErr(xhr);
		if (err){
			//display error.
			THEME.hideMLoad();
			THEME.showError(unescape(err));
			return;
		}
		THEME.returnRename(xhr.responseXML);
	} //end cbSaveRename
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//uploadForm
	this.uploadForm = function(frm,num,file){
		if(typeof(frm)=='string'){
			var frm = xGetElementById(frm);
		}
		if (!num){
			return;
		}
		
		if (frm && frm.nodeName.toLowerCase() == 'form'){
			
			var callback = { 
				upload: AFB.cbUploadForm, 
				argument: [frm, num, file] 
			}
			
			YAHOO.util.Connect.setForm(frm, true);
			var r = YAHOO.util.Connect.asyncRequest('POST', AFB.xmlFile+'?upload=1&share='+AFB.currentShare+'&path='+urlencode(AFB.currentPath), callback);
		}
	} //end uploadForm
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//cbUploadForm
	this.cbUploadForm = function(xhr){
    	var res = true; //set true by default...
        if (xhr.responseXML && xhr.responseXML.firstChild && xhr.responseXML.firstChild.textContent) {
	        var resp = xhr.responseXML.firstChild.textContent.trim();
        	if(resp.search("failure") != -1) {
            	res = false;
            }
        }
		THEME.uploadReturn(xhr.argument[0],xhr.argument[1], xhr.argument[2], res);
	} //end cbUploadForm
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//tryLogin
	this.tryLogin = function(u,p){
		getUrl(AFB.xmlFile+'?login&u='+urlencode(u)+'&p='+urlencode(p),[u,p],AFB.cbTryLogin,function(){
			//ajax call has failed or timed out.
			//display error.
			AFB.errMsg = '<?php echo getLangTerm('no-connect'); ?>';
			THEME.hideMLoad();
			THEME.showError(AFB.errMsg);
		});
	} //end tryLogin
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//cbTryLogin
	this.cbTryLogin = function(xhr){
		var err = checkResultForErr(xhr);
		if (err){
			//display error.
			THEME.hideMLoad();
			THEME.showError(unescape(err));
			return;
		}
		window.location.href = unescape(window.location.pathname);
	}//end cbTryLogin
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	//tryLogout
	this.tryLogout = function(){
		getUrl(AFB.xmlFile+'?logout',null,AFB.cbTryLogin,function(){
			//ajax call has failed or timed out.
			//display error.
			AFB.errMsg = '<?php echo getLangTerm('no-connect'); ?>';
			THEME.hideMLoad();
			THEME.showError(AFB.errMsg);
		});
	} //end tryLogout
	
} //end AFB class

// -----------------------------------------------------------------------------------------------
// end AFB CLASS
// ***********************************************************************************************
YAHOO.util.Event.addListener(window, "load", AFB.winLoad);
YAHOO.util.Event.addListener(window, "unload", AFB.cleanup);