<?php
ini_set('display_errors','On');
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);

//determine ip of user
$ip = ( !empty($HTTP_SERVER_VARS['REMOTE_ADDR']) ) ? $HTTP_SERVER_VARS['REMOTE_ADDR'] : ( ( !empty($HTTP_ENV_VARS['REMOTE_ADDR']) ) ? $HTTP_ENV_VARS['REMOTE_ADDR'] : $REMOTE_ADDR );
if (strlen($ip) == 0) {
	$ip = $_SERVER['REMOTE_ADDR'];
}
define('IP',$ip);

require_once($approot.'_includes/functions_file.inc.php');
require_once($approot.'_includes/functions_date.inc.php');
require_once($approot.'_includes/functions_afb.inc.php');
require_once($approot.'_includes/function.dba.php');
require_once($approot.'_includes/magic_quotes.php');

//get afb settings from db
$sql = "SELECT * FROM `".TABLE_PREFIX."settings`";
$result = $db->Execute($sql);
$settings = array();
while (!$result->EOF){
  $settings[stripslashes($result->fields['setting_name'])] = stripslashes($result->fields['setting_value']);
  $result->MoveNext();
}


//---------------------------------------------------------------------------------------------
// TIME ZONES
//our offset is 36000 seconds from UTC.
//so the aim is to get the server offset, compare it with ours, and create the current time..
//this should work for QLD'ers even tho we don't have daylight savings
$thisoffset = date("Z");
if (!isset($settings['timezone'])) {
	$settings['timezone'] = $thisoffset;
}
$difference = $settings['timezone'] - $thisoffset;
define('OURTIME',time() + $difference);
define('TZ_OFFSET',$settings['timezone']);
//Get the BASE GMT 0 Timestamp
define('GMT_TIME',time() - $thisoffset);
//--------------------------------------------------------------------------------------------

require_once($approot.'_includes/class.afbaccount.php');

//require_once('includes/auth.inc.php');


//share perms
$share_perms = array();

//shares
$shares = afbGetShares();

//blackists dirs
$blacklist_dirs = array();
$sql = "SELECT DISTINCT `blacklist_dir` FROM `".TABLE_PREFIX."blacklist_dirs`";
$result = $db->Execute($sql);
while (!$result->EOF) {
	$blacklist_dirs[] = stripslashes($result->fields['blacklist_dir']);
	$result->MoveNext();
}

//blacklist files
$blacklist_files = array();
$sql = "SELECT DISTINCT `blacklist_file` FROM `".TABLE_PREFIX."blacklist_files`";
$result = $db->Execute($sql);
while (!$result->EOF) {
	$blacklist_files[] = stripslashes($result->fields['blacklist_file']);
	$result->MoveNext();
}

//blacklist types
$blacklist_types = array();
$sql = "SELECT DISTINCT `blacklist_extension` FROM `".TABLE_PREFIX."blacklist_ext`";
$result = $db->Execute($sql);
while (!$result->EOF) {
	$blacklist_types[] = stripslashes($result->fields['blacklist_extension']);
	$result->MoveNext();
}

//get language file:
if (file_exists($approot.'_includes/lang/lang.'.strtolower($settings['language']).'.php')){
	include($approot.'_includes/lang/lang.'.strtolower($settings['language']).'.php');
}

include($approot.'_includes/auth.inc.php');
?>