<?php
/* *************************************************************************************

  ENGLISH LANGUAGE FILE
	
	This is the default language. If a language file cannot be found, we'll use this one.
	
	Language files must be named using this convention:
	  lang.XX.php
	where XX is the 2 character abbreviation of the language. That abbreviation must
	be the same the the one used in the 'abbrev' xml tag just below.
	
	Usage:
		Key should be lowercase, and should not change from file to file.
		Value is the output text.

************************************************************************************** */

/*
These XML tags are used by the application to determine the name of the language.

<name>English</name>
<abbrev>en</abbrev>
*/

$LANGUAGE = array(

	//These definitionas are short and sweet word or sentence replacements.
	
	'ac-name-reqd'       =>  'Account Name is required',
	'ac-un-reqd'         =>  'Account Username is required',
	'ac-un-taken'        =>  'Account Username is already taken',
	'account'            =>  'Account',
	'accounts'           =>  'Accounts',
	'account-disabled'   =>  'Account is Disabled',
	'account-name'       =>  'Account Name',
	'add-dir'            =>  'Add Directory',
	'add-name'           =>  'Add Filename',
	'add-type'           =>  'Add Filetype',
	'administrator'      =>  'Administrator',
	'admin-account'      =>  'Administrator Account',
	'admin-home'         =>  'Admin Home',
  'administration'     =>  'Administration',
	'anon-users'         =>  'Anonymous Users',
	'app-installed'      =>  'The application has been installed!',
  'bad-ajax'           =>  'This file is only visible from an Ajax File Browser webpage. Sorry!',
	'bad-login'          =>  'Login details are incorrect',
	'begin-using'        =>  'Begin using Ajax File Browser',
	'bl-dir-name'        =>  'Blacklisted Directory Name',
	'bl-items'           =>  'Blacklisted Items',
	'bl-file-name'       =>  'Blacklisted Filename',
	'bl-type-name'       =>  'Blacklisted File Extension',
	'blacklists'         =>  'Blacklists',
	'cancel'             =>  'Cancel',
	'change-perms'       =>  'Change Permissions',
	'change-ac-perms-for'=>  'Change Account Permissions for Share:',
	'change-perms-desc'  =>  'Change Permissions for Accounts',
  'change-upload-size' =>  'Click Here to find out how you can change this',
  'click-continue'     =>  'Click anywhere to continue',
	'close'              =>  'Close',
	'confirm'            =>  'Confirm',
	'congratulations'    =>  'Congratulations',
	'continue'           =>  'Continue',
	'create-account'     =>  'Create Account',
	'create-dir'         =>  'Create Directory',
	'create-dir-fail'    =>  'Could not create directory: May already exist, or filesystem error.',
	'create-share'       =>  'Create a Share',
	'create-table-err'   =>  'Could not create table',
	'days-ago'           =>  'days ago',
	'db-host'            =>  'Database Hostname',
	'db-name'            =>  'Database Name',
	'db-pw'              =>  'Database Password',
	'db-un'              =>  'Database Username',
	'default'            =>  'Default',
	'default-theme'      =>  'Default Theme:',
	'delete'             =>  'Delete',
	'delete-dir'         =>  'Delete Directory',
	'delete-dir-fail'    =>  'Could not delete Directory',
	'delete-dir-ques'    =>  'Do you really want to delete this directory? All files and directories beneath will also be deleted!',
	'delete-file'        =>  'Delete File',
	'delete-file-fail'   =>  'Could not delete File',
	'delete-file-ques'   =>  'Do you really want to delete this file? It can not be recovered!',
  'details'            =>  'Details',
	'dir-name-reqd'      =>  'Directory Name is required',
	'dir-names'          =>  'Directory Names',
	'dir-no-exist'       =>  'Directory does not exist:',
	'dir-reqd'           =>  'Directory Location is required',
	'directory'          =>  'Directory:',
	'disabled'           =>  'Disabled',
  'download'           =>  'Download',
	'download-file'      =>  'Download File',
  'download-now'       =>  'Download Now',
	'download-perms'     =>  'Download Permissions',
	'download-perms-note'=>  'Allows downloading file from Share, must have List permissions to see the files though',
	'edit'               =>  'Edit',
	'edit-account'       =>  'Edit Account',
	'edit-share'         =>  'Edit Share',
	'empty-dir'          =>  'There are no files in this directory.',
	'end-html'           =>  'End Page HTML:',
	'end-html-note'      =>  'This code is placed just before the </BODY> tag, useful for Google Analytics Code',
  'error'              =>  'Error',
	'exists'             =>  'Exists',
  'file'               =>  'file',
	'file-operations'    =>  'File Operations',
	'filename-reqd'      =>  'Filename is required',
	'filenames'          =>  'Filenames',
  'files'              =>  'files',
	'filetypes'          =>  'Filetypes',
  'folders'            =>  'folders',
	'footer-link'        =>  'Footer Link:',
	'footer-text'        =>  'Footer Text:',
	'form-val-check'     =>  'Please check the fields and try again',
	'form-val-false'     =>  'Some required values are not correct. Please check the items before you continue.',
	'form-val-found'     =>  'We have found the following error(s):',
	'get-update'         =>  'Click here for changelog and download information.',
	'has-released'       =>  'has been released.',
  'home'               =>  'Home',
	'home-html'          =>  'Home Page HTML:',
  'home-html-note'     =>  'This code is placed on the home page, the first page people see when they go to this site',
  'home-html-tinymce'  =>  'Tip: Install TinyMCE to edit the WYSIWIG way.',
	'insert-data-err'    =>  "Could not add data to table",
	'install-err-1'      =>  "Could not connect to database! Please check details, and make sure database exists.",
	'install-err-2'      =>  "Could not find config.inc.php.tpl in _includes/install/",
	'install-err-3'      =>  "Could not find db.sql in _includes/install/",
	'installation'       =>  "Installation",
	'item-not-found'     =>  'Item could not be found',
  'large-icons'        =>  'Large Icons',
	'last-login'         =>  'Last Login',
	'list'               =>  'List',
	'list-perms'         =>  'List Permissions',
	'list-perms-note'    =>  'Can view and preview the files and directories in a Share, but doesn\'t allow Downloading files',
	'localisation'       =>  'Localisation',
	'location'           =>  'Location',
  'logged-in-as'       =>  'Logged in as',
  'login'              =>  'Login',
	'logout'             =>  'Logout',
  'max-upload-size'    =>  'Max Upload Filesize:',
	'modify'             =>  'Modify',
	'modify-perms'       =>  'Modify Permissions',
	'modify-perms-note'  =>  'Allows user to create, rename and delete Directories; rename and delete files',
	'mysql-details'      =>  'Mysql Database Details',
	'name'               =>  'Name',
	'new-version'        =>  'A new version is available!',
	'no'                 =>  'No',
	'no-connect'         =>  'Could not connect to server!',
	'no-dl-perms'        =>  'You do not have permissions to download files from this Share',
  'no-exist'           =>  'File or Directory does not exist',
  'no-preview'         =>  'No Preview Information Available',
  'no-shares'          =>  'no shares',
	'no-shares-defined'  =>  'There are no shares defined',
  'not-found'          =>  'Not Found',
  'not-installed'      =>  'Application has not been installed yet. Run install.php',
  'not-logged-in'      =>  'Not Logged In',
	'notes'              =>  'Notes',
	'notes-dir'          =>  'Notes about Directory',
	'notes-dir-1'        =>  'Make sure the webserver has permissions to access the directory',
	'notes-dir-linux-1'  =>  'Directories are case sensitive',
	'notes-dir-linux-2'  =>  'Directory can be Relative (to the site root, ie "images/" or "../images/") or Absolute (ie "/home/etc/")',
	'notes-dir-win'      =>  'Directory can be Relative (to the site root, ie "images\" or "..\images\") or Absolute (ie "c:\files\")',
	'notes-perm'         =>  'Permissions Explanation',
	'notes-perm-1'       =>  'Admin accounts automatically have all priveleges to all shares.',
	'notes-perm-2'       =>  'Users cannot Download or Modify if they do not have List permissions aswell.',
	'notes-perm-3'       =>  'You can create an "Upload Only" share without having List permissions. In this case, users will not be able to see the files others have also uploaded.',
  'pass-required'      =>  'Password is required',
	'password'           =>  'Password',
	'password-mismatch'  =>  'Passwords do not match',
	'password-reqd'      =>  'Password is required',
	'pref-theme'         =>  'Preffered Theme',
  'preview'            =>  'Preview',
  'preview-pane'       =>  'Preview Pane',
	'rem-ac-ques'        =>  'Do you really want to remove this account?',
	'rem-share-ques'     =>  'Do you really want to remove this share?',
	'remove'             =>  'Remove',
	'remove-account'     =>  'Remove Account',
	'remove-ques'        =>  'Do you really want to remove this item?',
	'remove-share'       =>  'Remove this Share',
	'rename'             =>  'Rename',
	'rename-dir'         =>  'Rename Directory',
	'rename-dir-exists'  =>  'A directory aready exists with that name!',
	'rename-dir-fail'    =>  'Could not rename directory!',
	'rename-file'        =>  'Rename File',
	'rename-file-exists' =>  'A file aready exists with that name!',
	'rename-file-fail'   =>  'Could not rename file!',
  'reports'            =>  'Reports',
	'save'               =>  'Save',
	'settings'           =>  'Settings',
	'settings-saved'     =>  'Settings have been saved.',
	'share-name'         =>  'Share Name:',
	'share-reqd'         =>  'Share Name is required',
  'shares'             =>  'Shares',
	'share-not-exist'    =>  'Share does not exist',
	'site-details'       =>  'Site Details',
  'site-name'          =>  'Site Name:',
  'small-icons'        =>  'Small Icons',
  'table-prefix'       =>  'Table Prefix',
  'thumbnails'         =>  'Thumbnails',
  'timezone'           =>  'Timezone:',
  'today'              =>  'Today',
  'type-reqd'          =>  'Extension is required',
  'upload'             =>  'Upload',
  'version'            =>  'Version',
  'view'               =>  'View',
  'upload-complete'    =>  'File has been uploaded',
  'upload-failed'      =>  'File has NOT been uploaded',
	'upload-here'        =>  'Upload Here',
  'upload-only'        =>  'You are only permitted to upload files to this share. You may not view the files you have uploaded, and you cannot overwrite files. Select \'Upload Here\' from the menu to get started.',
	'uploading'          =>  'Uploading... Feel free to select more files',
	'user-required'      =>  'Username is required',
  'username'           =>  'Username',
	'write'              =>  'Write',
	'write-perms'        =>  'Write Permissions',
	'write-perms-note'   =>  'Allows user to Upload files to the share, List permissions are not required to upload.',
	'yes'                =>  'Yes',
	'yesterday'          =>  'Yesterday',
	
  //Size Units
	'unit-gb'            =>  'gig',
  'unit-mb'            =>  'mb',
	'unit-kb'            =>  'kb',
	'unit-b'             =>  'b',
	
	
	//These definitionas are longer paragraphed replacements, mainly for Help throught the site
	
	'long-shares'        =>  'A Share is a reference to a directory that exists somewhere on this server. When you share a directory, all files and sub-directories beneath it are also shared. You can change the permissions for each Share, for each account.',
	'long-blacklists'    =>  'Blacklists are list of banned Directory names, File names and File extensions. Any blacklisted items are not displayed, even to Administrators.',
	'long-accounts'      =>  'User accounts allow multiple people to use different shares in different ways. Each account can have different permissions for shares, and even different Themes.',
  'long-reports'       =>  'View statistics on site usage',
  'long-settings'      =>  'You can change most other aspects of this site, including Site Name and Theme.',
	
);

//This definition must appear last as it refers to language definitions above.
$LANGUAGE['max-upload'] = 'Files cannot exceed '.getMaxUploadSize().' each';
?>
