<?php
/*
  stripslashesArray by Jamie Curnow
	strips slashes from all strings in an array of strings. array can be as multi dimensional.
*/
function stripslashesArray($arr) {
	if (is_array($arr)) {
		$keys = array_keys($arr);
		for ($x=0;$x<count($keys);$x++) {
			if (!is_object($arr[$keys[$x]])) {
				$arr[$keys[$x]] = stripslashesArray($arr[$keys[$x]]);
			}
		}
		return $arr;
	} else {
		return stripslashes($arr);
	}
}

/*
  addslashesArray by Jamie Curnow
	adds slashes on all strings in an array of strings. array can be as multi dimensional.
*/
function addslashesArray($arr) {
	if (is_array($arr)) {
		$keys = array_keys($arr);
		for ($x=0;$x<count($keys);$x++) {
			if (!is_object($arr[$keys[$x]])) {
				$arr[$keys[$x]] = addslashesArray($arr[$keys[$x]]);
			}
		}
		return $arr;
	} else {
		return addslashes($arr);
	}
}

/*
  TieString by Jamie Curnow

	This function ties the $pre to the start of $string, if $pre is not already there.
	also does the same to the end of the string with $post.
*/
function TieString($string,$pre='',$post='') {
	if (strlen($pre) > 0) {
		//tie the pre - check if not already tied.
		if (strpos($string,$pre) !== 0) {
			$string = $pre . $string;
		}
	}
	if (strlen($post) > 0) {
		//tie the post - check if not already tied
		//get sub
		$t = substr($string,(strlen($string) - strlen($post)),strlen($post));
		if ($t != $post) {
			$string .= $post;
		}
	}
	return $string;
}

/*
  GetSID by Jamie Curnow

	This function returns a string of $nSize, of completely random characters and/or numbers.
*/
function GetSID ($nSize=24) {
  // Randomize
    mt_srand ((double) microtime() * 1000000);
    for ($i=1; $i<=$nSize; $i++) {
    			
    	// if you wish to add numbers in your string, 
    	// uncomment the two lines that are commented
    	// in the if statement
    	$nRandom = mt_rand(1,30);
    	if ($nRandom <= 10) {
    		// Uppercase letters
    		$sid .= chr(mt_rand(65,90));
    	} elseif ($nRandom <= 20) {						//previously commented
    		$sid .= mt_rand(0,9);					//previously commented
    	} else {
    		// Lowercase letters
    		$sid .= chr(mt_rand(97,122));
    	}
 	}		
  return $sid;
}

/*
  GetSize by Jamie Curnow

	returns a formatted string like 2.5kb from an integer of bytes.
	also returns mb
*/
function GetSize($bytes) {
	if ($bytes >= 1024) {
		$size_kb = round(($bytes / 1024),0);
		if ($size_kb >= 1024) {
			$size_mb = round(($bytes / 1024 / 1024),2);
			if ($size_mb >= 1024) {
				$size_gb = round(($bytes / 1024 / 1024 / 1024),2);
				$sizer = number_format($size_gb,2,".",",") . " ".getLangTerm('unit-gb',false);
			} else {
				$sizer = number_format($size_mb,2,".",",") . " ".getLangTerm('unit-mb',false);
			}
		} else {
			$sizer = number_format($size_kb,0,".",",") . " ".getLangTerm('unit-kb',false);
		}
	} else {
		$sizer = $bytes . " ".getLangTerm('unit-b',false);
	}
	return $sizer;					
} // end GetSize

/*
  GetExt by Jamie Curnow

	gets the right part of a string before the '.' in lowercase
*/
function GetExt($file) {
	$tempext = strtolower(substr($file, strrpos($file,'.')+1,strlen($file)-strrpos($file,'.')));
	return trim($tempext,'/');
}

/*
  GetFilename by Jamie Curnow

	Gets a filename from a full path with it's parent directory,
	The right part of string before the '/'
*/
function GetFilename($file) {
	$file = str_replace('\\','/',$file);
	$file = trim($file,'/');
	if (strpos($file,'/') !== false) {
		$file = substr($file, strrpos($file,'/')+1,strlen($file)-strrpos($file,'/'));
	}
	return $file;
}

/*
  RemoveExtension by Jamie Curnow

	Removes the extension (and dot) of a filename
*/
function RemoveExtension($filename) {
	$file = substr($filename, 0,strrpos($filename,'.'));	
	if (strlen(trim($file)) == 0) {
		$file = $filename;
	}
	return $file;
}

/*
  readfile_chunked by Jamie Curnow

	Reads the content of a file, either local or remote (http://blah)
	in chunks that are protocol safe and avoid network disruption.
*/
function readfile_chunked ($filename) {
  $chunksize = 1*(1024*1024); // how many bytes per chunk
  $buffer = '';
  $contents = '';
  $handle = fopen($filename, 'rb');
  if ($handle === false) {
   return false;
  }
  while (!feof($handle)) {
   $buffer = fread($handle, $chunksize);
   $contents .= $buffer;
   //print $buffer;
  }
  fclose($handle);
  return $contents;
}


/*
  GetXML by Jamie Curnow
	
	For simple use.
	Gets the contents of an XML file into an array - does not work with branch arrays
	Does not get self terminated values, as the xml parser in php is terrible.
	
	dependancies:
	  readfile_chunked
*/
function GetXML($xmlfile) {
	$data = readfile_chunked($xmlfile);
	if ($data) {
		//interprate result
		$xml_parser = xml_parser_create();
		xml_parse_into_struct($xml_parser, $data, $vals, $index);
		xml_parser_free($xml_parser);
		
		$params = array();
		$level = array();
		foreach ($vals as $xml_elem) {
			if ($xml_elem['type'] == 'open') {
			 if (array_key_exists('attributes',$xml_elem)) {
			 		list($level[$xml_elem['level']],$extra) = array_values($xml_elem['attributes']);
			 } else {
			 		$level[$xml_elem['level']] = $xml_elem['tag'];
			 }
			}
			if ($xml_elem['type'] == 'complete') {
			 $start_level = 1;
			 $php_stmt = '$params';
			 while($start_level < $xml_elem['level']) {
			 		$php_stmt .= '[$level['.$start_level.']]';
			 		$start_level++;
			 }
			 $php_stmt .= '[$xml_elem[\'tag\']] = $xml_elem[\'value\'];';
			 eval($php_stmt);
			}
		}
		return $params;
	}
	return false;
}

//Truncate
function Truncate($string,$length) {
	//truncates a string to a certain char length, stopping on a word.
	if (strlen($string) > $length) {
		//limit! but also stop on a complete word..
		$string = substr($string,0,($length -3));
		$string = substr($string,0,strrpos($string,' ')).'...';
	}
	return $string;
}

/**
 * Removes the directory and all its contents.
 *
 * @param string the directory name to remove
 * @return boolean True/False whether the directory was deleted.
 */
function deleteDirectory($dirname) {
	if (!is_dir($dirname)) {
		return false;
	}
	
	$dscan = array(realpath($dirname));
	$darr = array();
	while (!empty($dscan)) {
		$dcur = array_pop($dscan);
		$darr[] = $dcur;
		if ($d=opendir($dcur)) {
			while ($f=readdir($d)) {
				if ($f=='.' || $f=='..') {
					continue;
				}
				$f=$dcur.'/'.$f;
				if (is_dir($f)) {
					$dscan[] = $f;
				} else {
					unlink($f);
				}
			}
			closedir($d);
		}
	}
	
	$i_until = ($only_empty)? 1 : 0;
	for ($i=count($darr)-1; $i>=0; $i--) {
		rmdir($darr[$i]);
	}
	if(is_dir($firname)){
		return false;
	} else {
		return true;
	}
//	return (($only_empty)? (count(scandir)<=2) : (!is_dir($dirname)));
} //end deleteDirectory

//getMaxUploadSize
function getMaxUploadSize(){
	if (ini_get('post_max_size') < ini_get('upload_max_filesize')) {
		//set post size as max..
		return  str_replace('m',getLangTerm('unit-mb',false),strtolower(ini_get('post_max_size')));
	} else {
		// set upload size as max..
		return str_replace('m',getLangTerm('unit-mb',false),strtolower(ini_get('upload_max_filesize')));
	}
} //end getMaxUploadSize

//GetIntelligentName
function GetIntelligentName($name) {
	//this function strips the extension, and aims to produce a friendly filename
	if (strpos($name,'.') !== false) {
		return ucwords(trim(str_replace("_"," ",substr($name, 0, strrpos($name,'.')))));
	} else {
		return ucwords(trim(str_replace("_"," ",$name)));
	}
}

//ApplyWildcards
function ApplyWildcards($contents, $TemplateKeys) {	
	foreach ($TemplateKeys as $cont=>$val ) {
	  $contents = str_replace ( $cont, $val, $contents );
	}
	return $contents;
}
?>