<?php
/*
* Function  string  dba(arg1,arg2...)                             www.jc21.com
* ----------------------------------------------------------------------------
* This function is a debugging tool to help you with your complex scripts.
* It will tell you what the contents of your variable(s) are.
* Use:
*   echo dba($arg1,$arg2,$arg3...);
* Can have as many arguments as you like. Arguments can be anything.
* Example:
*   echo dba('Hello World!',9316729,4582.55,array('foo','bar'),$db);
* ----------------------------------------------------------------------------
* August 2006 - Jamie Curnow
*/

function dba() {
	//init string
	$returns = '';
	//get stats
	$stats = debug_backtrace();

	$returns .= '<pre><span style="color:#23A5BF;">================================================================================</span>'."\n";	
	$returns .= '<span style="font-weight:bold;color:#237D8F;">Debug Called:</span><span style="font-weight:bold;color:#999;">'."\n";
	for ($z=0;$z<count($stats);$z++) {
		$returns .= ' ' . $stats[$z]['file'].' <span style="font-weight:normal;color:#000;">on</span> <span style="color:#000;">Line ' . $stats[$z]['line']."</span>\n";
	}
	$returns .= '</span>';	
	
	
	if (func_num_args() > 0) {
		$args = func_get_args();
		for ($x=0;$x<count($args);$x++) {
			
			$returns .= '<span style="color:#23A5BF;">================================================================================</span>'."\n";
			$returns .= '<span style="font-weight:bold;color:#237D8F;">Argument #'.($x+1).':</span> ';
				
			//check type
			if (is_string($args[$x])) {
				//String
				$returns .= '<span style="font-weight:bold;">String</span>'."\n".'<span style="color:#DF1B1B;">'.htmlspecialchars(str_replace("\t","    ",$args[$x])).'</span>'."\n";
			} elseif (is_int($args[$x])) {
				//Integer
				$returns .= '<span style="font-weight:bold;">Integer</span>'."\n".'<span style="color:#f00;">'.htmlspecialchars($args[$x]).'</span>'."\n";
			} elseif (is_float($args[$x])) {
				//Float
				$returns .= '<span style="font-weight:bold;">Float</span>'."\n".'<span style="color:#f00;">'.htmlspecialchars($args[$x]).'</span>'."\n";
			} elseif (is_null($args[$x])) {
				//Null
				$returns .= '<span style="font-weight:bold;">Null</span>'."\n";
			} elseif (is_bool($args[$x])) {
				//Boolean
				$returns .= '<span style="font-weight:bold;">Boolean</span>'."\n".'<span style="color:#f00;font-weight:bold;">';
				if ($args[$x]) {
					$returns .= 'True';
				} else {
					$returns .= 'False';
				}
				$returns .= '</span>'."\n";
				
			} elseif (is_array($args[$x]) || is_object($args[$x]) || is_resource($args[$x])) {
				//Array or Object
				
				//capture output
				ob_start();
					print_r($args[$x]);
					$text = ob_get_contents();
				ob_end_clean();
				
				//attempt to format text
				preg_match_all ("'\[(.*?)\]'si", $text, $brackets);
				$brackets = $brackets[0];
				$sofar = array();
				for ($y=0;$y<count($brackets);$y++) {
					if (!$sofar[$brackets[$y]]) {
						$text = str_replace($brackets[$y],'<span style="color:#00f;">'.$brackets[$y].'</span>',$text);
						$sofar[$brackets[$y]] = true;
					}
				} //y for
				
				$text = str_replace(' => ','<span style="color:#DF1B1B;"> =&gt; </span>',$text);
				$text = str_replace("Array\n",'<span style="font-weight:bold;">Array</span>'."\n",$text);
				$text = str_replace("Object\n",'<span style="font-weight:bold;">Object</span>'."\n",$text);
				$text = str_replace("\n)\n","\n".'<span style="font-weight:bold;">)</span>'."\n",$text);
				$text = str_replace("\n(\n","\n".'<span style="font-weight:bold;">(</span>'."\n",$text);
				$returns .= $text;
				
			}

			$returns .= '<span style="font-weight:bold;color:#237D8F;">End Argument #'.($x+1)."</span>\n";
			
		} //x for
	} //num args check
	$returns .= '<span style="color:#23A5BF;">================================================================================</span></pre>';
	/*
	echo "\nHi: $str";
  echo '<pre>';
	var_dump();
	echo '</pre>';
	*/
	return $returns;
} // END Function
?>