<?php
/*
  Authentication for Accounts.
	
	Checks their session details against the database.
	If not authenticated, returns them to /index.php
	with an error.
		
	@author Jamie Curnow

*/

//clear the $afbAccount class, if it's already set for any reason
if (isset($afbAccount)) {
	unset($afbAccount);
}
//default theme dir
$theme_dir = $settings['default_theme_dir'];

//check if login form was posted, and assign those vars to the session
if (isset($_POST['afb_username']) && isset($_POST['afb_password'])) {
	$_SESSION['afb_username'] = trim(strtolower(stripslashes($_POST['afb_username'])));
	$_SESSION['afb_password'] = stripslashes($_POST['afb_password']);
}

//check for the session vars
if (isset($_SESSION['afb_username']) && isset($_SESSION['afb_password'])) {

	//create class and validate
	$afbAccount = new afbAccount($_SESSION['afb_username'],$_SESSION['afb_password']);
	
	if ($afbAccount->validate()) {
		//user is validated!
		//check if user wants to logout
		if (isset($_GET['logout'])) {
			//get the sc_id of the user, if the credentials are even ok. Don't do this, if we logged in via admin.
			afbLogit('logout');
			//unset their session details
			unset($_SESSION['afb_username'],$_SESSION['afb_password']);
			unset($afbAccount);
			//delete cookies
			// set the expiration date to one day ago
			setcookie("afb_un", "", time() - (60*60*24));
			setcookie("afb_pw", "", time() - (60*60*24), "/");
			
		} else {
			//user doesn't want to logout
			//check their theme_dir
			$theme_dir = $afbAccount->account['theme'];
			//check if user just logged in		
			if (isset($_GET['u']) && isset($_GET['p'])) {
				//log their action
				afbLogit('login');
			} //end form post check

		} //end logout check
		
		
	} else {
		//user is not validated.
		//check if they just logged in, and set an error if they did.
		if (isset($_GET['u']) && isset($_GET['p'])) {
			$login_error = $afbAccount->error;
		}
		unset($afbAccount);
	} //end validated check
	
} //end session vars check

//double check theme_dir
if (!is_dir($approot.'_themes'.TieString($theme_dir,'/','/')) || strlen($theme_dir) == 0) {

	$theme_dir = $settings['default_theme_dir'];
	if (!is_dir($approot.'_themes'.TieString($theme_dir,'/','/')) || strlen($theme_dir) == 0) {
		$theme_dir = 'Office 2007 Blue';
	}
}

define('THEMEDIR',TieString(BASEURL,'','/').'_themes'.TieString($theme_dir,'/','/'));
?>