<?php
// ***********************************************************************************************
// THEME CLASS
// -----------------------------------------------------------------------------------------------
//ini_set('zlib.output_compression', 'On');
session_start();

$approot = '../../../';

//check for config file.
if (file_exists($approot.'_includes/config.inc.php')) {
	// now that all is well, include config files.
	require_once($approot.'_includes/config.inc.php');
	require_once($approot.'_includes/settings.inc.php');
}

header("Content-type: text/js");
?>
var THEME = new function() {
		
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// winLoad - fix heights on page load.
	this.winLoad = function(e){
		//fix heights.
		THEME.fixHeights();
	} //end winLoad
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// fixHeights - fix heights on page load.
	this.fixHeights = function(e){
		
		//get height of viewport, and make main adjust to that height.
		var h=YAHOO.util.Dom.getViewportHeight();
		if(xGetElementById('main')){
			//adjust height of Main
			xHeight('main',(h-93));

			//adjust height of main_content
			xHeight('main_content',(xHeight('main')-21));
			
			//last step, get height of main_content, and match main_left and main_right.
			if(xGetElementById('main_left')){
				xHeight('main_left',xHeight('main'));
			}
			if(xGetElementById('main_right')){
				xHeight('main_right',xHeight('main'));
			}	
		}
	} //end fixHeights
	
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	// cleanup - fixes memory leaks
	this.cleanup = function(e){
		
	}

} // END THEME CLASS
// -----------------------------------------------------------------------------------------------
// end THEME CLASS
// ***********************************************************************************************

// ********************************************************************************************
// INPUTS and FORM CLASS
// ********************************************************************************************
var INPUTS = new function(){
	
	//setup
	this.setup = function(){
		//check if compatible
		if (document.getElementsByTagName) {
			var inp = xmlTags('input',document);
			for(i=0; i < inp.length; i++) {
				if (inp[i].type != 'hidden') {
					YAHOO.util.Event.addListener(inp[i],'mouseover',INPUTS.on);
					YAHOO.util.Event.addListener(inp[i],'mouseout',INPUTS.off);					
					addClassName(inp[i],inp[i].type + '_hover_off');
				}
			}
			var ta = xmlTags('textarea',document);
			for(i=0; i < ta.length; i++) {
				YAHOO.util.Event.addListener(ta[i],'mouseover',INPUTS.on);
				YAHOO.util.Event.addListener(ta[i],'mouseout',INPUTS.off);					
				addClassName(ta[i],ta[i].type + '_hover_off');				
			}
		}	
		
		//search dom for all forms
		var frms = document.getElementsByTagName('form'); 
		for(var i=0;i<frms.length;i++) {
			YAHOO.util.Event.addListener(frms[i], "submit", INPUTS.validate);
		}
		
		return;
	}
	
	//on
	this.on = function(e){
		var elm=e;
		if (!e.nodeName) {			
			//was fired by yahoo
			elm = (e.srcElement) ? e.srcElement : e.target;
		}
		if (!elm){
			return false;
		}
		addClassName(elm,elm.type+'_hover_on');
		removeClassName(elm,elm.type+'_hover_off');
		return true;
	}
	
	//off
	this.off = function(e){
		var elm=e;
		if (!e.nodeName) {			
			//was fired by yahoo
			elm = (e.srcElement) ? e.srcElement : e.target;
		}
		if (!elm){
			return false;
		}
		addClassName(elm,elm.type+'_hover_off');
		removeClassName(elm,elm.type+'_hover_on');
		return true;
	}
	
	//  Form Input Checking by JC
	/*
			Apply these class names to form elements:
			
			* required (not blank)
			* validate-number (a valid number)
			* validate-digits (digits only, spaces allowed.)
			* validate-alpha (letters only)
			* validate-alphanum (only letters and numbers)
			* validate-date (a valid date value)
			* validate-email (a valid email address)
			* validate-url (a valid URL)
			* validate-date-au (a date formatted as; dd/mm/yyyy)
			* validate-currency-dollar (a valid dollar value)
			* validate-one-required (At least one checkbox/radio element must be selected in a group)
			* validate-not-first (Selects only, must choose an option other than the first)
			* validate-not-empty (Selects only, must choose an option with a value that is not empty)
			
			Also, you can specify this attribute for text, passwird and textarea elements:
			* minlength="x" (where x is the minimum number of characters)
	*/
	//validate - this function is called when a form is submitted.
	this.validate = function(e) {
		var errs = new Array();
		if (typeof(e) == "string") {
			//the id was supplied, get the object reference
			e = xGetElementById(e);
			if (!e) {
				return true;
			}
		}
		
		var elm=e;
		if (!e.nodeName) {			
			//was fired by yahoo
			elm = (e.srcElement) ? e.srcElement : e.target;
		}
		if (elm.nodeName.toLowerCase() != 'form') {
			elm = searchUp(elm,'form');
		}
		
		var all_valid = true;
		//access form elements
		//inputs
		var f_in = elm.getElementsByTagName('input');
		//selects
		var f_sl = elm.getElementsByTagName('select');
		//textareas
		var f_ta = elm.getElementsByTagName('textarea');
		
		//check inputs
		for (i=0;i<f_in.length;i++) {
			if (f_in[i].type.toLowerCase() != 'submit' && f_in[i].type.toLowerCase() != 'button' && f_in[i].type.toLowerCase() != 'hidden' && f_in[i].disabled !== true) {
				if (isVisible(f_in[i])) {
					
					var cname = ' '+f_in[i].className.replace(/^\s*|\s*$/g,'')+' ';
					cname = cname.toLowerCase();
					var inv = f_in[i].value.trim();
					var t = f_in[i].type.toLowerCase();
					var cext = '';
					if (t == 'text' || t == 'password') {
						//text box
						var valid = INPUTS.chkField(cname,f_in[i]);
					} else if(t == 'radio' || t == 'checkbox'){
						// radio or checkbox
						var valid = INPUTS.chkRadCbx(cname,f_in[i],f_in);
						cext = '-cr';
					} else {
						var valid = true;
					}
					
					if (valid) {
						removeClassName(f_in[i],'validation-failed'+cext);
						addClassName(f_in[i],'validation-passed'+cext);
					} else {
						removeClassName(f_in[i],'validation-passed'+cext);
						addClassName(f_in[i],'validation-failed'+cext);
						//try to get title
						if (f_in[i].getAttribute('title')){
							errs[errs.length] = f_in[i].getAttribute('title');
						}
						all_valid = false;
					}
				}
			}
		} //end for i
		
		//check textareas
		for (i=0;i<f_ta.length;i++) {
			if (isVisible(f_ta[i])) {
				var cname = ' '+f_ta[i].className.replace(/^\s*|\s*$/g,'')+' ';
				cname = cname.toLowerCase();
				var valid = INPUTS.chkField(cname,f_ta[i]);
				
				if (valid) {
					removeClassName(f_ta[i],'validation-failed');
					addClassName(f_ta[i],'validation-passed');
				} else {
					removeClassName(f_ta[i],'validation-passed');
					addClassName(f_ta[i],'validation-failed');
					//try to get title
					if (f_ta[i].getAttribute('title')){
						errs[errs.length] = f_ta[i].getAttribute('title');
					}
					all_valid = false;
				}
			}
		} //end for i
		
		//check selects
		for (i=0;i<f_sl.length;i++) {
			if (isVisible(f_sl[i])) {
				var cname = ' '+f_sl[i].className.replace(/^\s*|\s*$/g,'')+' ';
				cname = cname.toLowerCase();
				var valid = INPUTS.chkSel(cname,f_sl[i]);
				if (valid) {
					removeClassName(f_sl[i],'validation-failed-sel');
					addClassName(f_sl[i],'validation-passed-sel');
				} else {
					removeClassName(f_sl[i],'validation-passed-sel');
					addClassName(f_sl[i],'validation-failed-sel');
					//try to get title
					if (f_sl[i].getAttribute('title')){
						errs[errs.length] = f_sl[i].getAttribute('title');
					}
					all_valid = false;
				}
			}
		} //end for i
		
		if (!all_valid) {
			if (errs.length > 0){
				alert("<?php echo getLangTerm('form-val-found'); ?>\n\n  * "+errs.join("\n  * ")+"\n\n<?php echo getLangTerm('form-val-check'); ?>");
			} else {
				alert('<?php echo getLangTerm('form-val-false'); ?>');
			}
			YAHOO.util.Event.stopEvent(e);
		} else {
			//valid, disForm it.
			
			
			
		}
		return all_valid;
		
	}
	
	//chkField
	this.chkField = function(c,e){
		var valid = true;
		var t = e.value.trim();
		
		//search for required
		if (c.indexOf(' required ') != -1 && t.length == 0) {
			//required found, and not filled in
			valid = false;
		}
		
		//check length
		if (c.indexOf(' required ') != -1){
			//check for minlength.
			var m = e.getAttribute('minlength');
			if (m && Math.abs(m) > 0){
				if (e.value.length < Math.abs(m)){
					valid = false;
				}
			}
		}
	
		//search for validate-  
		if (c.indexOf(' validate-number ') != -1 && isNaN(t) && t.match(/[^\d]/)) {
			//number bad
			valid = false;
		} else if (c.indexOf(' validate-digits ') != -1 && t.replace(/ /,'').match(/[^\d]/)) {
			//digit bad
			valid = false;
		} else if (c.indexOf(' validate-alpha ') != -1 && !t.match(/^[a-zA-Z]+$/)) {
			//alpha bad
			valid = false;
		} else if (c.indexOf(' validate-alphanum ') != -1 && t.match(/\W/)) {
			//alpha bad
			valid = false;
		} else if (c.indexOf(' validate-date ') != -1) {
			var d = new date(t);
			if (isNaN(d)) {
				//date bad
				valid = false;
			}
		} else if (c.indexOf(' validate-email ') != -1 && !t.match(/\w{1,}[@][\w\-]{1,}([.]([\w\-]{1,})){1,3}$/)) {
			//email bad
			valid = false;
			if (c.indexOf(' required ') == -1 && t.length == 0) {
				valid = true;
			}
		} else if (c.indexOf(' validate-url ') != -1 && !t.match(/^(http|https|ftp):\/\/(([A-Z0-9][A-Z0-9_-]*)(\.[A-Z0-9][A-Z0-9_-]*)+)(:(\d+))?\/?/i)) {
			//url bad
			valid = false;
		} else if (c.indexOf(' validate-date-au ') != -1 && !t.match(/^(\d{2})\/(\d{2})\/(\d{4})$/)) {
			valid = false;
		} else if (c.indexOf(' validate-currency-dollar ') != -1 && !t.match(/^\$?\-?([1-9]{1}[0-9]{0,2}(\,[0-9]{3})*(\.[0-9]{0,2})?|[1-9]{1}\d*(\.[0-9]{0,2})?|0(\.[0-9]{0,2})?|(\.[0-9]{1,2})?)$/)) {
			valid = false;
		}
		
		return valid;
	}
	
	//chkRadCbx
	this.chkRadCbx = function(c,e,f){
		var valid = true;
		
		//search for required
		if (c.indexOf(' validate-one-required ') != -1) {
			//required found
			//check if other checkboxes or radios have been selected.
			valid = false;
			for (var i=0;i<f.length;i++){
				if(f[i].name.toLowerCase() == e.name.toLowerCase() && f[i].checked){
					valid = true;
					break;
				}
			}
		}
		
		return valid;
	}
	
	//chkSel
	this.chkSel = function(c,e){
		var valid = true;
		//search for validate-  
		if (c.indexOf(' validate-not-first ') != -1 && e.selectedIndex == 0) {
			//bad
			valid = false;
		} else if (c.indexOf(' validate-not-empty ') != -1 && e.options[e.selectedIndex].value.length == 0) {
			//bad
			valid = false;
		}
		return valid;
	}


} //end inputs class

//==================================================================================================================
//  Window Load Listeners
//------------------------------------------------------------------------------------------------------------------
YAHOO.util.Event.addListener(window, "load", THEME.winLoad);
YAHOO.util.Event.addListener(window, "load", INPUTS.setup);
YAHOO.util.Event.addListener(window, "unload", THEME.cleanup);