<?php
// ***********************************************************************************************
// Office 2007 Blue Stylesheet
// -----------------------------------------------------------------------------------------------
//ini_set('zlib.output_compression', 'On');
session_start();

$approot = '../../../';

//check for config file.
if (file_exists($approot.'_includes/config.inc.php')) {
	// now that all is well, include config files.
	require_once($approot.'_includes/config.inc.php');
}

header("Content-type: text/css");
?>
body {
	font-size:100%;
	margin:0;
	padding:0;
	font-family:Arial, Helvetica, sans-serif;
	background:#86939A url(<?php echo BASEURL; ?>_includes/admin/theme/images/bg.jpg) left top repeat-x;
	color:#627077;
}

#wrapper {
	position:relative;
	font-size:12px;
	margin:5px;
	padding:0;
}

/* --------------- HEAD ----------------- */
#head {
	position:relative;
	margin:0;
	padding:0;
	height:58px;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/head_bg.gif) left top repeat-x;
}

#head h2 {
	font-size:12px;
	font-weight:normal;
	text-align:center;
	margin:0;
	padding:7px 0 0 0;
}

#head_left, #head_right {
	position:absolute;
	height:58px;
	top:0;
}

#head_left {
	left:0;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/head_left.gif) left top no-repeat;
	width:151px;
}

#head_right {
	right:0;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/head_right.gif) left top no-repeat;
	width:5px;
}


#menu {
	position:absolute;
	top:21px;
	left:30px;
	font-size:93%;
	line-height:normal;
}
#menu ul {
	margin:0;
	padding:10px 10px 0 50px;
	list-style:none;
}
#menu li {
	display:inline;
	margin:0;
	padding:0;
}
#menu a {
	float:left;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/menu_tab_left.gif) no-repeat left top;
	margin:0;
	padding:0 0 0 4px;
	text-decoration:none;
}
#menu a span {
	float:left;
	display:block;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/menu_tab_right.gif) no-repeat right top;
	padding:5px 15px 4px 6px;
	color:#627077;
}
/* Commented Backslash Hack hides rule from IE5-Mac \*/
#menu a span {float:none;}
/* End IE5-Mac hack */
#menu a:hover span, #menu a.selected {
	color:#879297;
}
#menu a:hover, #menu a.selected {
	background-position:0% -25px;
}
#menu a:hover span, #menu a.selected span {
	background-position:100% -25px;
}

/* --------------- END HEAD ----------------- */


/* --------------- MAIN ----------------- */

#main {
	position:relative;
	margin:0;
	padding:0 0 5px 0;
	background:#C2D9F7 url(<?php echo BASEURL; ?>_includes/admin/theme/images/main_bg.gif) left top repeat-x;
}

#main_left, #main_right {
	position:absolute;
	width:6px;
	top:0;
}

#main_left {
	left:0;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/main_left.gif) left top repeat-y;
}

#main_right {
	right:0;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/main_right.gif) left top repeat-y;
}

#main_head { /* space for the P */
	position:relative;
	height:20px;
	font-size:14px;
}

#main_head p { /* ie: Files > Applications > 3dsmax */
	margin:0;
	padding:2px 5px 0 10px;
}

#main_container { /* white content box */
	background-color:#fff;
	border:1px solid #6593CF;
	margin:0;
	padding:0 5px 0 5px;
}

#main_content { /* folder contents */ 
	background-color:#fff;
	overflow:auto;
	margin:0 5px 0 5px;
	padding:0;
}

#main_loading {
	position:absolute;
	top:0;
	left:0;
	width:56px;
	height:21px;
	z-index:100;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/loading.gif) left top no-repeat;
}



/* --------------- END MAIN ----------------- */

/* --------------- newver ----------------- */

#newver {
	border:1px solid #97DF8B;
	background-color:#C8FFBF;
	padding:5px;
	color:#222;
	width:300px;
	float:right;
	text-align:center;
}
#newver p.title {
	font-size:16px;
	font-weight:bold;
	margin:0;
	padding:0;
}

/* --------------- END newver ----------------- */


/* --------------- FOOT ----------------- */
#foot {
	position:relative;
	margin:0;
	padding:0;
	height:23px;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/foot_bg.gif) left top repeat-x;
}

#foot_left, #foot_right {
	position:absolute;
	height:23px;
	top:0;
}

#foot_left p, #foot_right p {
	margin:0;
	padding:4px 10px 0 10px;
}

#foot_left {
	left:0;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/foot_left.gif) left top no-repeat;
	width:45%;
}

#foot_right {
	right:0;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/foot_right.gif) right top no-repeat;
	width:45%;
	text-align:right;
}


/* --------------- END FOOT ----------------- */


/* --------------- LINKS ----------------- */
a {
	text-decoration:none;
	color:#627077;
}

a:hover {
	text-decoration:underline;
	color:#627077;
}
/* --------------- END LINKS ----------------- */


a.button {
	position:relative;
	display:block;
	margin:0 auto 0 auto;
	padding:3px 0 1px 0;
	color:#000;
	font-weight:bold;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/button.gif) left top no-repeat;
	height:18px;
	width:120px;
	cursor:pointer;
	_cursor:hand;
	text-decoration:none;
}

a.button:hover {
	text-decoration:none;
	background-position:left bottom;
}

dl dt {
	color:#637D9F;
	font-size:16px;
	font-weight:bold;
	border-bottom:1px solid #A7B7BF;
}

dl dd {
	margin:0 0 15px 10px;
}

/* --------- tables  ------------ */

table {
	width:90%;
	margin:10px auto 0 auto;
	
}

table thead, table tbody tr th {
	background-color:#A7B7BF;
	color:#fff;
	font-weight:bold;
}
table thead tr td, table tbody tr th {
	padding:6px 3px 7px 3px;
	text-align:left;
}

table caption {
	background-color:#99C8DF;
	text-align:left;
	width:90%;
	margin:10px auto 0 auto;
	padding:4px;
	font-weight:Bold;
	color:#fff;
}
table tbody tr td {
	border-bottom:1px solid #B5C7DF;
	padding:2px;
}

table tfoot {
	background-color:#A7B7BF;
	color:#fff;
	font-weight:bold;
}

table tfoot tr td {
	padding:3px;
}
table tfoot tr td a {
	color:#F4DE5C;
}


table tfoot tr td a.button {
	float:left;
}

a.button {
	position:relative;
	display:block;
	margin:0 5px 0 0;
	padding:3px 0 1px 0;
	color:#000;
	font-weight:bold;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/button.gif) left top no-repeat;
	height:18px;
	width:120px;
	cursor:pointer;
	_cursor:hand;
	text-decoration:none;
	text-align:center;
}

a.button:hover {
	text-decoration:none;
	background-position:left bottom;
}

input.button {
	position:relative;
	margin:0 4px 0 4px;
	padding:0 0 1px 0;
	color:#000;
	font-weight:bold;
	background:url(<?php echo BASEURL; ?>_includes/admin/theme/images/button.gif) left top no-repeat;
	height:22px;
	width:120px;
	cursor:pointer;
	_cursor:hand;
	border:0;
	text-decoration:none;
}

.errors {
	color:#f00;
}

.affirmative{
	color:#4DCF6B;
	background-color:#CFFFDA;
	padding:5px;
	font-weight:bold;
	margin:3px auto 4px auto;
	width:90%;
	border:1px solid #41AF50;
}

#stats_bar {
	height:150px;
	border-bottom:1px solid #f00;
	margin:0;
	padding:0;
}

#cal1Container1, #cal1Container2 {
	width:180px;
	position:absolute;
	display:none;
	z-index:100;
}

table#cal1 th, table#cal2 th {
	color:#000;
}

div.report_box {
	width:200px;
	border:1px solid #7A7E80;
	background-color:#EFEFEF;
	float:left;
	margin:5px;
	height:60px;
}

div.report_box h4, div.report_box p {
	margin:2px 4px 3px 2px;
	padding:0;
}