<?php
//admin section redirections
if (!isset($afbAccount) || $afbAccount->account['account_admin'] !== 'yes'){
	//jump to home
	header("Location: http://".trim($_SERVER['HTTP_HOST'],'/').BASEURL);
	exit();
}




if (isset($_POST['submit'])) {
	foreach ($_POST as $key => $value) {
		if (strtolower($key) != 'submit') {
			$sql = "DELETE FROM `".TABLE_PREFIX."settings` WHERE `setting_name`='".addslashes(strtolower($key))."' LIMIT 1";
			if ($db->Execute($sql) === false) { 
				$errors[] = 'Error: '.$db->ErrorMsg();
			} else {
				$sql = "INSERT INTO `".TABLE_PREFIX."settings` (`setting_name`,`setting_value`) VALUES ('".addslashes(strtolower($key))."','".addslashes(stripslashes($value))."')";
				if ($db->Execute($sql) === false) { 
					$errors[] = 'Error: '.$db->ErrorMsg();
				} else {
					$affirmative = getLangTerm('settings-saved',false);
					$settings[$key] = stripslashes($value);
				}
			}
		}
	}
}






//get list of themes from dir
$dh = @opendir('_themes/');
$dirs = array();
while (false !== ($file=@readdir($dh))) {
	if (substr($file,0,1)!=".") {  #skip anything that starts with a '.' i.e.:('.', '..', or any hidden file)
		if (is_dir('_themes/'.$file)) {
			$dirs[]=$file;   #put directories into dirs[] and append a '/' to differentiate
		}
	}
}
@closedir($dh);


//------------------------------
$thispage['title'] = getLangTerm('settings',false);
//------------------------------

//Check if TinyMce is installed, then use it
if (file_exists('tinymce/jscripts/tiny_mce/tiny_mce.js')){
	$thispage['editor'] = true;
	$thispage['editor_elements'] = array('home_html');
//	$thispage['editor_simple'] = true;
}





//-----------------------------
include(ADMINROOT.'_head.php');
//-----------------------------
	
	
	
	
	if (count($errors) > 0) {
		?>
		<p class="errors"><strong><?php echo getLangTerm('form-val-found',false); ?></strong></p>
		<ul class="errors">
			<?php
				for ($x=0;$x<count($errors);$x++) {
					?><li><?php echo $errors[$x]; ?></li><?php
				}
			?>
		</ul>
		<?php
	} elseif ($affirmative){
		?>
		<p class="affirmative"><?php echo $affirmative; ?></p>
		<?php
	}	
	
	?>

	<form method="post" action="index.php?admin&section=settings" name="settings">
		<table border="0" cellspacing="0">
			<thead>
				<tr>
					<td colspan="2">
						<?php echo getLangTerm('site-details',false); ?>
					</td>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="200">
						<?php echo getLangTerm('site-name',false); ?>
					</td>
					<td>
						<input type="text" name="site_name" value="<?php echo $settings['site_name']; ?>" style="width:250px;" class="required" title="Site Name is required" />
					</td>
				</tr>
				
				<tr>
					<td width="200">
						<?php echo getLangTerm('footer-text',false); ?>
					</td>
					<td>
						<input type="text" name="site_footer" value="<?php echo $settings['site_footer']; ?>" style="width:250px;" />
					</td>
				</tr>
			
				<tr>
					<td width="200">
						<?php echo getLangTerm('footer-link',false); ?>
					</td>
					<td>
						<input type="text" name="site_footer_link" value="<?php echo $settings['site_footer_link']; ?>" style="width:250px;" class="validate-url" title="Link is not a valid URL" />
					</td>
				</tr>
				
				<tr>
					<td width="200">
						<?php echo getLangTerm('timezone',false); ?>
					</td>
					<td>
						<select name="timezone" style="width:250px;">
							<?php
							//get default
							$thisoffset = $settings['timezone'];
							for ($x=-12;$x<14;$x++) {
								$s = '';
								if ($thisoffset == ($x*60*60)) {
									$s = ' selected="selected"';
								}
								
								$tz = 'GMT ';
								if ($x<0) {
									$tz .= '-';
								} elseif ($x>0) {
									$tz .= '+';
								}
								if (strlen($x) == 1) {
									$tz .= '0';
								}
								$tz.=$x.':00';
								
								?>
								<option value="<?php echo ($x*60*60); ?>"<?php echo $s; ?>><?php echo $tz; ?></option>
								<?php
							}
							?>
						</select>
					</td>
				</tr>
				
				<tr>
					<td width="200">
						<?php echo getLangTerm('max-upload-size',false); ?>
					</td>
					<td>
						<?php echo getMaxUploadSize(); ?> - <strong><a href="http://ajaxfb.jc21.com/faq/#uploadsize" target="_blank"><?php echo getLangTerm('change-upload-size',false); ?></a></strong>
					</td>
				</tr>
				
				<tr>
					<th colspan="2">
						<?php echo getLangTerm('default-theme',false); ?>
					</th>
				</tr>
				<tr>
					<td colspan="2">
					
						<?php
						for ($x=0;$x<count($dirs);$x++) {
							$s = '';
							if (strtolower(trim($settings['default_theme_dir'],'/')) == strtolower(trim($dirs[$x],'/'))) {
								$s = ' checked="checked"';
							}
							?>
							<div class="theme_sel" style="float:left;width:100px;text-align:center;padding:5px;">
								<label for="theme_<?php echo $x; ?>">
									<img src="<?php echo BASEURL; ?>_themes/<?php echo $dirs[$x]; ?>/theme_small.jpg" border="0" width="100" height="100" alt="<?php echo GetIntelligentName($dirs[$x]); ?>" style="border:1px solid #A7B7BF;width:100px;height:100px;background-color:#D1DADF;" />
								</label>
								<input type="radio" name="default_theme_dir" value="<?php echo trim($dirs[$x],'/'); ?>"<?php echo $s; ?> id="theme_<?php echo $x; ?>" />
							</div>
							<?php
						}
						?>
					</td>
				</tr>
				
				<tr>
					<th colspan="2">
						<?php echo getLangTerm('home-html',false); ?>
					</th>
				</tr>
				<tr>
					<td colspan="2">
						<?php echo getLangTerm('home-html-note',false); ?>
					</td>
				</tr>
				<?php
				if (!$thispage['editor']){
					?>
					<tr>
						<td colspan="2">
							<strong><a href="http://ajaxfb.jc21.com/faq/#tinymce"><?php echo getLangTerm('home-html-tinymce',false); ?></a></strong>
						</td>
					</tr>
					<?php
				}
				?>				
				<tr>
					<td colspan="2">
						<textarea name="home_html" id="home_html" style="width:99%;height:200px;" rows="10" cols="20"><?php echo htmlspecialchars($settings['home_html']); ?></textarea>
					</td>
				</tr>
				<tr>
					<th colspan="2">
						<?php echo getLangTerm('end-html',false); ?>
					</th>
				</tr>
				<tr>
					<td colspan="2">
						<?php echo getLangTerm('end-html-note',false); ?>
					</td>
				</tr>
				<tr>
					<td colspan="2">
						<textarea name="end_html" style="width:99%;height:100px;" rows="10" cols="20"><?php echo htmlspecialchars($settings['end_html']); ?></textarea>
					</td>
				</tr>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<input type="submit" class="button" value="<?php echo getLangTerm('save',false); ?>" name="submit" />
					</td>
				</tr>
			</tfoot>
		</table>
	</form>


<?php
//-----------------------------
include(ADMINROOT.'_foot.php');
//-----------------------------
?>