<?php
//admin section redirections
if (!isset($afbAccount) || $afbAccount->account['account_admin'] !== 'yes'){
	//jump to home
	header("Location: http://".trim($_SERVER['HTTP_HOST'],'/').BASEURL);
	exit();
}






//------------------------------
$thispage['title'] = getLangTerm('reports',false);
if ($_GET['report'] == 'custom'){
	$thispage['calendar'] = true;
	
	if ($_SESSION['report_cal1']){
		$cal1 = $_SESSION['report_cal1'];
	} else {
		$cal1 = time()-(60*60*24*7);
	}
	if ($_SESSION['report_cal2']){
		$cal2 = $_SESSION['report_cal2'];
	} else {
		$cal2 = time();
	}
	
	$thispage['cal1_year'] = date("Y",$cal1);
	$thispage['cal1_month'] = date("m",$cal1);
	$thispage['cal1_day'] = date("d",$cal1);
	
	$thispage['cal2_year'] = date("Y",$cal2);
	$thispage['cal2_month'] = date("m",$cal2);
	$thispage['cal2_day'] = date("d",$cal2);
}
//------------------------------

//get shares
$sql = "SELECT * FROM `".TABLE_PREFIX."shares` ORDER BY `share_name`";
$result = $db->Execute($sql);
$shares = array();
while (!$result->EOF){
	$shares[$result->fields['share_id']] = array('name'=>stripslashes($result->fields['share_name']),'dir'=>stripslashes($result->fields['share_dir']));
	$result->MoveNext();
}

//get accounts
	$sql = "SELECT * FROM `".TABLE_PREFIX."accounts` ORDER BY `account_name`";
	$result = $db->Execute($sql);
	$accounts = array(0=>array('name'=>'Anonymous'));
	while (!$result->EOF){
		$accounts[$result->fields['account_id']] = array('name'=>stripslashes($result->fields['account_name']));
		$result->MoveNext();
	}


//-----------------------------
include(ADMINROOT.'_head.php');
//-----------------------------

switch ($_GET['report']){

	// ---------------------------------------------------------------------------------------------------------
	//top50
	case 'top50':
		?>
		<table border="0" cellspacing="0">
			<caption>Top 50 Downloads</caption>
			<thead>
				<tr>
					<td>
						File
					</td>
					<td>
						Count
					</td>
					<td>
						Share
					</td>
				</tr>
			</thead>
			<tbody>
				<?php
				$sql = "SELECT
					DISTINCT `log_data`,
					`share_id`,
					COUNT(`log_id`) as `cnt`
				FROM
					`".TABLE_PREFIX."log`
				WHERE
					`log_action`='download'
				GROUP BY
					`log_data`,
					`share_id`
				ORDER BY
					`cnt` DESC,
					`log_data`
				LIMIT 0,50
				";
				$result = $db->Execute($sql);
				$recordcount = $result->RecordCount();
				while (!$result->EOF){
					?>
					<tr>
						<td>
							<?php echo htmlspecialchars(GetFilename(stripslashes($result->fields['log_data']))); ?>
						</td>
						<td>
							<?php echo $result->fields['cnt']; ?>
						</td>
						<td>
							<?php echo $shares[$result->fields['share_id']]['name']; ?>
						</td>
					</tr>
					<?php
					$result->MoveNext();
				}
				?>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="3">
						<a href="<?php echo $_SERVER['PHP_SELF']; ?>?admin&section=reports">Go Back</a>
					</td>
				</tr>
			</tfoot>
		</table>
		
		<p>&nbsp;</p>
		
		<?php
		break;
	
	// ---------------------------------------------------------------------------------------------------------
	//recent
	case 'recent':
		?>
		<table border="0" cellspacing="0">
			<caption>Top 50 Downloads</caption>
			<thead>
				<tr>
					<td>
						Time
					</td>
					<td>
						Action
					</td>
					<td>
						Data
					</td>
					<td>
						Account
					</td>
					<td>
						IP
					</td>
				</tr>
			</thead>
			<tbody>
				<?php
				$sql = "SELECT
					*
				FROM
					`".TABLE_PREFIX."log`
				ORDER BY
					`log_timestamp` DESC
				LIMIT 0,50
				";
				$result = $db->Execute($sql);
				$recordcount = $result->RecordCount();
				while (!$result->EOF){
					?>
					<tr>
						<td>
							<?php echo date("g:i a",($result->fields['log_timestamp']+$settings['timezone'])); ?>
							<?php echo date("d-m-Y",($result->fields['log_timestamp']+$settings['timezone'])); ?>
						</td>
						<?php
						switch ($result->fields['log_action']) {
							case 'login':
								?>
								<td>Logged In</td><td>&nbsp;</td>
								<?php
								break;
							case 'logout':
								?>
								<td>Logged Out</td><td>&nbsp;</td>
								<?php
								break;
							case 'download':
								?>
								<td>Downloaded</td><td><?php echo htmlspecialchars(GetFilename(stripslashes($result->fields['log_data']))); ?></td>
								<?php
								break;
							case 'upload':
								?>
								<td>Uploaded</td><td><?php echo htmlspecialchars(GetFilename(stripslashes($result->fields['log_data']))); ?></td>
								<?php
								break;
							case 'delete-file':
								?>
								<td>Deleted File</td><td><?php echo htmlspecialchars(GetFilename(stripslashes($result->fields['log_data']))); ?></td>
								<?php
								break;
							case 'delete-dir':
								?>
								<td>Deleted Folder</td><td><?php echo htmlspecialchars(stripslashes($result->fields['log_data'])); ?></td>
								<?php
								break;
							case 'rename-file':
								?>
								<td>Renamed File</td><td><?php echo htmlspecialchars(GetFilename(stripslashes($result->fields['log_data']))); ?></td>
								<?php
								break;
							case 'rename-dir':
								?>
								<td>Renamed Folder</td><td><?php echo htmlspecialchars(stripslashes($result->fields['log_data'])); ?></td>
								<?php
								break;
							default:
								?><td>&nbsp;</td><td>&nbsp;</td><?php
								break;
						}
						?>
						<td>
							<?php echo $accounts[$result->fields['account_id']]['name']; ?>&nbsp;
						</td>
						<td>
							<?php echo $result->fields['log_ip']; ?>
						</td>
					</tr>
					<?php
					$result->MoveNext();
				}
				?>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="5">
						<a href="<?php echo $_SERVER['PHP_SELF']; ?>?admin&section=reports">Go Back</a>
					</td>
				</tr>
			</tfoot>
		</table>
		
		<p>&nbsp;</p>
		
		<?php
		break;
		
	// ---------------------------------------------------------------------------------------------------------
	//rlogins
	case 'rlogins':
		?>
		<table border="0" cellspacing="0">
			<caption>Recent Logins</caption>
			<thead>
				<tr>
					<td>
						Time
					</td>
					<td>
						Account
					</td>
					<td>
						IP
					</td>
				</tr>
			</thead>
			<tbody>
				<?php
				$sql = "SELECT
					*
				FROM
					`".TABLE_PREFIX."log`
				WHERE
					`log_action`='login'
				ORDER BY
					`log_timestamp` DESC
				LIMIT 0,50
				";
				$result = $db->Execute($sql);
				$recordcount = $result->RecordCount();
				while (!$result->EOF){
					?>
					<tr>
						<td>
							<?php echo date("g:i a",($result->fields['log_timestamp']+$settings['timezone'])); ?>
							<?php echo date("d-m-Y",($result->fields['log_timestamp']+$settings['timezone'])); ?>
						</td>
						<td>
							<?php echo $accounts[$result->fields['account_id']]['name']; ?>&nbsp;
						</td>
						<td>
							<?php echo $result->fields['log_ip']; ?>
						</td>
					</tr>
					<?php
					$result->MoveNext();
				}
				?>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="3">
						<a href="<?php echo $_SERVER['PHP_SELF']; ?>?admin&section=reports">Go Back</a>
					</td>
				</tr>
			</tfoot>
		</table>
		
		<p>&nbsp;</p>
		
		<?php
		break;
		
	// ---------------------------------------------------------------------------------------------------------
	//rdownloads
	case 'rdownloads':
		?>
		<table border="0" cellspacing="0">
			<caption>Recent Downloads</caption>
			<thead>
				<tr>
					<td>
						Time
					</td>
					<td>
						File
					</td>
					<td>
						Share
					</td>
					<td>
						Account
					</td>
					<td>
						IP
					</td>
				</tr>
			</thead>
			<tbody>
				<?php
				$sql = "SELECT
					*
				FROM
					`".TABLE_PREFIX."log`
				WHERE
					`log_action`='download'
				ORDER BY
					`log_timestamp` DESC
				LIMIT 0,50
				";
				$result = $db->Execute($sql);
				$recordcount = $result->RecordCount();
				while (!$result->EOF){
					?>
					<tr>
						<td>
							<?php echo date("g:i a",($result->fields['log_timestamp']+$settings['timezone'])); ?>
							<?php echo date("d-m-Y",($result->fields['log_timestamp']+$settings['timezone'])); ?>
						</td>
						<td>
							<?php echo htmlspecialchars(GetFilename(stripslashes($result->fields['log_data']))); ?>
						</td>
						<td>
							<?php echo $shares[$result->fields['share_id']]['name']; ?>
						</td>
						<td>
							<?php echo $accounts[$result->fields['account_id']]['name']; ?>&nbsp;
						</td>
						<td>
							<?php echo $result->fields['log_ip']; ?>
						</td>
					</tr>
					<?php
					$result->MoveNext();
				}
				?>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="5">
						<a href="<?php echo $_SERVER['PHP_SELF']; ?>?admin&section=reports">Go Back</a>
					</td>
				</tr>
			</tfoot>
		</table>
		
		<p>&nbsp;</p>
		
		<?php
		break;
		
	// ---------------------------------------------------------------------------------------------------------
	//ruploads
	case 'ruploads':
		?>
		<table border="0" cellspacing="0">
			<caption>Recent Uploads</caption>
			<thead>
				<tr>
					<td>
						Time
					</td>
					<td>
						File
					</td>
					<td>
						Share
					</td>
					<td>
						Account
					</td>
					<td>
						IP
					</td>
				</tr>
			</thead>
			<tbody>
				<?php
				$sql = "SELECT
					*
				FROM
					`".TABLE_PREFIX."log`
				WHERE
					`log_action`='upload'
				ORDER BY
					`log_timestamp` DESC
				LIMIT 0,50
				";
				$result = $db->Execute($sql);
				$recordcount = $result->RecordCount();
				while (!$result->EOF){
					?>
					<tr>
						<td>
							<?php echo date("g:i a",($result->fields['log_timestamp']+$settings['timezone'])); ?>
							<?php echo date("d-m-Y",($result->fields['log_timestamp']+$settings['timezone'])); ?>
						</td>
						<td>
							<?php echo htmlspecialchars(GetFilename(stripslashes($result->fields['log_data']))); ?>
						</td>
						<td>
							<?php echo $shares[$result->fields['share_id']]['name']; ?>
						</td>
						<td>
							<?php echo $accounts[$result->fields['account_id']]['name']; ?>&nbsp;
						</td>
						<td>
							<?php echo $result->fields['log_ip']; ?>
						</td>
					</tr>
					<?php
					$result->MoveNext();
				}
				?>
			</tbody>
			<tfoot>
				<tr>
					<td colspan="5">
						<a href="<?php echo $_SERVER['PHP_SELF']; ?>?admin&section=reports">Go Back</a>
					</td>
				</tr>
			</tfoot>
		</table>
		
		<p>&nbsp;</p>
		
		<?php
		break;

	// ---------------------------------------------------------------------------------------------------------
	//custom
	case 'custom':
		?>
		
	
	
	
		<form method="get" action="index.php" name="stat_form">
			<input type="hidden" name="admin" value="" />
			<input type="hidden" name="section" value="reports" />
			<input type="hidden" name="report" value="custom" />
			<input type="hidden" name="from" id="cal1_output" value="" />
			<input type="hidden" name="to" id="cal2_output" value="" />
			<table border="0" cellspacing="0">
				<caption>Custom Report</caption>
				
				<tbody>
					<tr>
						<td width="150">
							From:
						</td>
						<td style="position:relative;">
							<span id="cal1_text"></span>
							<input type="button" name="cal1_select" id="cal1_select" class="button" value="Select" />
							<div id="cal1Container1"></div>
						</td>
					</tr>
					<tr>
						<td width="150">
							To:
						</td>
						<td style="position:relative;">
							<span id="cal2_text"></span>
							<input type="button" name="cal2_select" id="cal2_select" class="button" value="Select" />
							<div id="cal1Container2"></div>
						</td>
					</tr>
					<tr>
						<td width="150">
							Report Type:
						</td>
						<td>
							<select name="type">
								<option value="1"<?php if ($_SESSION['report_type'] == 1){ ?> selected="selected"<?php } ?>>Activity Report</option>
								<option value="2"<?php if ($_SESSION['report_type'] == 2){ ?> selected="selected"<?php } ?>>Most Popular Downloads</option>
								<option value="3"<?php if ($_SESSION['report_type'] == 3){ ?> selected="selected"<?php } ?>>Upload Report</option>
							</select>
						</td>
					</tr>
					<tr>
						<td width="150">
							Account:
						</td>
						<td>
							<select name="account">
								<option value="">All Accounts</option>
								<option value="anon"<?php if ($_SESSION['report_account'] == 'anon'){ ?> selected="selected"<?php } ?>>Anonymous Users</option>
								<?php
								$sql = "SELECT
									*
								FROM
									`".TABLE_PREFIX."accounts`
								ORDER BY
									`account_name`";
								$result = $db->Execute($sql);
								$recordcount = $result->RecordCount();
								if ($recordcount > 0) {
									while (!$result->EOF){
										$s = '';
										if ($_SESSION['report_account'] == $result->fields['account_id']){
											$s = ' selected="selected"';
										}
										?>
										<option value="<?php echo $result->fields['account_id']; ?>"><?php echo stripslashes($result->fields['account_name']); ?></option>
										<?php
										$result->MoveNext();
									}
								}
								?>
							</select>
						</td>
					</tr>
				</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<input type="submit" name="submit" class="button" value="View" />
					</td>
				</tr>
			</tfoot>
		</table>
		
		
		</form>
		<?php
		break;
		
	// ---------------------------------------------------------------------------------------------------------
	//default
	default:
		?>
		
		<div class="report_box">
			<h4><a href="<?php echo $_SERVER['PHP_SELF']; ?>?admin&section=reports&report=top50">Top 50 Downloads</a></h4>
			<p>All time top downloads</p>
		</div>
		
		<div class="report_box">
			<h4><a href="<?php echo $_SERVER['PHP_SELF']; ?>?admin&section=reports&report=recent">Recent Activity</a></h4>
			<p>A short list of the most recent actions</p>
		</div>
		
		<div class="report_box">
			<h4><a href="<?php echo $_SERVER['PHP_SELF']; ?>?admin&section=reports&report=rlogins">Recent Logins</a></h4>
			<p>View recently loggged in stats</p>
		</div>
		
		<div class="report_box">
			<h4><a href="<?php echo $_SERVER['PHP_SELF']; ?>?admin&section=reports&report=rdownloads">Recent Downloads</a></h4>
			<p>View recently downloaded files</p>
		</div>
		
		<div class="report_box">
			<h4><a href="<?php echo $_SERVER['PHP_SELF']; ?>?admin&section=reports&report=ruploads">Recent Uploads</a></h4>
			<p>View recently uploaded files</p>
		</div>
		
		<div class="report_box">
			<h4><a href="<?php echo $_SERVER['PHP_SELF']; ?>?admin&section=reports&report=custom">Custom Report</a></h4>
			<p>Generate a time based report</p>
		</div>
		
		<?php
		break;
		
		
		
} //end switch


//-----------------------------
include(ADMINROOT.'_foot.php');
//-----------------------------
?>