<?php
//admin section redirections
if (!isset($afbAccount) || $afbAccount->account['account_admin'] !== 'yes'){
	//jump to home
	header("Location: http://".trim($_SERVER['HTTP_HOST'],'/').BASEURL);
	exit();
}






//------------------------------
$thispage['title'] = getLangTerm('accounts',false);
//------------------------------




//create
//-----------------------------------------------------------------------------------------------------------------
if (isset($_GET['create'])){
	
	
	
	//check submission
	if (isset($_POST['submit'])){
		
		//name
		if (strlen(trim($_POST['account_name'])) == 0) {
			$errors[] = getLangTerm('ac-name-reqd',false);
		}
		//username
		if (strlen(trim($_POST['account_username'])) == 0) {
			$errors[] = getLangTerm('ac-un-reqd',false);
		} else {
			//check if username is taken
			$sql = "SELECT COUNT(`account_id`) AS `cnt` FROM `".TABLE_PREFIX."accounts` WHERE `account_username`='".trim($_POST['account_username'])."'";
			$result = $db->Execute($sql);
			if ($result->fields['cnt'] > 0) {
				$errors[] = getLangTerm('ac-un-taken',false);
			}
		}
		//password
		if (strlen(trim($_POST['account_password'])) == 0) {
			$errors[] = getLangTerm('password-reqd',false);
		} else {
			if ($_POST['account_password'] !== $_POST['account_password2']) {
				$errors[] = getLangTerm('password-mismatch',false);
			}
		}
		
		if (count($errors) == 0) {
			//ok to create
			
			$sql = "INSERT INTO `".TABLE_PREFIX."accounts` (
				`account_name`,
				`account_username`,
				`account_password`,
				`account_disabled`,
				`account_admin`,
				`theme`
			) VALUES (
				'".addslashes(stripslashes($_POST['account_name']))."',
				'".addslashes(stripslashes($_POST['account_username']))."',
				'".addslashes(stripslashes($_POST['account_password']))."',
				'".addslashes(stripslashes($_POST['account_disabled']))."',
				'".addslashes(stripslashes($_POST['account_admin']))."',
				'".addslashes(stripslashes($_POST['theme']))."'
			)";
			if ($db->Execute($sql) === false) { 
				$errors[] = 'Error: '.$db->ErrorMsg();
			} else {
				//ok
				header("Location: http://".trim($_SERVER['HTTP_HOST'],'/').BASEURL.'index.php?admin&section=accounts');
				exit();
			}
		}
		
	} //end submission check
	
	
	
	
	
	//-----------------------------
	include(ADMINROOT.'_head.php');
	//-----------------------------
		
	if (count($errors) > 0) {
		?>
		<p class="errors"><strong><?php echo getLangTerm('form-val-found',false); ?></strong></p>
		<ul class="errors">
			<?php
				for ($x=0;$x<count($errors);$x++) {
					?><li><?php echo $errors[$x]; ?></li><?php
				}
			?>
		</ul>
		<?php
	}
	
	//get list of themes from dir
	$dh = @opendir('_themes/');
	$dirs = array();
	while (false !== ($file=@readdir($dh))) {
		if (substr($file,0,1)!=".") {  #skip anything that starts with a '.' i.e.:('.', '..', or any hidden file)
			if (is_dir('_themes/'.$file)) {
				$dirs[]=$file;   #put directories into dirs[] and append a '/' to differentiate
			}
		}
	}
	@closedir($dh);
	?>
					
	<form action="index.php?admin&section=accounts&create" name="create" method="post">
		<table border="0" cellspacing="0">
			<thead>
				<tr>
					<td colspan="2">
						<?php echo getLangTerm('create-account',false); ?>
					</td>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="200">
						<?php echo getLangTerm('account-name',false); ?>
					</td>
					<td>
						<input type="text" name="account_name" value="<?php echo stripslashes($_POST['account_name']); ?>" style="width:200px;" class="required" title="<?php echo getLangTerm('ac-name-reqd',false); ?>" />
					</td>
				</tr>
				<tr>
					<td width="200">
						<?php echo getLangTerm('username',false); ?>
					</td>
					<td>
						<input type="text" name="account_username" value="<?php echo stripslashes($_POST['account_username']); ?>" style="width:200px;" class="required" title="<?php echo getLangTerm('ac-un-reqd',false); ?>" />
					</td>
				</tr>
				<tr>
					<td width="200">
						<?php echo getLangTerm('password',false); ?>
					</td>
					<td>
						<input type="password" name="account_password" value="<?php echo stripslashes($_POST['account_password']); ?>" style="width:200px;" class="required" title="<?php echo getLangTerm('password-reqd',false); ?>" />
					</td>
				</tr>
				<tr>
					<td width="200">
						<?php echo getLangTerm('confirm',false); ?>
					</td>
					<td>
						<input type="password" name="account_password2" value="<?php echo stripslashes($_POST['account_password2']); ?>" style="width:200px;" class="required" title="<?php echo getLangTerm('password-reqd',false); ?>" />
					</td>
				</tr>
				<tr>
					<td width="200">
						<?php echo getLangTerm('account-disabled',false); ?>
					</td>
					<td>
						<input type="radio" name="account_disabled" value="no" id="ad_no" checked="checked" /> <label for="ad_no"><?php echo getLangTerm('no',false); ?></label> &nbsp;
						<input type="radio" name="account_disabled" value="yes" id="ad_yes" /> <label for="ad_yes"><?php echo getLangTerm('yes',false); ?></label>
					</td>
				</tr>
				<tr>
					<td width="200">
						<?php echo getLangTerm('admin-account',false); ?>
					</td>
					<td>
						<input type="radio" name="account_admin" value="no" id="aa_no" checked="checked" /> <label for="aa_no"><?php echo getLangTerm('no',false); ?></label> &nbsp;
						<input type="radio" name="account_admin" value="yes" id="aa_yes" /> <label for="aa_yes"><?php echo getLangTerm('yes',false); ?></label>
					</td>
				</tr>
				
				<tr>
					<th colspan="2">
						<?php echo getLangTerm('default-theme',false); ?>
					</th>
				</tr>
				<tr>
					<td colspan="2">
						<div class="theme_sel" style="float:left;width:100px;text-align:center;padding:5px;">
								<label for="theme_def">
									<span style="border:1px solid #A7B7BF;display:block;font-weight:bold;padding-top:20px;width:100px;height:80px;background-color:#D1DADF;"><?php echo getLangTerm('default',false); ?></span>
								</label>
								<input type="radio" name="theme" value="default"<?php
								if ((isset($_POST['theme']) && $_POST['theme'] == 'default') || (!isset($_POST['theme']))) {
									echo ' checked="checked"';
								}
								?> id="theme_def" />
							</div>
						<?php
						for ($x=0;$x<count($dirs);$x++) {
							$s = '';
							if ((isset($_POST['theme']) && $_POST['theme'] == $dirs[$x])) {
								$s = ' checked="checked"';
							}
							?>
							<div class="theme_sel" style="float:left;width:100px;text-align:center;padding:5px;">
								<label for="theme_<?php echo $x; ?>">
									<img src="<?php echo BASEURL; ?>_themes/<?php echo $dirs[$x]; ?>/theme_small.jpg" border="0" width="100" height="100" alt="<?php echo GetIntelligentName($dirs[$x]); ?>" style="border:1px solid #A7B7BF;width:100px;height:100px;background-color:#D1DADF;" />
								</label>
								<input type="radio" name="theme" value="<?php echo trim($dirs[$x],'/'); ?>"<?php echo $s; ?> id="theme_<?php echo $x; ?>" />
							</div>
							<?php
						}
						?>

					</td>
				</tr>
				</tbody>
				<tfoot>
					<tr>
						<td colspan="2">
							<a href="index.php?admin&section=accounts" class="button"><?php echo getLangTerm('cancel',false); ?></a>
							<input type="submit" class="button" value="<?php echo getLangTerm('save',false); ?>" name="submit" />
						</td>
					</tr>
				</tfoot>
			</tr>
		</table>
	</form>
	
	
	
	<?php
	
	//-----------------------------
	include(ADMINROOT.'_foot.php');
	//-----------------------------

//edit
//-----------------------------------------------------------------------------------------------------------------
} elseif (isset($_GET['edit'])){
	
	//get account details
	$sql = "SELECT * FROM `".TABLE_PREFIX."accounts` WHERE `account_id`='".addslashes(stripslashes($_GET['edit']))."' LIMIT 0,1";
	$result = $db->Execute($sql);
	$account_id = $result->fields['account_id'];
	
	
	if (isset($_POST['submit'])){
		//name
		if (strlen(trim($_POST['account_name'])) == 0) {
			$errors[] = getLangTerm('ac-name-reqd',false);
		}
		//username
		if (strlen(trim($_POST['account_username'])) == 0) {
			$errors[] = getLangTerm('ac-un-reqd',false);
		} else {
			//check if username is taken
			$sql = "SELECT COUNT(`account_id`) AS `cnt` FROM `".TABLE_PREFIX."accounts` WHERE `account_username`='".trim(addslashes(stripslashes($_POST['account_username'])))."' AND `account_id` <> '".$account_id."'";
			$result = $db->Execute($sql);
			if ($result->fields['cnt'] > 0) {
				$errors[] = getLangTerm('ac-un-taken',false);
			}
		}
		//password
		if (strlen(trim($_POST['account_password'])) == 0) {
			$errors[] = getLangTerm('password-reqd',false);
		} else {
			if ($_POST['account_password'] !== $_POST['account_password2']) {
				$errors[] = getLangTerm('password-mismatch',false);
			}
		}
		
		//check if we're editing ourself
		if ($afbAccount->account['account_id'] == $account_id) {
			$_POST['account_admin'] = 'yes';
			$_POST['account_disabled'] = 'no';
		}
		
		if (count($errors) == 0) {
			//ok to update
			
			$sql = "UPDATE `".TABLE_PREFIX."accounts` SET
				`account_name`='".addslashes(stripslashes($_POST['account_name']))."',
				`account_username`='".addslashes(stripslashes($_POST['account_username']))."',
				`account_password`='".addslashes(stripslashes($_POST['account_password']))."',
				`account_disabled`='".addslashes(stripslashes($_POST['account_disabled']))."',
				`account_admin`='".addslashes(stripslashes($_POST['account_admin']))."',
				`theme`='".addslashes(stripslashes($_POST['theme']))."'
			WHERE `account_id`='".$account_id."'
			LIMIT 1";
			if ($db->Execute($sql) === false) { 
				$errors[] = 'Error: '.$db->ErrorMsg();
			} else {
				if ($afbAccount->account['account_id'] == $account_id) {
					$_SESSION['afb_username'] = $_POST['account_username'];
					$_SESSION['afb_password'] = $_POST['account_password'];
				}
				//redir
				header("Location: http://".trim($_SERVER['HTTP_HOST'],'/').BASEURL.'index.php?admin&section=accounts');
				exit();
			}
		}
	}//end update
	
	
	
	//-----------------------------
	include(ADMINROOT.'_head.php');
	//-----------------------------
	
	if (count($errors) > 0) {
		?>
		<p class="errors"><strong><?php echo getLangTerm('form-val-found',false); ?></strong></p>
		<ul class="errors">
			<?php
				for ($x=0;$x<count($errors);$x++) {
					?><li><?php echo $errors[$x]; ?></li><?php
				}
			?>
		</ul>
		<?php
	}
	
	//get list of themes from dir
	$dh = @opendir('_themes/');
	$dirs = array();
	while (false !== ($file=@readdir($dh))) {
		if (substr($file,0,1)!=".") {  #skip anything that starts with a '.' i.e.:('.', '..', or any hidden file)
			if (is_dir('_themes/'.$file)) {
				$dirs[]=$file;   #put directories into dirs[] and append a '/' to differentiate
			}
		}
	}
	@closedir($dh);

					
	?>
	
	<form action="index.php?admin&section=accounts&edit=<?php echo $account_id; ?>" name="edit" method="post">
		<table border="0" cellspacing="0">
			<thead>
				<tr>
					<td colspan="2">
						<?php echo getLangTerm('edit-account',false); ?>
					</td>
				</tr>
			</thead>
			<tbody>
				<tr>
					<td width="200">
						<?php echo getLangTerm('account-name',false); ?>
					</td>
					<td>
						<input type="text" name="account_name" value="<?php if (isset($_POST['account_name'])) { echo stripslashes($_POST['account_name']); } else { echo stripslashes($result->fields['account_name']); } ?>" style="width:200px;" class="required" title="<?php echo getLangTerm('ac-name-reqd',false); ?>" />
					</td>
				</tr>
				<tr>
					<td width="200">
						<?php echo getLangTerm('username',false); ?>
					</td>
					<td>
						<input type="text" name="account_username" value="<?php if (isset($_POST['account_username'])) { echo stripslashes($_POST['account_username']); } else { echo stripslashes($result->fields['account_username']); } ?>" style="width:200px;" class="required" title="<?php echo getLangTerm('ac-un-reqd',false); ?>" />
					</td>
				</tr>
				<tr>
					<td width="200">
						<?php echo getLangTerm('password',false); ?>
					</td>
					<td>
						<input type="password" name="account_password" value="<?php if (isset($_POST['account_password'])) { echo stripslashes($_POST['account_password']); } else { echo stripslashes($result->fields['account_password']); } ?>" style="width:200px;" class="required" title="<?php echo getLangTerm('password-reqd',false); ?>" />
					</td>
				</tr>
				<tr>
					<td width="200">
						<?php echo getLangTerm('confirm',false); ?>
					</td>
					<td>
						<input type="password" name="account_password2" value="<?php if (isset($_POST['account_password2'])) { echo stripslashes($_POST['account_password2']); } else { echo stripslashes($result->fields['account_password']); } ?>" style="width:200px;" class="required" title="<?php echo getLangTerm('password-reqd',false); ?>" />
					</td>
				</tr>
				<tr>
					<td width="200">
						<?php echo getLangTerm('account-disabled',false); ?>
					</td>
					<td>
						<input type="radio" name="account_disabled" value="no" id="ad_no"<?php if ((isset($_POST['account_disabled']) && $_POST['account_disabled'] == 'no') || (!isset($_POST['account_disabled']) && $result->fields['account_disabled'] == 'no')) { echo ' checked="checked"'; } ?><?php if ($result->fields['account_id'] == $afbAccount->account['account_id']) { echo ' disabled="disabled"'; } ?> /> <label for="ad_no">No</label> &nbsp;
						<input type="radio" name="account_disabled" value="yes" id="ad_yes"<?php if ((isset($_POST['account_disabled']) && $_POST['account_disabled'] == 'yes') || (!isset($_POST['account_disabled']) && $result->fields['account_disabled'] == 'yes')) { echo ' checked="checked"'; } ?><?php if ($result->fields['account_id'] == $afbAccount->account['account_id']) { echo ' disabled="disabled"'; } ?> /> <label for="ad_yes">Yes</label>
					</td>
				</tr>
				<tr>
					<td width="200">
						<?php echo getLangTerm('admin-account',false); ?>
					</td>
					<td>
						<input type="radio" name="account_admin" value="no" id="aa_no"<?php if ((isset($_POST['account_admin']) && $_POST['account_admin'] == 'no') || (!isset($_POST['account_admin']) && $result->fields['account_admin'] == 'no')) { echo ' checked="checked"'; } ?><?php if ($result->fields['account_id'] == $afbAccount->account['account_id']) { echo ' disabled="disabled"'; } ?> /> <label for="aa_no">No</label> &nbsp;
						<input type="radio" name="account_admin" value="yes" id="aa_yes"<?php if ((isset($_POST['account_admin']) && $_POST['account_admin'] == 'yes') || (!isset($_POST['account_admin']) && $result->fields['account_admin'] == 'yes')) { echo ' checked="checked"'; } ?><?php if ($result->fields['account_id'] == $afbAccount->account['account_id']) { echo ' disabled="disabled"'; } ?> /> <label for="aa_yes">Yes</label>
					</td>
				</tr>
				
				<tr>
					<th colspan="2">
						<?php echo getLangTerm('default-theme',false); ?>
					</th>
				</tr>
				<tr>
					<td colspan="2">
						<div class="theme_sel" style="float:left;width:100px;text-align:center;padding:5px;">
								<label for="theme_def">
									<span style="border:1px solid #A7B7BF;display:block;font-weight:bold;padding-top:20px;width:100px;height:80px;background-color:#D1DADF;"><?php echo getLangTerm('default',false); ?></span>
								</label>
								<input type="radio" name="theme" value="default"<?php
								if ((isset($_POST['theme']) && $_POST['theme'] == 'default') || (!isset($_POST['theme']) && $result->fields['theme'] == 'default')) {
									echo ' checked="checked"';
								}
								?> id="theme_def" />
							</div>
						<?php
						for ($x=0;$x<count($dirs);$x++) {
							$s = '';
							if ((isset($_POST['theme']) && $_POST['theme'] == $dirs[$x]) || (!isset($_POST['theme']) && $result->fields['theme'] == $dirs[$x])) {
								$s = ' checked="checked"';
							}
							?>
							<div class="theme_sel" style="float:left;width:100px;text-align:center;padding:5px;">
								<label for="theme_<?php echo $x; ?>">
									<img src="<?php echo BASEURL; ?>_themes/<?php echo $dirs[$x]; ?>/theme_small.jpg" border="0" width="100" height="100" alt="<?php echo GetIntelligentName($dirs[$x]); ?>" style="border:1px solid #A7B7BF;width:100px;height:100px;background-color:#D1DADF;" />
								</label>
								<input type="radio" name="theme" value="<?php echo trim($dirs[$x],'/'); ?>"<?php echo $s; ?> id="theme_<?php echo $x; ?>" />
							</div>
							<?php
						}
						?>

					</td>
				</tr>
				
			</tbody>
			<tfoot>
				<tr>
					<td colspan="2">
						<a href="index.php?admin&section=accounts" class="button"><?php echo getLangTerm('cancel',false); ?></a>
						<input type="submit" class="button" value="<?php echo getLangTerm('save',false); ?>" name="submit" />
					</td>
				</tr>
			</tfoot>
		</table>
	</form>
	
	<?php
	
	//-----------------------------
	include(ADMINROOT.'_foot.php');
	//-----------------------------

//remove
//-----------------------------------------------------------------------------------------------------------------
} elseif (isset($_GET['remove'])){
	
	$sql = "DELETE FROM `".TABLE_PREFIX."accounts` WHERE `account_id`='" . $_GET['remove'] . "'";
	if ($db->Execute($sql) === false) { 
		//$negative = 'Error: '.$db->ErrorMsg();
	} else {
		if ($db->Affected_Rows()) {
			$sql = "DELETE FROM `".TALBE_PREFIX."accounts_has_perms` WHERE `account_id`='" . $_GET['remove'] . "'";
			if ($db->Execute($sql) === false) { 
				//$negative = 'Error: '.$db->ErrorMsg();
			}
			//$affirmative = 'Account has been removed';
		}
	}
	
	header("Location: http://".trim($_SERVER['HTTP_HOST'],'/').BASEURL.'index.php?admin&section=accounts');
	exit();

//default
//-----------------------------------------------------------------------------------------------------------------
} else {
	//-----------------------------
	include(ADMINROOT.'_head.php');
	//-----------------------------
	?>
	<table border="0" cellspacing="0">
		<thead>
			<tr>
				<td>
					<?php echo getLangTerm('account',false); ?>
				</td>
				<td>
					<?php echo getLangTerm('username',false); ?>
				</td>
				<td>
					<?php echo getLangTerm('last-login',false); ?>
				</td>
				<td>
					<?php echo getLangTerm('administrator',false); ?>
				</td>
				<td>
					<?php echo getLangTerm('disabled',false); ?>
				</td>
				<td colspan="2">&nbsp;
					
				</td>
			</tr>
		</thead>
		<tbody>
		<?php
		$sql = "SELECT * FROM `".TABLE_PREFIX."accounts` ORDER BY `account_name`";
		$result = $db->Execute($sql);
		$recordcount = $result->RecordCount();
		while (!$result->EOF){
			?>
			<tr<?php if ($result->fields['account_disabled'] == 'yes') { ?> style="background-color:#fdd;"<?php } ?>>
				<td>
					<?php echo htmlspecialchars(stripslashes($result->fields['account_name'])); ?>
				</td>
				<td>
					<?php echo htmlspecialchars(stripslashes($result->fields['account_username'])); ?>
				</td>
				<td>
					<?php
					//get last login
					$sql2 = "SELECT * FROM `".TABLE_PREFIX."log` WHERE `account_id`='" . $result->fields['account_id'] . "' AND `log_action`='login' ORDER BY `log_timestamp` DESC LIMIT 0,1";
					$result2 = $db->Execute($sql2);
					$recordcount = $result2->RecordCount();
					if ($recordcount == 0) {
						?>-<?php
					} else {
						$last_login = $result2->fields['log_timestamp'];
						$days = GetDateDiffDays($last_login,GMT_TIME);
						if ($days == 0) {
							echo getLangTerm('today',false);
						} elseif ($days == 1) {
							echo getLangTerm('yesterday',false);
						} else {
							echo $days.' '.getLangTerm('days-ago',false);
						}
					}
					?>
				</td>
				<td>
					<?php
					if ($result->fields['account_admin'] == 'yes') {
						echo getLangTerm('yes',false);
					} else {
						echo getLangTerm('no',false);
					}						
					?>
				</td>
				<td>
					<?php
					if ($result->fields['account_disabled'] == 'yes') {
						echo getLangTerm('yes',false);
					} else {
						echo getLangTerm('no',false);
					}						
					?>
				</td>
				<td width="16">
					<a href="index.php?admin&section=accounts&edit=<?php echo $result->fields['account_id']; ?>" title="<?php echo getLangTerm('edit-account',false); ?>"><img src="<?php echo BASEURL; ?>_includes/admin/theme/images/edit.gif" border="0" width="16" height="16" alt="<?php echo getLangTerm('edit-account',false); ?>" /></a>
				</td>
				<td width="16">
					<?php
					if (stripslashes($result->fields['account_username']) != $afbAccount->account['account_username']) {
						?>
						<a href="javascript:void(AskQuestion('<?php echo getLangTerm('rem-ac-ques'); ?>','index.php?admin&section=accounts&remove=<?php echo $result->fields['account_id']; ?>'));" title="<?php echo getLangTerm('remove-account',false); ?>"><img src="<?php echo BASEURL; ?>_includes/admin/theme/images/remove.gif" border="0" width="16" height="16" alt="<?php echo getLangTerm('remove-account',false); ?>" /></a>
						<?php
					} else {
						?>&nbsp;<?php
					}
					?>
				</td>
			</tr>
			<?php
			$result->MoveNext();
		}
		?>
		</tbody>
		<tfoot>
			<tr>
				<td colspan="7">
					<a href="index.php?admin&section=accounts&create" title="<?php echo getLangTerm('create-account',false); ?>"><?php echo getLangTerm('create-account',false); ?></a></strong>
				</td>
			</tr>
		</tfoot>
	</table>
	
	<?php
	//-----------------------------
	include(ADMINROOT.'_foot.php');
	//-----------------------------
	
} //end if

?>