<?php
//gzip settings
//ini_set('zlib.output_compression', 'On');

$approot = '';

define("SECURITY",true); // for a more secure site.
// ------------------------------------------------------------------------------------------------
// INCLUDES
// This sets the include path relative to the current directory.
session_start();


//check for config file.
if (!file_exists($approot.'_includes/config.inc.php')) {
	//send to install
	header("Content-type: text/xml");
	echo chr(60).chr(63).'xml version="1.0" encoding="utf-8" '.chr(63).chr(62);
	echo '<xmlresponse>';
	SetError('1000',getLangTerm('not-installed',false));
	echo '</xmlresponse>';
	exit();
}

// now that all is well, include config files.
require_once($approot.'_includes/config.inc.php');
require_once($approot.'_includes/settings.inc.php');

//security...
if (!isset($_GET['upload']) && count($_FILES) == 0){
	if (SECURITY && $_SERVER['HTTP_AJAXREQUEST'] !== 'confirmed') {
		header("Content-type: text/xml");
		echo chr(60).chr(63).'xml version="1.0" encoding="utf-8" '.chr(63).chr(62);
		?><xmlresponse>
			<?php SetError(1,getLangTerm('bad-ajax',false)); ?>
		</xmlresponse>
		<?php
		exit();
	}
}
// ------------------------------------------------------------------------------------------------

header("Content-type: text/xml; charset=utf-8");
echo chr(60).chr(63).'xml version="1.0" encoding="utf-8" '.chr(63).chr(62);

?>
<xmlresponse>
	
	<?php
	//--------------------------------------------------------------------------------------
	//getShares - gets list of shares and maybe some statistics.
	if (isset($_GET['getShares'])) {
		
		$shares = afbGetShares();
		?><count><?php echo count($shares); ?></count><?php
		
		for ($x=0;$x<count($shares);$x++){
			?>
			<share>
				<id><?php echo htmlspecialchars($shares[$x]['id']); ?></id>
				<name><?php echo htmlspecialchars($shares[$x]['name']); ?></name>
				<description><?php echo htmlspecialchars($shares[$x]['description']); ?></description>
				<perm_list><?php echo htmlspecialchars($shares[$x]['perm_list']); ?></perm_list>
				<perm_write><?php echo htmlspecialchars($shares[$x]['perm_write']); ?></perm_write>
				<perm_download><?php echo htmlspecialchars($shares[$x]['perm_download']); ?></perm_download>
				<perm_modify><?php echo htmlspecialchars($shares[$x]['perm_modify']); ?></perm_modify>
			</share>
			<?php
		}
		
		SetError();
		
	//--------------------------------------------------------------------------------------
	//getShare - gets a share listing.
	} elseif (isset($_GET['getShare'])) {
		
		$share_id = $_GET['share'];
		$share = afbGetShare($share_id);
		$path = rawurldecode(stripslashes($_GET['path']));
		if ($share && isset($share['id'])) {
			
			?>
			<share>
				<id><?php echo htmlspecialchars($share['id']); ?></id>
				<name><?php echo htmlspecialchars($share['name']); ?></name>
				<description><?php echo htmlspecialchars($share['description']); ?></description>
				<perm_list><?php if ($share['perm_list']) { echo '1'; } else { echo '0'; } ?></perm_list>
				<perm_write><?php if ($share['perm_write']) { echo '1'; } else { echo '0'; } ?></perm_write>
				<perm_download><?php if ($share['perm_download']) { echo '1'; } else { echo '0'; } ?></perm_download>
				<perm_modify><?php if ($share['perm_modify']) { echo '1'; } else { echo '0'; } ?></perm_modify>
			</share>
			<?php
			
			
			
			//breadcrumbs
			?>
			<breadcrumb>
				<?php
				$crumbs = explode('/',$path);
				$stack = array();
				for ($x=0;$x<count($crumbs);$x++) {
					if (strlen($crumbs[$x]) > 0){
						$stack[] = $crumbs[$x];
						?>
						<crumb>
							<name><?php echo htmlspecialchars(rawurlencode($crumbs[$x])); ?></name>
							<path><?php echo htmlspecialchars(rawurlencode(TieString(implode('/',$stack),'/','/'))); ?></path>
						</crumb>
						<?php
					}
				}
				?>
			</breadcrumb>
			
			<?php
			
			
			
			
			
			//get initial share listing
			$listing = afbGetListing($share,$path);
			
			?>
			<dirs>
				<?php
				for ($x=0;$x<count($listing['dirs']);$x++){
					?>
					<dir>
						<name><?php echo htmlspecialchars(rawurlencode($listing['dirs'][$x]['name'])); ?></name>
						<path><?php echo htmlspecialchars(rawurlencode($listing['dirs'][$x]['path'])); ?></path>
						<fullpath><?php echo htmlspecialchars(rawurlencode($listing['dirs'][$x]['path'])); ?></fullpath>
						<unique><?php echo htmlspecialchars($listing['dirs'][$x]['unique']); ?></unique>
						<thumbnail><?php echo htmlspecialchars($listing['dirs'][$x]['thumbnail']); ?></thumbnail>
					</dir>
					<?php
				}
				?>
			</dirs>
			<?php
			
			?>
			<files>
				<?php
				for ($x=0;$x<count($listing['files']);$x++){
					?>
					<file>
						<name><?php echo htmlspecialchars(rawurlencode($listing['files'][$x]['name'])); ?></name>
						<path><?php echo htmlspecialchars(rawurlencode($listing['files'][$x]['path'])); ?></path>
						<type><?php echo htmlspecialchars(rawurlencode($listing['files'][$x]['type'])); ?></type>
						<size><?php echo htmlspecialchars($listing['files'][$x]['size']); ?></size>
						<fullpath><?php echo htmlspecialchars(rawurlencode($listing['files'][$x]['path'])); ?></fullpath>
						<unique><?php echo htmlspecialchars($listing['files'][$x]['unique']); ?></unique>
						<thumbnail><?php echo htmlspecialchars($listing['files'][$x]['thumbnail']); ?></thumbnail>
						<category><?php echo htmlspecialchars($listing['files'][$x]['category']); ?></category>
						
					</file>
					<?php
				}
				?>
			</files>
			<?php
			
			SetError();
			
		} else {
			SetError(20,getLangTerm('share-not-exist',false));
		}
	
	//--------------------------------------------------------------------------------------
	//getPreviewInfo - gets a share listing.
	} elseif (isset($_GET['getPreviewInfo'])) {
		
		$share_id = $_GET['share'];
		$share = afbGetShare($share_id);
		//check if read perms aswell
		if ($share && isset($share['id']) && $share['perm_list']) {
			
			$pd = afbGetPreviewDetails($share,rawurldecode(stripslashes($_GET['path'])));
			if ($pd){
				if ($pd['type'] == 'dir'){
					//dir
					?>
					<preview>
						<type>dir</type>
						<name><?php echo htmlspecialchars(rawurlencode($pd['name'])); ?></name>
						<files><?php echo htmlspecialchars(rawurlencode($pd['files'])); ?></files>
						<dirs><?php echo htmlspecialchars(rawurlencode($pd['dirs'])); ?></dirs>
						<size><?php echo htmlspecialchars($pd['size']); ?></size>
						<img><?php echo htmlspecialchars(rawurlencode($pd['preview'])); ?></img>
					</preview>
					<?php
				} elseif ($pd['type'] = 'file') {
					?>
					<preview>
						<type>file</type>
						<name><?php echo htmlspecialchars(rawurlencode($pd['name'])); ?></name>
						<ext><?php echo htmlspecialchars(rawurlencode($pd['ext'])); ?></ext>
						<size><?php echo htmlspecialchars($pd['size']); ?></size>
						<img><?php echo htmlspecialchars(rawurlencode($pd['preview'])); ?></img>
						<category><?php echo htmlspecialchars(rawurlencode($pd['category'])); ?></category>
						<download><?php echo htmlspecialchars(rawurlencode($pd['download'])); ?></download>
						<dimensions><?php echo htmlspecialchars($pd['dimensions']); ?></dimensions>
					</preview>
					<?php
				}
				SetError();
				
			} else {
				SetError(20,getLangTerm('no-exist',false));
			}
			
			
		} else {
			SetError(20,getLangTerm('no-exist',false));
		}
	
	//--------------------------------------------------------------------------------------
	//createDir - create a directory
	} elseif (isset($_GET['createDir'])){
		
		$share_id = $_GET['share'];
		$share = afbGetShare($share_id);
		$path = rawurldecode(stripslashes($_GET['path']));
		$fullpath = TieString($share['dir'],'','/').trim($path,'/');
		$fullpath = TieString($fullpath,'','/');
		$new_dir = trim(trim(rawurldecode(stripslashes($_GET['dir'])),'/'));
		$new_dir = str_replace('/','',$new_dir);
		
		
		if ($share && isset($share['id']) && is_dir($fullpath)) {
			if (mkdir($fullpath.$new_dir, 0777)){
				afbLogit('create-dir',$new_dir,$share_id);
				?>
				<dir>
					<name><?php echo htmlspecialchars($new_dir); ?></name>
					<fullpath><?php echo htmlspecialchars(TieString($path,'/','/').TieString($new_dir,'','/')); ?></fullpath>
					<unique><?php echo md5($share['id'].TieString($path,'/','/').TieString($new_dir,'','/')); ?></unique>
				</dir>
				<?php
				
				SetError();
			} else {
				SetError(21,getLangTerm('create-dir-fail',false));
			}
		} else {
			SetError(20,getLangTerm('share-not-exist',false));
		}
	
	//--------------------------------------------------------------------------------------
	//delete - either dir or file.
	} elseif (isset($_GET['delete'])){
		
		$share_id = $_GET['share'];
		$share = afbGetShare($share_id);
		$path = rawurldecode(stripslashes($_GET['path']));
		$fullpath = TieString($share['dir'],'','/').trim($path,'/');
		$type = trim(rawurldecode(stripslashes($_GET['t'])));
		
		if ($share && isset($share['id'])) {
			if ($type == 'dir' && is_dir(TieString($fullpath,'','/'))){
				//dir
				$fullpath = TieString($fullpath,'','/');
				if (deleteDirectory($fullpath)){
					afbLogit('delete-dir',$path,$share_id);
					SetError();
				} else {
					SetError(22,getLangTerm('delete-dir-fail',false));
				}
				
			} elseif ($type == 'file' && is_file($fullpath)){
				//file
				if (unlink($fullpath)){
					afbLogit('delete-file',$path,$share_id);
					SetError();
				} else {
					SetError(21,getLangTerm('delete-file-fail',false));
				}
				
			} else {
				SetError(40,getLangTerm('item-not-found',false));
			}	
		} else {
			SetError(20,getLangTerm('share-not-exist',false));
		}
	
	//--------------------------------------------------------------------------------------
	//rename - either dir or file.
	} elseif (isset($_GET['rename'])){
		
		$share_id = $_GET['share'];
		$share = afbGetShare($share_id);
		$path = rawurldecode(stripslashes($_GET['path']));
		$fullpath = TieString($share['dir'],'','/').trim($path,'/');
		$type = trim(rawurldecode(stripslashes($_GET['t'])));
		$to = trim(rawurldecode(stripslashes($_GET['to'])));
		
		if ($share && isset($share['id'])) {
			if ($type == 'dir' && is_dir($fullpath) && strlen($path) > 1){
				//dir
				$src = $fullpath;
				//got to get the first level up in the tree...
				$dest = TieString(substr($fullpath,0,strrpos($fullpath,'/')),'','/').$to;
				
				//check that destination exists
				if (!is_dir($dest)){
					if (rename($src,$dest)){
						afbLogit('rename-dir',$path,$share_id);
						//return file data.
						$dest = TieString(trim($dest,$share['dir']),'/');
						?>
						<data>
							<name><?php echo htmlspecialchars($to); ?></name>
							<path><?php echo htmlspecialchars(TieString($dest,'','/')); ?></path>
							<fullpath><?php echo htmlspecialchars(TieString($dest,'','/')); ?></fullpath>
							<unique><?php echo htmlspecialchars(md5($share['id'].TieString($dest,'','/'))); ?></unique>
						</data>
						<?php
						SetError();
					} else {
						SetError(21,getLangTerm('rename-dir-fail',false));
					}
				} else {
					SetError(21,getLangTerm('rename-dir-exists',false));
				}
				
			} elseif ($type == 'file' && is_file($fullpath)){
				//file
				$src = $fullpath;
				$dest = TieString(dirname($fullpath),'','/').$to;
				//check that destination exists
				if (!is_file($dest)){
					if (rename($src,$dest)){
						afbLogit('rename-file',$path,$share_id);
						//return file data.
						$dest = TieString(trim($dest,$share['dir']),'/');
						?>
						<data>
							<name><?php echo htmlspecialchars($to); ?></name>
							<path><?php echo htmlspecialchars($dest); ?></path>
							<type><?php echo htmlspecialchars(GetExt($dest)); ?></type>
							<size><?php echo htmlspecialchars(GetSize(sprintf("%u", @filesize($dest)))); ?></size>
							<fullpath><?php echo htmlspecialchars($dest); ?></fullpath>
							<unique><?php echo htmlspecialchars(md5($share['id'].$dest)); ?></unique>
						</data>
						<?php
						SetError();
					} else {
						SetError(21,getLangTerm('rename-file-fail',false));
					}
				} else {
					SetError(21,getLangTerm('rename-file-exists',false));
				}
			} else {
				SetError(40,getLangTerm('item-not-found',false));
			}	
		} else {
			SetError(20,getLangTerm('share-not-exist',false));
		}
	
	//--------------------------------------------------------------------------------------
	//upload
	} elseif (isset($_GET['upload'])){
		
		$share_id = $_GET['share'];
		$share = afbGetShare($share_id);
		$path = rawurldecode(stripslashes($_GET['path']));
		$fullpath = TieString(TieString($share['dir'],'','/').trim($path,'/'),'','/');
		$overwrite = $_GET['ow'];
		if (strlen($overwrite) == 0 || $overwrite < 1){
			$overwrite = false;
		} else {
			$overwrite = true;
		}
		
		if ($share && isset($share['id']) && $share['perm_write']){
			foreach($_FILES as $key => $file){
				
				//check if file exists.
				
				if (file_exists($fullpath.stripslashes($file['name']))){
					//check for overwrite
					if (!$overwrite){
						//chang the name
						$cont = true;
						$count = 1;
						do {
							$nn = GetFilename(stripslashes($file['name'])).'('.$count.').'.GetExt(stripslashes($file['name']));
							if (!file_exists($fullpath.$nn)){
								$cont = false;
								$file['name'] = addslashes($nn);
							}
							$count++;
						} while ($cont == true);
					}
				} //end file_exists check
				//now chop to it!
				$src = $file['tmp_name'];
				$dest = $fullpath.stripslashes($file['name']);
			
				if (copy($src,$dest)){
					afbLogit('upload',$path.stripslashes($file['name']),$share_id);
					?>
					<upload>
						<result>success</result>
					</upload>
					<?php
				} else {
					?>
					<upload>
						<result>failure</result>
					</upload>
					<?php
				}
				
			} //end foreach
		} else {
			SetError(21,'Invalid');
		}
	
	//--------------------------------------------------------------------------------------
	//login
	} elseif (isset($_GET['login'])){
		$u = trim(rawurldecode(stripslashes($_GET['u'])));
		$p = rawurldecode(stripslashes($_GET['p']));
		
		if (strlen($u) == 0){
			SetError(30,getLangTerm('user-required',false));
		} elseif (strlen($p) == 0){
			SetError(31,getLangTerm('pass-required',false));
		} else {
			
			//try to authenticate.
			$_SESSION['afb_username'] = $u;
			$_SESSION['afb_password'] = $p;
			include($approot.'_includes/auth.inc.php');
			
			if(isset($afbAccount)){
				?>
				<account>
					<name><?php echo htmlspecialchars($afbAccount->account['account_name']); ?></name>
				</account>
				<?php
				SetError();
			} else {
				SetError(40,$login_error);
			}
			
		}
	
	//logout
	} elseif (isset($_GET['logout'])) {
		?>
		
		<account>
			<name>Guest</name>
		</account>
				
		<?php
		SetError();
	
	//--------------------------------------------------------------------------------------
	//default - error.
	} else {
		
		SetError(404,getLangTerm('not-found',false));
		
	} //end if
	
	?> 
</xmlresponse><?php


// ----------------------------------------------------------------------------------------------------
// FUNCTIONS 
// ----------------------------------------------------------------------------------------------------

//this sets the error code node - essential for every xml document to be returned.
function SetError($code=0,$text='') {
	echo "\t<error_code>" . $code . "</error_code>\n\t<error>" . htmlspecialchars(rawurlencode($text)) . "</error>\n";
}
?>