CREATE TABLE IF NOT EXISTS `comments` (
  `ID` bigint(20) NOT NULL auto_increment,
  `UID` bigint(20) NOT NULL,
  `FROM_ID` bigint(20) NOT NULL,
  `MESSAGE` text NOT NULL,
  `ENTRYDATE` datetime NOT NULL,
  `STATUS` set('1','2') NOT NULL default '1',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

CREATE TABLE IF NOT EXISTS `directmessages` (
  `MSGID` bigint(20) NOT NULL auto_increment,
  `TO_LOGIN` varchar(54) NOT NULL,
  `FROM_LOGIN` varchar(54) NOT NULL,
  `ENTRYDATE` datetime NOT NULL,
  `STATUS` set('1','2','3') NOT NULL default '1',
  `MESSAGE` varchar(141) NOT NULL,
  PRIMARY KEY  (`MSGID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

CREATE TABLE IF NOT EXISTS `favorites` (
  `USERID` bigint(20) NOT NULL,
  `MSGID` bigint(20) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `friends` (
  `USERID` bigint(255) NOT NULL default '0',
  `FRIENDID` bigint(255) NOT NULL default '0'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `grooner` (
  `ID` bigint(255) NOT NULL auto_increment,
  `USERID` bigint(255) NOT NULL default '0',
  `USERMSG` varchar(141) NOT NULL default '',
  `ENTRYDATE` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

CREATE TABLE IF NOT EXISTS `grooner_spam` (
  `ID` bigint(255) NOT NULL auto_increment,
  `USERID` bigint(255) NOT NULL default '0',
  `USERMSG` varchar(141) NOT NULL,
  `ENTRYDATE` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

CREATE TABLE IF NOT EXISTS `mailboxes` (
  `MSGID` bigint(20) NOT NULL auto_increment,
  `TO_ID` bigint(20) NOT NULL,
  `FROM_ID` bigint(20) NOT NULL,
  `ENTRYDATE` datetime NOT NULL default '0000-00-00 00:00:00',
  `STATUS` set('1','2','3') NOT NULL default '1',
  `SUBJECT` varchar(150) NOT NULL,
  `MESSAGE` text NOT NULL,
  PRIMARY KEY  (`MSGID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=38 ;

CREATE TABLE IF NOT EXISTS `public_profile` (
  `ID` bigint(255) NOT NULL auto_increment,
  `USERID` bigint(255) NOT NULL default '0',
  `LOGIN` varchar(125) NOT NULL default '',
  `IMAGE` longtext NOT NULL,
  `NAME` varchar(125) NOT NULL default '',
  `LOCATION` varchar(150) NOT NULL default '',
  `INTERESTS` text NOT NULL,
  `HOBBIES` text NOT NULL,
  `WEBSITE` varchar(150) NOT NULL default 'http://',
  `PORTFOLIO` varchar(150) NOT NULL default 'http://',
  `BDAY` varchar(23) NOT NULL default 'yyyy-mm-dd',
  `AIM` varchar(25) NOT NULL default '',
  `ICQ` varchar(25) NOT NULL default '',
  `YIM` varchar(25) NOT NULL default '',
  `MSN` varchar(25) NOT NULL default '',
  `GTALK` varchar(25) NOT NULL default '',
  `ISACTIVE` varchar(15) NOT NULL default '0',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=4 ;

CREATE TABLE IF NOT EXISTS `settings` (
  `DAYS` int(11) NOT NULL default '365',
  `MDAYS` int(11) NOT NULL default '365',
  `SWEAR` set('0','1') NOT NULL default '1',
  `NUM` int(11) NOT NULL default '35',
  `FILTER` set('0','1') NOT NULL default '1',
  `EMOTEON` set('0','1') NOT NULL default '1',
  `EMOTEPACK` varchar(255) NOT NULL default 'default',
  `DEFAULTIMAGE` longtext NOT NULL,
  `TURNONMAIL` set('0','1') NOT NULL default '1',
  `TURNONCAPTCHA` set('0','1') NOT NULL default '0',
  `UNAMEMIN` int(11) NOT NULL default '5',
  `UNAMEMAX` int(11) NOT NULL default '15'
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `settings` (`DAYS`, `MDAYS`, `SWEAR`, `NUM`, `FILTER`, `EMOTEON`, `EMOTEPACK`, `DEFAULTIMAGE`, `TURNONMAIL`, `TURNONCAPTCHA`, `UNAMEMIN`, `UNAMEMAX`) VALUES
(365, 425, '1', 30, '1', '1', 'smile', '/9j/4AAQSkZJRgABAgEAYABgAAD/4QpcRXhpZgAASUkqAAgAAAAHABIBAwABAAAAAQAAABoBBQAB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\r\n2Q==\r\n', '1', '0', 5, 15);
CREATE TABLE IF NOT EXISTS `states` (
  `ID` int(11) NOT NULL auto_increment,
  `US_STATES` varchar(25) NOT NULL default '',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=51 ;

--
-- Dumping data for table `states`
--

INSERT INTO `states` (`ID`, `US_STATES`) VALUES
(22, 'Michigan'),
(23, 'Minnesota'),
(24, 'Mississippi'),
(25, 'Missouri'),
(26, 'Montana'),
(27, 'Nebraska'),
(28, 'New Hampshire'),
(29, 'New Jersey'),
(30, 'New Mexico'),
(31, 'New York'),
(32, 'Nevada'),
(33, 'North Carolina'),
(34, 'North Dakota'),
(35, 'Ohio'),
(36, 'Oklahoma'),
(37, 'Oregon'),
(38, 'Pennsylvania'),
(20, 'Maryland'),
(19, 'Maine'),
(18, 'Louisiana'),
(17, 'Kentucky'),
(16, 'Kansas'),
(15, 'Iowa'),
(14, 'Indiana'),
(13, 'Illinois'),
(12, 'Idaho'),
(11, 'Hawaii'),
(10, 'Georgia'),
(9, 'Florida'),
(8, 'Delaware'),
(7, 'Connecticut'),
(6, 'Colorado'),
(5, 'California'),
(4, 'Arkansas'),
(3, 'Arizona'),
(2, 'Alabama'),
(1, 'Alaska'),
(21, 'Massachusettes'),
(39, 'Rhode Island'),
(40, 'South Carolina'),
(41, 'South Dakota'),
(42, 'Tennessee'),
(43, 'Texas'),
(44, 'Utah'),
(45, 'Vermont'),
(46, 'Virginia'),
(47, 'Washington'),
(48, 'West Virginia'),
(49, 'Wisconsin'),
(50, 'Wyoming');

CREATE TABLE IF NOT EXISTS `users` (
  `USERID` bigint(255) NOT NULL auto_increment,
  `LOGIN` varchar(54) NOT NULL default '',
  `FIRSTNAME` varchar(25) NOT NULL default '',
  `LASTNAME` varchar(25) NOT NULL default '',
  `EMAIL` varchar(150) NOT NULL default '',
  `ADDRESS` varchar(150) NOT NULL default '',
  `CITY` varchar(150) NOT NULL default '',
  `STATE` varchar(25) NOT NULL default '',
  `ZIPCODE` varchar(10) NOT NULL default '',
  `PHONE` varchar(25) NOT NULL default '',
  `SIGNUPDATE` date NOT NULL default '0000-00-00',
  `PASSWORD` text NOT NULL,
  `LASTLOGON` date NOT NULL default '0000-00-00',
  `ISADMIN` enum('Y','N') NOT NULL default 'N',
  `ANONID` varchar(25) NOT NULL default '',
  `BANNED` set('yes','no') NOT NULL default 'no',
  PRIMARY KEY  (`USERID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

CREATE TABLE IF NOT EXISTS `users_settings` (
  `ID` bigint(20) NOT NULL auto_increment,
  `USERID` bigint(30) NOT NULL,
  `MOBILENABLED` set('0','1') NOT NULL default '0',
  `MOBILE` varchar(10) NOT NULL,
  `EMAILENABLED` set('0','1') NOT NULL default '0',
  `EMAIL` varchar(150) NOT NULL,
  `STARTPAGE` varchar(25) NOT NULL default 'recent',
  `LANGUAGE` varchar(10) NOT NULL default 'en',
  PRIMARY KEY  (`ID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

CREATE TABLE IF NOT EXISTS `users_waiting` (
  `USERID` bigint(255) NOT NULL auto_increment,
  `LOGIN` varchar(54) NOT NULL default '',
  `LASTNAME` varchar(25) NOT NULL default '',
  `FIRSTNAME` varchar(25) NOT NULL default '',
  `EMAIL` varchar(150) NOT NULL default '',
  `STATE` varchar(21) NOT NULL default '',
  `DATE` date NOT NULL default '0000-00-00',
  `VERID` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`USERID`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

CREATE TABLE IF NOT EXISTS `wordfilter` (
  `BADWORD` varchar(255) NOT NULL,
  `GOODWORD` varchar(255) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

INSERT INTO `wordfilter` (`BADWORD`, `GOODWORD`) VALUES
('cock', 'penis'),
('cunt', 'vagina'),
('fucker', 'fudger'),
('fuck', 'fudge'),
('bastard', 'red headed step child'),
('bitch', 'witch'),
('fucking', 'fudging'),
('nigger', 'negro');