<?php

///////////////////////////////////////////////////
// 
// Groone's World Development: 
// ------------
// http://www.groonesworld.com
// @copyright Russell H. Bennett, Jr. <russ@groonesworld.com>
// @author Russell H. Bennett, Jr. <russ@groonesworld.com>
//
// Grooner:  The Micro Blogger
//
// Message Time Date Module Developed by hilflo
// http://www.breutaat.bzh.be/
// http://www.logicielsgratuits.org/
// 
// License GNU General Public License
///////////////////////////////////////////////////

if(!defined('MyConst')){die('Direct access not premitted');}

function Date_ConvertSqlTab($date_sql) {

    $jour = substr($date_sql, 8, 2);
    $mois = substr($date_sql, 5, 2);
    $annee = substr($date_sql, 0, 4);
    $heure = substr($date_sql, 11, 2);
    $minute = substr($date_sql, 14, 2);
    $seconde = substr($date_sql, 17, 2);
	
    
    $key = array('annee', 'mois', 'jour', 'heure', 'minute', 'seconde');
    $value = array($annee, $mois, $jour, $heure, $minute, $seconde);
    
    $tab_retour = array_combine($key, $value);
    
    return $tab_retour;
}

function AuPluriel($chiffre) {
    if(($chiffre>1) || ($chiffre=0)) {
        return 's';
    };
}

function TimeToJourJ($date_sql) {
    $tab_date = Date_ConvertSqlTab($date_sql);
    $mkt_jourj = mktime($tab_date['heure'],
                    $tab_date['minute'],
                    $tab_date['seconde'],
                    $tab_date['mois'],
                    $tab_date['jour'],
                    $tab_date['annee']);

    $mkt_now = time();
	
	$dateDiff = $mkt_now - $mkt_jourj;
	$fullDays    = floor($dateDiff/(60*60*24));
	$fullHours   = floor(($dateDiff-($fullDays*60*60*24))/(60*60));
	$fullMinutes = floor(($dateDiff-($fullDays*60*60*24)-($fullHours*60*60))/60);
	
	if($fullDays > 0){
		return '<strong>'.$fullDays.' day'.AuPluriel($fullDays).' ago</strong>.';
	}elseif($fullHours > 0){
		return '<strong>'.$fullHours.' hour'.AuPluriel($fullHours).' ago</strong>.';
	}elseif($fullMinutes >= 0){
		return '<strong>'.$fullMinutes.' minute'.AuPluriel($fullMinutes).' ago</strong>.';
	}
}	
?>
