CREATE TABLE IF NOT EXISTS `memb_adminsessions` (
  `session_id` varchar(255) NOT NULL,
  `session_date` datetime NOT NULL,
  PRIMARY KEY  (`session_id`)
) COMMENT='List of Membership v1.0 admin sessions';


CREATE TABLE IF NOT EXISTS `memb_config` (
  `config_name` varchar(255) NOT NULL,
  `config_value` text NOT NULL,
  PRIMARY KEY  (`config_name`)
) COMMENT='List of Membership v1.0 config values';


INSERT INTO `memb_config` (`config_name`, `config_value`) VALUES
('CF_CAPTHCA', 'TEXT'),
('CF_BACKGROUNDS', 'extras/background_1.png,extras/background_2.png,extras/background_3.png'),
('CF_FONTS', 'extras/COOPBLA.TTF,extras/TIMES.TTF'),
('CF_SIZE', '18'),
('CF_QUESTIONFILE', 'extras/questions.txt'),
('CF_E_REG', '1'),
('CF_USER_LIMIT', '0'),
('CF_E_VER', '1'),
('CF_E_DEL', '1'),
('CF_ENCDEC', 'klJM()*Ulkopi324p'),
('CF_LENGH', '5'),
('CF_ADMINNAME', 'admin'),
('CF_ADMINPASSWORD', 'admin2008'),
('CF_SITENAME', 'MemberShip'),
('CF_SITEEMAIL', 'support@sonimager.com'),
('CF_SANDBOX', '2'),
('CF_LOG_TYPE', '1'),
('CF_PAYPALID', 'itnnetwork@gmail.com'),
('CF_2COID', '107303'),
('CF_REGISTEREMAIL_S', 'Please verify your email @ $SITE_NAME'),
('CF_REGISTEREMAIL_B', '<b>Hello,</b></span><br /><br />\r\n<span align="justify"><b>Thank you for registering at $SITE_NAME.</b></span><br /><br />\r\n<span align="justify"><b>Your login password is: $PASS_WORD.</b></span><br /><br />\r\n/IFVERIFICATION/\r\n<span align="justify"><b>However, before you can start using your account, we need to confirm this email.</b></span><br /><br />\r\n<span align="justify"><b>Please visit this link to activate your account <a href="$ACT_LINK" target="_blank">$ACT_LINK</a></font></b></span><br /><br />\r\n/IFVERIFICATION/\r\n<span align="justify"><b>Thank you, </b></span>'),
('CF_FORGOTEMAIL_S', 'Please password @ $SITE_NAME'),
('CF_FORGOTEMAIL_B', '<b>Hello,</b></span><br /><br />\r\n<span align="justify"><b>Your login password is: $PASS_WORD.</b></span><br /><br />\r\n<span align="justify"><b>Thank you, </b></span>'),
('CF_CHANGEEMAIL_S', 'Please confirm email change @ $SITE_NAME'),
('CF_CHANGEEMAIL_B', '<b>Hello $USER_NAME,</b></span><br /><br />\r\n<span align="justify"><b>You requested that your account, currently using this email to be changed to: $NEW_EMAIL.</b></span><br /><br />\r\n<span align="justify"><b>To confirm such action, you need to click here: <a href="$ACT_LINK">$ACT_LINK</a>.</b></span><br /><br />\r\n<span align="justify"><b>Thank you, </b></span>'),
('CF_URLINC', 'http://localhost/ap/work/Membership/'),
('CF_SANDBOX2', '2');

CREATE TABLE IF NOT EXISTS `memb_customfds` (
  `field_id` bigint(20) NOT NULL auto_increment,
  `field_name` varchar(255) NOT NULL,
  `is_required` tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (`field_id`)
)  COMMENT='List of Membership v1.0 custom fields' ;

INSERT INTO `memb_customfds` (`field_id`, `field_name`, `is_required`) VALUES
(6, 'Gender', 1),
(5, 'Age', 0);

CREATE TABLE IF NOT EXISTS `memb_memberships` (
  `membership_id` bigint(20) NOT NULL auto_increment,
  `membership_title` varchar(255) NOT NULL,
  `membership_desc` text NOT NULL,
  `membership_file` varchar(255) NOT NULL,
  `membership_free` tinyint(1) NOT NULL default '1',
  `membership_public` tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (`membership_id`)
)  COMMENT='list of all memberships' ;


INSERT INTO `memb_memberships` (`membership_id`, `membership_title`, `membership_desc`, `membership_file`, `membership_free`, `membership_public`) VALUES
(1, 'Free', 'Free', '/kunden/homepages/28/d243998695/htdocs/Demos/Membership/extras/.free.fdaccess', 1, 1),
(2, 'Super', 'Access to all sections', '/kunden/homepages/28/d243998695/htdocs/Demos/Membership/extras/.super.fdaccess', 2, 1);


CREATE TABLE IF NOT EXISTS `memb_memberships_rates` (
  `rate_id` int(11) NOT NULL auto_increment,
  `membership_id` bigint(20) NOT NULL,
  `rate_title` varchar(255) NOT NULL,
  `rate_desc` text NOT NULL,
  `rate_amount` varchar(255) NOT NULL,
  `rate_term` bigint(255) NOT NULL,
  `rate_term_c` varchar(1) NOT NULL,
  `rate_automatic` tinyint(1) NOT NULL default '1',
  `2checkout_PID` varchar(255) NOT NULL,
  PRIMARY KEY  (`rate_id`)
)  COMMENT='List of all rates for memberships' ;


INSERT INTO `memb_memberships_rates` (`rate_id`, `membership_id`, `rate_title`, `rate_desc`, `rate_amount`, `rate_term`, `rate_term_c`, `rate_automatic`, `2checkout_PID`) VALUES
(1, 1, 'test', 'test', '33.00', 1, 'W', 1, '5'),
(3, 2, 'Test1', 'Unlimited', '99.99', 1, 'W', 1, '5');

CREATE TABLE IF NOT EXISTS `memb_payments` (
  `payment_id` bigint(20) NOT NULL auto_increment,
  `membership_id` bigint(20) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `rate_id` bigint(20) NOT NULL,
  `rate_amount` varchar(255) NOT NULL,
  `payment_date` datetime NOT NULL,
  `system_id` bigint(20) NOT NULL,
  PRIMARY KEY  (`payment_id`)
)  COMMENT='List of payments'  ;


INSERT INTO `memb_payments` (`payment_id`, `membership_id`, `user_id`, `rate_id`, `rate_amount`, `payment_date`, `system_id`) VALUES
(1, 2, 1, 3, '33', '2008-10-18 00:00:00', 1);


CREATE TABLE IF NOT EXISTS `memb_paysystem` (
  `system_id` bigint(20) NOT NULL auto_increment,
  `system_title` varchar(255) NOT NULL,
  `system_desc` text NOT NULL,
  PRIMARY KEY  (`system_id`)
)  COMMENT='List of all payment systems'  ;


INSERT INTO `memb_paysystem` (`system_id`, `system_title`, `system_desc`) VALUES
(1, 'Paypal', 'Paypal is a secure method of payment'),
(2, '2CheckOut', '2Checkout is a secure form of online payment');


CREATE TABLE IF NOT EXISTS `memb_userlist` (
  `user_id` bigint(20) NOT NULL auto_increment,
  `membership_id` bigint(20) NOT NULL,
  `user_email` varchar(255) NOT NULL,
  `user_name` varchar(255) NOT NULL,
  `user_password` varchar(255) NOT NULL,
  `user_status` varchar(50) NOT NULL,
  `register_date` datetime NOT NULL,
  `last_ip` varchar(255) NOT NULL,
  `last_access` datetime NOT NULL,
  `allow_delete` tinyint(1) NOT NULL,
  `user_in_list` tinyint(1) NOT NULL,
  `custom_fields` longtext NOT NULL,
  PRIMARY KEY  (`user_id`)
)  COMMENT='List of Membership v1.0 users' ;

INSERT INTO `memb_userlist` (`user_id`, `membership_id`, `user_email`, `user_name`, `user_password`, `user_status`, `register_date`, `last_ip`, `last_access`, `allow_delete`, `user_in_list`, `custom_fields`) VALUES
(5, 1, 'test@test.com', 'test', 'test', '1', '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', 1, 1, '[6]{+|%|+}[tt]\n[5]{+|%|+}[tt]\n'),
(1, 1, 'test@test.com', 'Test', 'test', '1', '0000-00-00 00:00:00', '', '0000-00-00 00:00:00', 1, 1, '[6]{+|%|+}[]\n[5]{+|%|+}[]\n');


CREATE TABLE IF NOT EXISTS `memb_usersessions` (
  `session_id` varchar(255) NOT NULL,
  `user_id` bigint(20) NOT NULL,
  `session_date` datetime NOT NULL,
  PRIMARY KEY  (`session_id`)
) COMMENT='List of Membership v1.0 user sessions';
