<?
/*
RSS Reader Class 1.1.1
Gregwiz RSS Reader is a simple RSS integration class
Author: Suppakit Taethaweesap http://www.gregwiz.com
License:     GPL
*/
class RssReader{
	var $xml_parser;
	var $rss_content;
	var $currentTag = '';
	var $currentAttribs = '';
	var $depth = 0;
	var $main;
	var $item_counter = 0;
	var $cache_dir = 'temp';
	var $item_num;

	function Rss_Reader ($file) {
		$this->xml_parser = xml_parser_create();
		xml_set_object($this->xml_parser, $this);
		xml_set_element_handler($this->xml_parser, startElement, endElement);
		xml_set_character_data_handler($this->xml_parser, characterData);
		if($this->cache_time > 0) {
			$usedcache = false;
			$cache_file = $this->cache_dir . '/rsscache_' . md5($file);
			if (file_exists($cache_file)) {
				$timedif = @(time() - filemtime($cache_file));
				if ($timedif < $this->cache_time) {
					// cached file is fresh enough, return cached array
					$file = $cache_file;
					$usedcache = true;
				} 
			}
		}
		if (!($fp = fopen($file, "r"))) {
			die("could not open XML input");
		}
		
		$read = '';
		while ($data = fread($fp, 4096)) {
			if (!xml_parse($this->xml_parser, $data, feof($fp))) {
				die(sprintf("XML error: %s at line %d",
							xml_error_string(xml_get_error_code($this->xml_parser)),
							xml_get_current_line_number($this->xml_parser)));
			}
			$read .= $data;
		}
		xml_parser_free($this->xml_parser);
		if($this->cache_time > 0) {
			if (!$usedcache) {
				if (file_exists($cache_file)) { unlink($cache_file);	}
				$f = @fopen($cache_file, 'w');
				fwrite ($f, $read);
				fclose($f);
			}
		}
		$i=1;
		echo '<UL>';
		foreach ($this->rss_content['items'] as $content) {
			echo '<LI><a href="'.$content['link'].'" target="_blank">'.$content['title'].'</a><BR>'.$content['description'].'</LI>';
			if($i == $this->item_num) { break; }
			$i++;
		}
		echo '</UL>';
	}


	function startElement($parser, $name, $attrs) {
		$name = strtolower($name);
		switch($name) {
   		case "rss":
   		case "rdf:rdf":
   		case "items":
   			$this->currentTag = "";
   			break;
   		case "channel":
   			$this->main = "channel";
   			break;
   		case "image":
   			$this->main = "image";
   			$this->rss_content["image"] = array();
   			break;
   		case "item":
   			$this->main = "items";
   			break;
   		default:
   			$this->currentTag = $name;
   			break;
   		}
	}

	function endElement($parser, $name) {
		$name = strtolower($name);
		$this->currentTag = "";
        if ($name == "item") {
   			$this->item_counter++;
   		}
	}

	function characterData($parser, $data) {
		if ($this->currentTag != "") {
			switch($this->main) {
				case "channel":
					if (isset($this->rss_content[$this->currentTag])) {
						$this->rss_content[$this->currentTag] .= $data;
					} else {
						$this->rss_content[$this->currentTag] = $data;
					}
					break;
				case "image":
					if (isset($this->rss_content[$this->main][$this->currentTag])) {
						$this->rss_content[$this->main][$this->currentTag] .= $data;
					} else {
						$this->rss_content[$this->main][$this->currentTag] = $data;
					}
					break;
				case "items":
					if (isset($this->rss_content[$this->main][$this->item_counter][$this->currentTag])) {
						$this->rss_content[$this->main][$this->item_counter][$this->currentTag] .= $data;
					} else {
						$this->rss_content[$this->main][$this->item_counter][$this->currentTag] = $data;
					}
					break;
			}
		}
	}
	
}
?>