<?php

/*
 * process_code.php
 * 
 * This file processes all forms for storage in Form Tools. It is also used to initially setup 
 * the form within the database, to map input fields to database columns & types.
 */

// --------------------------------------------------------------------------------------------- 

/*
 * Called by either direct posting to this page, or when a programmer requires() this in their page.
 * 
 * Assumption: - $hash['form_tools_form_id'] is included with the correct form ID value.
 *             - $files - an optional hash (usually $_FILES) of files being uploaded
 * @return integer the new submission_id (NOT returned when setting up form)
 */
function process_form($hash, $files = "")
{
  global $g_table_prefix, $g_multi_val_delimiter;

  // check we're receiving something
  if (empty($hash))
    ft_output_message("no_post_vars");
  
  // check there's a form ID included
  else if (empty($hash['form_tools_form_id']))
    ft_output_message("no_form_id");
  
  // is this an initialization submission?
  else if (isset($hash['form_tools_initialize_form']))
    ft_initialize_form($hash);

  // check we're receiving a form ID
  if (!isset($hash['form_tools_form_id']) || empty($hash['form_tools_form_id']) || !is_numeric($hash['form_tools_form_id']))
    ft_output_message("no_form_id");
  $form_id = $hash['form_tools_form_id'];

  $link = ft_db_connect();
  $form_info = ft_get_form($form_id);

  // check to see if this form has been disabled
  if ($form_info['is_active'] == "no")
    ft_output_message("form_disabled");

  $form_template = ft_get_form_template($form_id);
  $auto_email_admin = $form_info['auto_email_admin'];
  $auto_email_user  = $form_info['auto_email_user'];

  // do we have a form for this id?
  if (empty($form_info))
    ft_output_message("unrecognized_form_id");

  // -----------------------------------------------------------------------------------------------

  $valid_fields = array();
  while ($row = mysql_fetch_assoc($form_template))
    $valid_fields[$row["field_name"]] = array($row["col_name"], $row["include_on_redirect"], $row["field_title"], $row["field_id"]);

  ft_db_disconnect($link);

  // process the form values
  $query_col_names  = array();
  $query_col_values = array();
  $redirect_query   = array();

  while (list($key, $value) = each($hash))
  {
    // if this field is included, store the value for adding to DB, and build the query string for 
    // later submission (if required)
    if (array_key_exists("$key", $valid_fields))
    {
      $query_col_names[]  = $valid_fields[$key][0];
      if (is_array($value))
      {
        if ($form_info["submission_strip_tags"] == "yes")
        {
          for ($i=0; $i<count($value); $i++)
            $value[$i] = strip_tags($value[$i]);
        }

        $query_col_values[] = "'" . join("$g_multi_val_delimiter", $value) . "'";
      }
      else
      {
        if ($form_info["submission_strip_tags"] == "yes")
          $query_col_values[] = "'" . strip_tags($value) . "'";
        else
          $query_col_values[] = "'$value'";
      }
      
      if ($valid_fields[$key][1] == "yes")
        $redirect_query[] = "$key=$value";
    }
  } 

  $submission_date = ft_get_current_datetime();
  $ip_address      = $_SERVER['REMOTE_ADDR'];

  $col_names  = join(",", $query_col_names);
  $col_values = join(",", $query_col_values);
  
  // if this is a code submission and the administrator has marked submissions to not be finalized, 
  // set the is_complete field to "no"
  $is_finalized = "yes";
  if ($form_info['finalized_submissions'] == "no")
    $is_finalized = "no";

  // build our query
  $query = "
    INSERT INTO {$g_table_prefix}form_$form_id ($col_names, submission_date, ip_address, is_finalized)
    VALUES ($col_values, '$submission_date', '$ip_address', '$is_finalized')
           ";

  // add the submission to the database
  $link = ft_db_connect();
  mysql_query($query)
    or ft_output_message("submission_not_added");
  $submission_id = mysql_insert_id();
  ft_db_disconnect($link);


  // now the submission exists in the database, upload any files that were included
  while (list($key, $fileinfo) = each($files))
  {
    if (empty($fileinfo['name']))
      continue;

    if (array_key_exists("$key", $valid_fields))
      ft_upload_file($form_id, $submission_id, $valid_fields[$key][3], $fileinfo);
  }

  
  // if required, send the emails to adminstrator(s) and/or the user
  if ($auto_email_admin == "yes")
    ft_send_email("admin", $form_id, $submission_id);
  if ($auto_email_user == "yes")
    ft_send_email("user", $form_id, $submission_id);


  return $submission_id; 
}


/*
 * called by test form submission, during form setup procedure. This stores a complete form 
 * submission in the database for examination and pruning by the administrator.
 */
function ft_initialize_form($hash)
{
  global $g_table_prefix, $g_multi_val_delimiter;

  $form_id = $hash['form_tools_form_id'];
  $form_info = ft_get_form($form_id);

  // if this form has already been completed, exit with an error message
  if ($form_info['is_complete'] == "yes")
    ft_output_message("form_already_finalized");
    

  $link = ft_db_connect();
  
  // since this form is still incomplete, remove any old records from 
  // form_templates concerning this form
  $query = "DELETE FROM {$g_table_prefix}form_templates WHERE form_id = '$form_id'";
  $result = mysql_query($query);


  // now loop through each form value and store the name and values in form_templates
  $hash = ft_clean_hash($hash);

  // remove irrelevant key-values
  unset($hash['form_tools_initialize_form']);
  unset($hash['form_tools_form_id']);
  
  $order = 1;

  // add the submission ID system field
  $query = mysql_query("
		  INSERT INTO {$g_table_prefix}form_templates 
		         (form_id, field_name, field_test_value, field_type, field_title, data_type, col_name,
		          list_order, admin_display, is_sortable)
		  VALUES ('$form_id', 'Submission ID', '', 'system', 'Submission ID', 'number', 'submission_id', 
		          '$order', 'no', 'yes')
    ") or die(__FUNCTION__ . ", failed query: " . mysql_error());
  $order++;

  while (list($key, $value) = each($hash))
  {
    // if the key is "ft" and a corresponding key exists in sessions, we're going to assume that the 
    // user was using PHP Sessions to store and pass along the form values. Ignore everything in the 
    // "ft" key. This is used for Form Tools sessions content only
    if ($key == "ft" && isset($_SESSION["ft"]))
      continue;

    // if the value is an array, it's either a checkbox field or a multi-select field. Just 
    // comma-separate them
    if (is_array($value))
      $value = join("$g_multi_val_delimiter", $value);

    $query = "
      INSERT INTO {$g_table_prefix}form_templates (form_id, field_name, field_test_value, data_type, list_order)
      VALUES ('$form_id', '$key', '$value', 'string', '$order')
                ";

    $result = mysql_query($query);
    if (!$result)
      ft_output_message("submission_not_added");

    $order++;
  }
 
  // now see if any files were uploaded, too. ** don't actually upload the file, just create a 
  // spot for it in the database. The user will have to configure the field settings later
  while (list($key, $fileinfo) = each($_FILES))
  {
    mysql_query("
      INSERT INTO {$g_table_prefix}form_templates (form_id, field_name, field_test_value, data_type, list_order)
      VALUES ('$form_id', '$key', '[FILE]', 'string', '$order')
                ")
      or die (__FUNCTION__ . ", failed query: $query");

    $order++;
  }
 
  // add the submission date and IP address system fields
  $query = mysql_query("
		  INSERT INTO {$g_table_prefix}form_templates 
		         (form_id, field_name, field_test_value, field_type, field_title, data_type, col_name,
		          list_order, admin_display, is_sortable)
		  VALUES ('$form_id', 'Date', '', 'system', 'Date', 'date', 'submission_date', '$order', 'yes', 'yes')
    ") or die(__FUNCTION__ . ", failed query: " . mysql_error());
  $order++;
  $query = mysql_query("
		  INSERT INTO {$g_table_prefix}form_templates 
		         (form_id, field_name, field_test_value, field_type, field_title, data_type, col_name,
		          list_order, admin_display, is_sortable)
		  VALUES ('$form_id', 'IP Address', '', 'system', 'IP Address', 'number', 'ip_address', '$order', 'no', 'yes')
    ") or die(__FUNCTION__ . ", failed query: " . mysql_error());


  // finally, set this form's "is_initialized" value to "yes", so the administrator can proceed to 
  // the next step of the Add Form process.
  mysql_query("
      UPDATE  {$g_table_prefix}forms
      SET     is_initialized = 'yes'
      WHERE   form_id = $form_id
              ");

  ft_db_disconnect($link);
 
  // alert a "test submission complete message."
  ft_output_message("form_init_complete"); 
}


/*
 * Helper function to display any errors/notifications.
 */
function ft_output_message($flag)
{
	global $g_root_url, $LANG;

  switch ($flag)
  {
    case "no_post_vars":
      $message = $LANG["processing_no_post_vars"]; 
      $message_type = "error";
      break;

    case "no_form_id":
      $message = $LANG["processing_no_form_id"]; 
      $message_type = "error";
      break;

    case "form_already_finalized":
      $message = $LANG["processing_already_finalized"];
      $message_type = "error";
      break;

    case "form_init_complete": 
      $message = $LANG["processing_init_complete"];
      $message_type = "notify";
      break;

    case "cannot_be_processed":
      $message = $LANG["processing_cannot_be_processed"];
      $message_type = "error";
      break;

    case "form_disabled":
      $message = $LANG["processing_form_disabled"];
      $message_type = "notification";
      break;

    case "form_incomplete":
      $message = $LANG["processing_form_incomplete"];
      $message_type = "error";
      break;
      
    case "submission_not_added":
      $message = $LANG["processing_submission_not_added"]; 
      $message_type = "error";
      break;
  }

  $message_type_str = "";
  if ($message_type == "error") 
    $message_type_str = "<span class='red'>{$LANG["word_error"]}</span>";
  else
    $message_type_str = "<span class='blue'>{$LANG["word_notification"]}</span>";
  
  // output message
  echo <<<END_HEREDOC
<html>
<head>
  <title>{$LANG["special_form_tools_c"]} {$LANG["phrase_form_configuration"]}</title>
<style>
body,table { font-family: verdana; font-size: 10pt; }
.green_text { color: green; }
.red { color: #cc0000; }
.blue { color: #336699; }
.bold { font-weight: bold; }
#main { position: relative; }
</style>
</head>
<body bgcolor='white'>

<table cellpadding="0" cellspacing="0" id="body" align="center" width="700">
<tr>
  <td>

		<div id="main">
		  <div style="position: absolute; left: 60px; top: 14px; font-weight: bold">{$LANG["special_form_tools_c"]} $message_type_str</div>
		  <img src="$g_root_url/images/form_tools_small_icon.jpg" border="0" width="40" height="40" />
		 
		  <hr size="1" />
		
		  <p>$message</p>
		
		</div>

  </td>
</tr>
</table>

</body>
</html>
END_HEREDOC;

  exit;
}

?>
