<?php 
session_start();
header("Cache-control: private");
header("Content-Type: text/html; charset=utf-8");
require_once("_main.php");

require_once("global/templates/client_page_open.php");
?>
  
  <table cellpadding="0" cellspacing="0" height="35">
  <tr>
    <td width="45"><img src="images/icon_forms.jpg" /></td>
    <td class="title"><?php echo $LANG["word_forms_uc"]?></td>
  </tr>
  </table>

  <p class="common_width">
    <?php echo $LANG["text_client_welcome"]?>
  </p>

  <?php
  if (count($form_list) > 0)
  {
    $display_settings = false;
    // if there's at least one option to show on the settings page, display the settings page link
    if ($_SESSION["ft"]["may_take_forms_offline"] == "yes" || $_SESSION["ft"]["may_change_email_settings"] == "yes" ||
        $_SESSION["ft"]["may_change_num_submissions"] == "yes" || $_SESSION["ft"]["may_change_default_printer_friendly_format"] == "yes" || 
        $_SESSION["ft"]["may_change_default_hide_empty_fields"] == "yes")
      $display_settings = true;
    
    echo "<table class='list_table' cellpadding='1' cellspacing='1'>
          <tr style='height: 20px;'>
            <th>{$LANG['word_form']}</th>
            <th width='80'>{$LANG['word_status']}</th>
            <th width='80'>{$LANG['word_submissions_uc']}</th>";

    if ($display_settings)
      echo "<th width='80'>{$LANG['word_settings_uc']}</th>\n";

    echo "</tr>";
    
    for ($i=0; $i<count($form_list); $i++)
    {
      $form    = $form_list[$i][0];
      $form_id = $form["form_id"];
      
      // determine the form status
      $status  = "<span class='form_status_online'>{$LANG['word_online']}</span>";
      if ($form['is_active'] == "no")
        $status = "<span class='form_status_offline'>{$LANG['word_offline']}</span>";

      echo "<tr style='height: 20px;'>
              <td><a href='#' onclick='javascript:window.open(\"{$form['form_url']}\", \"\", \"height=400, width=600, scrollbars=yes, resizable=yes\")'>{$form['form_name']}</a></td>
              <td align='center'>$status</td>
              <td align='center'>";
  
      if ($form['is_complete'] == "yes")
        echo "(" . $_SESSION["ft"]["form_{$form_id}_num_submissions"] . ")&nbsp;<a href='forms/index.php?form_id=$form_id'>{$LANG['word_view_uc']}</a>";
  
      echo "</td>\n";
      
      if ($display_settings)
        echo "<td align='center'><a href='forms/settings.php?form_id={$form['form_id']}'>{$LANG['word_settings_uc']}</a></td>\n";
      
      echo "</tr>\n";
    }
    echo "</table>";
  }
  else
  {
    echo "<b>{$LANG["text_client_no_forms"]}</b>";
  }
  ?>

<?php require_once("global/templates/footer.php"); ?>