<?php

$g_sql = array();

// "form_templates" table
$g_sql[] = "
CREATE TABLE `%PREFIX%form_templates` (
  `field_id` mediumint(8) unsigned NOT NULL auto_increment,
  `form_id` mediumint(8) unsigned NOT NULL default '0',
  `field_name` varchar(255) NOT NULL default '',
  `field_test_value` blob,
  `field_size` enum('tiny','small','medium','large','very_large') default 'small',
  `field_type` enum('select','multi-select','radio-buttons','checkboxes','file','other','system') NOT NULL default 'other',
  `data_type` enum('string', 'number', 'date') NOT NULL default 'string',
  `field_title` varchar(100) default NULL,
  `col_name` varchar(100) default NULL,
  `list_order` smallint(5) unsigned default NULL,
  `admin_display` enum('yes','no') default 'no',
  `is_sortable` enum('yes','no') NOT NULL default 'yes',
  `include_on_redirect` enum('yes','no') NOT NULL default 'no',
  `option_orientation` enum('vertical','horizontal') NOT NULL default 'vertical',
  `file_upload_dir` VARCHAR(255) default NULL,
  `file_upload_url` VARCHAR(255) default NULL,
  `file_upload_max_size` VARCHAR(10) default '1000000',
  `file_upload_types` VARCHAR(255) default NULL,
  PRIMARY KEY  (`field_id`)
) TYPE=INNODB AUTO_INCREMENT=1 %CHARSET%
	  	 ";

// "forms" table
$g_sql[] = "
CREATE TABLE `%PREFIX%forms` (
  `form_id` mediumint(9) unsigned NOT NULL auto_increment,
  `form_type` enum('direct','code') NOT NULL default 'direct',
  `date_created` datetime NOT NULL,
  `is_active` enum('yes','no') NOT NULL default 'no',
  `is_initialized` enum('yes','no') NOT NULL default 'no',
  `is_complete` enum('yes','no') NOT NULL default 'no',
  `form_name` varchar(255) NOT NULL default '',
  `form_url` varchar(255) NOT NULL default '',
  `redirect_url` varchar(255) default NULL,
  `finalized_submissions` enum('yes','no') NOT NULL default 'yes',
  `auto_email_admin` enum('yes','no') default 'no',
  `auto_email_user` enum('yes','no') NOT NULL default 'no',
  `user_email_field` varchar(255) default NULL,
  `user_first_name_field` varchar(255) default NULL,
  `user_last_name_field` varchar(255) default NULL,
  `admin_email_subject` varchar(200) default '%FORMNAME%: Submission',
  `admin_email_from` enum('admin_email','users_name','custom') default NULL,
  `admin_email_from_custom` varchar(100) default NULL,
  `admin_email_reply_to` enum('admin_email','users_name','custom','none') default NULL,
  `admin_email_reply_to_custom` varchar(100) default NULL,
  `user_email_subject` varchar(200) default '%FORMNAME%: Submission',
  `user_email_from` enum('admin_email','users_name','custom') default NULL,
  `user_email_from_custom` varchar(100) default NULL,
  `user_email_reply_to` enum('admin_email','users_name','custom','none') default NULL,
  `user_email_reply_to_custom` varchar(100) default NULL,
  `include_admin_email` enum('yes','no') NOT NULL default 'no',
  `email_format` enum('text','html','both') NOT NULL default 'both',
  `admin_text_email_template` mediumtext,
  `admin_html_email_template` mediumtext,
  `user_text_email_template` mediumtext,
  `user_html_email_template` mediumtext,
  `num_submissions_per_page` smallint(6) NOT NULL default '0',
  `default_sort_field` varchar(255) default 'submission_date',
  `default_sort_field_order` enum('asc','desc') NOT NULL default 'desc',
  `printer_friendly_format` enum('table','one_per_page','one_by_one') NOT NULL default 'table',
  `hide_printer_friendly_empty_fields` enum('yes','no') NOT NULL default 'no',
  `auto_delete_submission_files` ENUM('yes', 'no') DEFAULT 'yes' NOT NULL,
  `show_ip_address` enum('yes','no') NOT NULL DEFAULT 'no',
  `submission_strip_tags` enum('yes', 'no') NOT NULL DEFAULT 'yes',
  PRIMARY KEY  (`form_id`)
) TYPE=INNODB AUTO_INCREMENT=1 %CHARSET%
	  	 ";

// "field_options" table
$g_sql[] = "
  CREATE TABLE `%PREFIX%field_options` (
    `option_id` mediumint(9) NOT NULL auto_increment,
    `field_id` mediumint(8) unsigned NOT NULL,
    `option_value` varchar(255) NOT NULL,
    `option_name` varchar(255) NOT NULL,
    `option_order` smallint(6) NOT NULL,
    PRIMARY KEY  (`option_id`)
  ) TYPE=INNODB AUTO_INCREMENT=1 %CHARSET%
            ";

// "settings" table
$g_sql[] = "
CREATE TABLE `%PREFIX%settings` (
  `setting_id` mediumint(9) NOT NULL auto_increment,
  `setting_name` varchar(50) NOT NULL default '',
  `setting_value` text NOT NULL,
  PRIMARY KEY  (`setting_id`)
) TYPE=INNODB AUTO_INCREMENT=1 %CHARSET%
	  	 ";

// "user_accounts" table
$g_sql[] = "
CREATE TABLE `%PREFIX%user_accounts` (
  `user_id` mediumint(8) unsigned NOT NULL auto_increment,
  `account_type` enum('admin','client') NOT NULL default 'client',
  `active` enum('yes','no') NOT NULL default 'no',
  `ui_language` varchar(50) NOT NULL default 'en_us',
  `first_name` varchar(100) default NULL,
  `last_name` varchar(100) default NULL,
  `email` varchar(200) default NULL,
  `username` varchar(50) default NULL,
  `password` varchar(50) default NULL,
  `company` varchar(255) default NULL,
  `page_titles` varchar(255) default NULL,
  `footer_text` varchar(255) default NULL,
  `logo` varchar(255) default NULL,
  `css` text,
  `may_delete_submissions` ENUM('yes','no') NOT NULL DEFAULT 'yes',
  `may_edit_submissions` ENUM('yes','no') NOT NULL DEFAULT 'yes',
  `may_download_excel` ENUM('yes','no') NOT NULL DEFAULT 'yes',
  `may_view_printer_friendly_page` ENUM('yes','no') NOT NULL DEFAULT 'yes',
  `include_have_a_question_page` ENUM('yes','no') NOT NULL DEFAULT 'yes',
  `may_take_forms_offline` ENUM('yes', 'no') NOT NULL DEFAULT 'no',
  `may_change_email_settings` ENUM('yes', 'no') NOT NULL DEFAULT 'no',
	`may_change_num_submissions` ENUM('yes', 'no') NOT NULL DEFAULT 'no',
	`may_change_default_printer_friendly_format` ENUM('yes', 'no') NOT NULL DEFAULT 'no',
	`may_change_default_hide_empty_fields` ENUM('yes', 'no') NOT NULL DEFAULT 'no',
  PRIMARY KEY  (`user_id`)
) TYPE=INNODB AUTO_INCREMENT=1 %CHARSET%
	  	 ";

// "client_forms" table
$g_sql[] = "
CREATE TABLE `%PREFIX%client_forms` (
  `user_id` MEDIUMINT UNSIGNED NOT NULL,
  `form_id` MEDIUMINT UNSIGNED NOT NULL,
  PRIMARY KEY (`user_id`, `form_id`)
) TYPE=INNODB %CHARSET%
       ";

// "client_filters" table
$g_sql[] = "
CREATE TABLE `%PREFIX%client_filters` (
  filter_id mediumint(8) unsigned NOT NULL auto_increment,
  user_id mediumint(8) unsigned NOT NULL,
  form_id mediumint(8) unsigned NOT NULL,
  field_id mediumint(8) unsigned NOT NULL,
  operator enum('equals','not_equals','like','before','after') NOT NULL default 'equals',
  filter_values mediumtext NOT NULL,
  filter_sql mediumtext NOT NULL,
  PRIMARY KEY  (filter_id)
) TYPE=InnoDB AUTO_INCREMENT=1 %CHARSET%
       ";


// add default values for "settings" table
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'program_version', '1.5.1')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'is_beta', 'no')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'beta_version', '')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'default_language', 'en_us')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'available_languages', 'en_us,English (US)')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'num_clients_per_page', '10')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'num_forms_per_page', '10')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'default_css', '/* GENERAL STYLES */\r\np, td, tr, table, div, input, select, textarea { font-family: arial; font-size: 8pt; color: black; }\r\nbody { color: #ffffff; margin: 0px; }\r\na:link, a:visited { color: #336699; }\r\n\r\n/* NAV LINKS */\r\n.nav_link { width: 150px; }\r\n.nav_link a { width: 100%; display: block; padding: 6px; }\r\n.nav_link a:hover { color: black; }\r\n.nav_link_selected { padding: 6px; font-weight: bold; }\r\n\r\n/* PAGE SECTIONS */\r\n.top_banner { background-color: #cccccc; }\r\n.top_row_left { background-color: #000000; height: 18px; }\r\n.top_row_right { background-color: #333333; }\r\n.left_column { background-color: #efefef; }\r\n.footer { background-color: #efefef; height: 30px; text-align: center;}\r\n\r\n.title { font-family: arial; letter-spacing: 4px; font-size: 8pt; color: #336699; padding-bottom: 5px; font-weight: bold; }\r\n.form_status_online { color: green; }\r\n.form_status_offline { color: red; }\r\n\r\n/* TABLES */\r\n.list_table { border: 1px solid #cccccc; width: 600px; }\r\n.list_table th { background-color: #336699; color: white; }\r\n.list_table th a, .list_table th a:visited { color: white; text-decoration: none; }\r\n.list_table tr { background-color: #efefef; }\r\n.list_table_th_edit { background-color: #dddddd; }\r\n.list_table_td_edit { background-color: #dddddd; }\r\n\r\n/* MESSAGES */\r\n.notify { border: 1px solid #336699; background-color: #ffffee; color: #336699; padding: 8px; width: 400px; }\r\n.error { border: 1px solid #cc0000; background-color: #ffffee; color: #cc0000; padding: 8px; width: 400px; }\r\n\r\n/* PRINT PREVIEW PAGE */\r\n.print_title { font-family: arial; font-size: 14px; font-weight: bold; }\r\n.print_table { border: 1px solid #dddddd; }\r\n.print_table th { border: 1px solid #cccccc; background-color: #efefef; }\r\n.print_table td { border: 1px solid #cccccc; }\r\n.print_th { text-align: left; }\r\n\r\n/* LOGIN / FORGET PWD PAGES */\r\n.login_outer_table { border: 1px solid #999999; }\r\n.login_inner_table { background-color: #999999; }\r\n.login_table_text { color: #ffffcc; padding-left: 10px; padding-right: 10px; }\r\n.login_error { background-color: #efefef; }\r\n\r\n/* MISC */\r\n.common_width { width: 600px; }\r\n.page_break { page-break-after: always; }\r\n.submission_id { color: #666666; }\r\ntr.selected_row_color { background-color: #dbecfe; }\r\ntr.unselected_row_color { background-color: #efefef; }\n.light_grey { color: #999999; }\n.red { color: #cc0000; }')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'default_num_submissions_per_page', '10')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'program_name', 'Form Tools')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'footer_text', 'Form Tools')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'logout_url', '%LOGOUTURL%')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'timezone_offset', '0')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'date_format', 'M jS, g:i A')";
$g_sql[] = "INSERT INTO `%PREFIX%settings` VALUES (NULL, 'emailing_method', 'basic')";

?>
