<?php

/*
 * Step 2.
 * This page does the bulk of the work of the installation. It ensures the config.php file is
 * created before proceeding.
 *
 * 1. If the config.php file already exists - AND it has non-empty values for the DB settings -
 * it redirects to step 3.
 * 2. If the config file DOESN'T exist, it provides fields for the user to fill in the database
 * settings. When they click "Generate", it attempts to generate the file automatically for
 * them. Chances are it will fail since the permissions on the /global folder aren't 777, in
 * which case it displays a page showing the content for them to manually create the file.
 */

require("../global/library.php");
require("files/sql.php");


// This variable is used to determine what to show in the page. Values:
// 1. NEW form
// 2. posted with error
// 3. posted with success, now need to create config.php file
// 4. called after the user
$page = 1;

$success = false;
$message = "";
$no_config_settings = false;

$_SESSION['g_db_hostname'] = ft_load_field("g_db_hostname", "g_db_hostname");
$_SESSION['g_db_name'] = ft_load_field("g_db_name", "g_db_name");
$_SESSION['g_db_username'] = ft_load_field("g_db_username", "g_db_username");
$_SESSION['g_db_password'] = ft_load_field("g_db_password", "g_db_password");
$_SESSION['g_table_prefix'] = ft_load_field("g_table_prefix", "g_table_prefix", "ft_");
$_SESSION['g_unicode'] = ft_load_field("g_unicode", "g_unicode");


if (isset($_POST['generate']))
{
	// if g_unicode doens't exist in POST, they haven't checked it. Delete it from sessions.
  if (!isset($_POST['g_unicode']))
    unset($_SESSION['g_unicode']);

  list($success, $message) = generate_config_file();

  if ($success)
  {
    // if the config.php file was actually updated, add the DB tables
  	if ($message == "file_created")
  	{
  		list($success, $message) = add_tables($_SESSION['g_unicode'], $_SESSION['g_table_prefix']);

      // great! The tables were correctly added. Just redirect to the next page
      if ($success)
	 	  {
        header("Location: step3.php");
	 	    exit;
      }

      // something went wrong adding the table. Display whatever error occurred (stored in $message)
      $page = 2;
  	}
  	else
  	{
  		$_SESSION["config_file"] = $message;
  		$page = 3;
  	}

  }
	else
	  $page = 2;
}

// if the config file is populated, redirect to the next page
else if (isset($_POST['check_config_contents']))
{
  $error_creating_tables = false;
  if (empty($g_db_hostname) || empty($g_db_username) || empty($g_db_password) || empty($g_db_name))
	  $no_config_settings = true;
	else
	{
    list ($success, $message) = check_config_file_exists();

    if ($success)
    {
  		list($success, $message) = add_tables($g_unicode, $g_table_prefix);

      // great! The tables were correctly added. Just redirect to the next page
      if ($success)
	 	  {
        header("Location: step3.php");
	 	    exit;
      }

      // something went wrong adding the table. Display whatever error occurred (stored in $message)
      $error_creating_tables = true;
    }
	}

  if ($error_creating_tables)
	  $page = 2;
  else
  	$page = 3;
}

/**
 * This function (a) checks the fields have been entered, (b) tries connecting to the database host and
 * database, (c) tries to update the contents of the config.php file and, failing that, returns the content
 * of the file.
 *
 * @return array Returns an array with two indexes: [0] true/false, depending on whether the
 *               operation was a success. [1] error message / "file_created" / PHP content of the config
 *               file. If it failed, this index is the specific error message string. If it succeeded,
 *               it returns either the string "file_created" to indicate the config.php file was
 *               successfully created or the PHP content of the file.
 */
function generate_config_file()
{
  // 1. check all the fields have been entered
  if (empty($_SESSION['g_db_hostname']) || empty($_SESSION['g_db_username']) || empty($_SESSION['g_db_password']) || empty($_SESSION['g_db_name']))
  	return array(false, "Please fill in all fields.");

  // 2. check to see if the MySQL info the user supplied is valid
  $db_connection_error = "";
  $db_select_error = "";
  $link = @mysql_connect($_SESSION['g_db_hostname'], $_SESSION['g_db_username'], $_SESSION['g_db_password'])
    or $db_connection_error = mysql_error();

  if ($db_connection_error)
  {
  	return array(false, "Sorry, we were unable to connect to the database using the information "
  	   . "you supplied. The error message the database returned is: <i>$db_connection_error</i>");
  }
  else
  {
    @mysql_select_db($_SESSION['g_db_name'])
      or $db_select_error = mysql_error();

    if ($db_select_error)
    {
   	  return array(false, "Please check your database name and login information. Although we were "
   	    . "able to connect to the database host, we could not connect to the database. The error "
   	    . "message the database returned is: <i>$db_select_error</i>");
    }
    else
    {
      // close the connection
      @mysql_close($link);
    }
  }

  // 3. create the config file contents
  $root_url = preg_replace("/\/install\/step2\.php$/", "", "http://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}");
  $root_dir = preg_replace("/.install$/", "", dirname(__FILE__));
  $root_dir = addslashes($root_dir);

  $content = "<" . "?php\n\n"
           . "// main program paths - no trailing slashes\n"
           . "\$g_root_url = \"$root_url\";\n"
           . "\$g_root_dir = \"$root_dir\";\n\n"
           . "// database settings\n"
           . "\$g_db_hostname = \"{$_SESSION['g_db_hostname']}\";\n"
           . "\$g_db_name     = \"{$_SESSION['g_db_name']}\";\n"
           . "\$g_db_username = \"{$_SESSION['g_db_username']}\";\n"
           . "\$g_db_password = \"{$_SESSION['g_db_password']}\";\n";

  if (!empty($_SESSION['g_table_prefix']))
  	$content .= "\$g_table_prefix = \"{$_SESSION['g_table_prefix']}\";\n";

  if (!empty($_SESSION['g_unicode']))
  	$content .= "\$g_unicode     = true;\n";

  $content .= "\n?" . ">";

  // we store g_root_url in sessions, since it's needed in add_tables() as the default Logout URL value
	$_SESSION["g_root_url"] = $root_url;

  // try and write to the config.php file directly. This will probably fail, but in the off-chance
  // the permissions are set, it saves the user the hassle of manually creating the file
  $config_file = "$root_dir/global/config.php";
  $handle = @fopen($config_file, "w");
  if ($handle)
  {
    fwrite($handle, $content);
    fclose($handle);

    return array(true, "file_created");
  }

  // no such luck! Although we were able to generate the content, we couldn't create the actual
  // file on the server
  return array(true, $content);
}


/**
 * This function actually creates the database tables.
 * @return array Returns an array with two indexes: [0] true/false, depending on whether the
 *               operation was a success. [1] error message / empty string if success.
 * @param $g_unicode
 * @param $g_table_prefix
 */
function add_tables($g_unicode, $g_table_prefix)
{
	global $g_sql;

  // explicitly register the database settings as globals, just in case they weren't set
  $GLOBALS["g_db_hostname"]  = $_SESSION["g_db_hostname"];
  $GLOBALS["g_db_name"]      = $_SESSION["g_db_name"];
  $GLOBALS["g_db_username"]  = $_SESSION["g_db_username"];
  $GLOBALS["g_db_password"]  = $_SESSION["g_db_password"];
  $GLOBALS["g_unicode"]      = $g_unicode;
  $GLOBALS["g_table_prefix"] = $g_table_prefix;


	// if required, add the tables
  $link = ft_db_connect();

  // if the user requires unicode, create the tables with the utf8 character set. Use default
  // character set by default
  $charset    = ($g_unicode) ? "CHARACTER SET utf8" : "";
  $logout_url = $_SESSION["g_root_url"];

  $errors = array();
  foreach ($g_sql as $query)
  {
    $query = preg_replace("/%PREFIX%/", $g_table_prefix, $query);
    $query = preg_replace("/%CHARSET%/", $charset, $query);
    $query = preg_replace("/%LOGOUTURL%/", $logout_url, $query);

    // execute the queries and keep track of any errors that occur
    $result = mysql_query($query)
      or $errors[] = mysql_error();

    if (!$result)
      break;
  }

  ft_db_disconnect($link);

  $success = true;
  $message = "";

  if (!empty($errors))
  {
    $success = false;
    array_walk($errors, create_function('&$el','$el = "&bull;&nbsp; " . $el;'));
    $message = join("<br />", $errors);
  }

  // if there was an error, return the error message
  return array($success, $message);
}


/**
 * basic test to find out if the database has been set up (namely: includes the user_account,
 * settings, forms and form_templates tables). Returns true/false.
 */
function database_is_setup()
{
  global $g_db_name, $g_table_prefix, $g_sql;

  $is_setup = false;

	$link = ft_db_connect();
	$g_sql = mysql_query("SHOW TABLES FROM $g_db_name");

	$table_names = array();
	while ($table_info = mysql_fetch_array($sql, MYSQL_NUM))
	  $table_names[] = $table_info[0];

	if (in_array("{$g_table_prefix}settings", $table_names) && in_array("{$g_table_prefix}forms", $table_names) &&
	    in_array("{$g_table_prefix}form_templates", $table_names) && in_array("{$g_table_prefix}user_accounts", $table_names))
	  $is_setup = true;

	ft_db_disconnect($link);

	return $is_setup;
}


/**
 * basic test to find out if the database has been set up (namely: includes the user_account,
 * settings, forms and form_templates tables). Returns true/false.
 */
function check_config_file_exists()
{
  if (is_file("../global/config.php"))
    return array(true, "");
  else
    return array(false, "The config.php file does not exist. You need to create it in your /global folder with the content specified in order to continue.");
}


?>