<?php

/*
  This page is called in every administration page to generate the start of each the HTML pages, from the 
  opening DOCTYPE to the head, and the opening structure of the pages. This was added in 1.5.0 to 
  reduce the amount of duplicate HTML. Available variables:

  $g_head_title   - the title of the page
  $g_head_js      - anything that will be included within <script></script> tags.
  $g_head_css     - any CSS to be included within <style> tags.
  $g_body_onload  - the body onload handler
  $g_nav_page     - the current page, used for the navigation column on the left
  
  $g_head_string  - anything else to be outputted as is within the <head></head>
*/

if (ini_get('register_globals'))
{
  $to_remove = array("g_head_string", "g_head_css", "g_root_dir", "g_root_url", "g_body_onload");
	
  $rg = array_keys($_REQUEST);
  foreach ($rg as $var)
  {
    if ($_REQUEST[$var] === $$var && in_array($var, $to_remove))
      unset($$var);
  }
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html dir="<?php echo $LANG['special_text_direction']?>">
<head>
	<title><?php echo $g_head_title?></title>	
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />

  <link type="text/css" rel="stylesheet" href="<?php echo $g_root_url?>/global/admin_styles.css">
  <script type="text/javascript" src="<?php echo $g_root_url?>/global/scripts/prototype.js"></script>
  <script type="text/javascript" src="<?php echo $g_root_url?>/global/scripts/general.js"></script>
  <script type="text/javascript" src="<?php echo $g_root_url?>/global/scripts/validation.js"></script>

  <?php
  // include anything else that's been included
  if (isset($g_head_string))
    echo $g_head_string;

  // include any defined javascript
  if (isset($g_head_js))
  {
    echo "<script type='text/javascript'>
          $g_head_js
          </script>";
  }

  // include any defined CSS
  if (isset($g_head_css))
  {
    echo "<style type='text/css'>
          $g_head_css
          </style>";
  }
  ?>

</head>
<body<?php if (isset($g_body_onload)) echo " onload=\"$g_body_onload\""; ?>>

<table width='100%' height="100%" border='0' cellpadding='0' cellspacing='0'>
<tr>
  <td width='200' height="60" valign='center' align='center'><img src="../../images/logos/logo_1.gif" width="200" height="60" /></td>
  <td class="top_banner"> </td>
</tr>
<tr>
  <td class="top_row_left"> </td>
  <td class="top_row_right"> </td>
</tr>
<tr>
  <td class="left_column">

    <?php
    require("$g_root_dir/global/templates/admin_nav.php");
    ?>

  </td>
  <td class="main_content">
