/*------------------------------------------------------------------------------------------------*\
  File:     manage_submissions.js
  Abstract: contains assorted javascript functions used in the administrator and client Submission
            Listing page. Note: most of these function are strongly coupled (bad!) with the calling
            page, so they're of dubious value elsewhere.
\*------------------------------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------------------------*\
  Function:   check_selected
  Purpose:    validation function called when the user clicks the "download" or "view" buttons for
              the Excel download and Printer-Friendly page. If the "selected" option is selected,
              it checks that the user has selected at least one submission.
\*------------------------------------------------------------------------------------------------*/
function check_selected(action, select_option)
{
  var selected_ids = get_selected_submissions();

  if (select_option == "all")
    return true;

  if (!selected_ids.length)
  {
    if (action == "print_preview")
      alert(g_messages["validation_select_rows_to_view"]);
    else
      alert(g_messages["validation_select_rows_to_download"]);
    
    return false;
  }
  
  return true;
}


/*------------------------------------------------------------------------------------------------*\
  Function:   get_selected_submissions
  Purpose:    helper function which returns an array of the submission rows that have been 
              selected on the page.
\*------------------------------------------------------------------------------------------------*/
function get_selected_submissions()
{
  var selected_ids = new Array();
  for (i=0; i<submission_arr.length; i++)
  {
    curr_id = submission_arr[i];
    if ($('submission_cb_' + curr_id).checked)
      selected_ids.push(curr_id);
  }
  
  return selected_ids;
}


/*------------------------------------------------------------------------------------------------*\
  Function:   delete_submissions
  Purpose:    checks that the user has selected at least one submission and confirms they really 
              want to delete them.
\*------------------------------------------------------------------------------------------------*/
function delete_submissions(page)
{
  var selected_ids = get_selected_submissions();

  // if empty, alert the user and return
  if (!selected_ids.length)
  {
    alert(g_messages["validation_select_submissions_to_delete"]);
    return;
  }

  if (selected_ids.length == 1) 
    var answer = confirm(g_messages["confirm_delete_submission"]);
  else 
    var answer = confirm(g_messages["confirm_delete_submissions"]);
 
  var submission_ids = selected_ids.join(",");

  if (answer)
    window.location = '?delete=1&submission_ids=' + submission_ids + '&form_id=' + form_id 
}


/*------------------------------------------------------------------------------------------------*\
  Function:   init_page
  Purpose:    validation function called when the user clicks the "download" or "view" buttons for
              the Excel download and Printer-Friendly page. If the "selected" option is selected,
              it checks that the user has selected at least one submission.
\*------------------------------------------------------------------------------------------------*/
function init_page(style_source)
{
  var all_checked = true;
  
  if (submission_arr == "")
    return;

  change_search_field(document.search_form.search_field.value);

  // check all the rows that are selected are correctly coloured
  for (i=0; i<submission_arr.length; i++)
  {
    curr_id = submission_arr[i];
    if ($('submission_cb_' + curr_id).checked)
    {
			if (style_source == "JS")
				$('submission_row_' + curr_id).style.backgroundColor = selected_row_color;
			else
				$('submission_row_' + curr_id).className = "selected_row_color";
    }
    else
      all_checked = false;
  }
  
  // if all the rows are selected and the user HASN'T indicated they wish to offer 
  if (all_checked)
  {
    if (select_all_submissions_returned)
      select_all_submissions_on_page = true;
    
    select_all();
  }
}


/*------------------------------------------------------------------------------------------------*\
  Function:   select_row
  Purpose:    selects/unselects an individual submission row, and changes the row colour to
              clearly show what's selected and what isn't.
  Parameters: id               - the unique submission ID
              results_per_page - the number of results in the page
              style_source     - "CSS" / "JS". This indicates the source of where the selected / 
                              unselected row colour is, since it differs between client and admin 
                              pages. 

              *** eventually this should be refactored for CSS only. ALL style information should 
              be stored in CSS, not hardcoded in JS. Rethink.
\*------------------------------------------------------------------------------------------------*/
function select_row(id, results_per_page, style_source)
{
  if (document.current_form['submission_cb_' + id].checked)
  {
    if (style_source == "JS")
      $('submission_row_' + id).style.backgroundColor = selected_row_color;
    else
      $('submission_row_' + id).className = "selected_row_color";
      
    // if all have been selected, update the Select All button
    selected_ids = get_selected_submissions();
    if (results_per_page == selected_ids.length)
    {
			$("select_button").value = g_messages["phrase_select_all_X_results"].replace(/%%numresults%%/, num_results);
			$("select_button").style.color = "#336699"; 
      select_all_submissions_on_page = true;
    }
  }
  else
  {
    if (style_source == "JS")
      $('submission_row_' + id).style.backgroundColor = unselected_row_color;
    else
      $('submission_row_' + id).className = "unselected_row_color";
    
    if (select_all_submissions_on_page)
    {
			$("select_button").value = g_messages["phrase_select_all_on_page"];
			$("select_button").style.color = "#000000"; 
      select_all_submissions_on_page = false;
    }
  }
}


/*------------------------------------------------------------------------------------------------*\
  Function:   select_all
  Purpose:    selects all submission rows on the page.
  Parameters: style_source - "CSS" / "JS". This indicates the source of where the selected / 
                              unselected row colour is, since it differs between client and admin 
                              pages. 
\*------------------------------------------------------------------------------------------------*/
function select_all(style_source)
{
  // if all the submissions on the page are already selected, now mark ALL results as selected
  // and make a note of it in sessions
	if (select_all_submissions_on_page)
	{
		$("select_button").value = g_messages["phrase_all_X_results_selected"].replace(/%%numresults%%/, num_results);
		$("select_button").style.color = "#666666";
		$("select_button").disabled = true;

    document.hidden_form.action.value = "select_all_submissions";
    document.hidden_form.submit();
	}
	else
	{
		$("select_button").value = g_messages["phrase_select_all_X_results"].replace(/%%numresults%%/, num_results);
		$("select_button").style.color = "#336699";
		select_all_submissions_on_page = true;

		for (i=0; i<submission_arr.length; i++)
		{
			curr_id = submission_arr[i];
			
			if (style_source == "JS")
			  $('submission_row_' + curr_id).style.backgroundColor = selected_row_color;
			else
        $('submission_row_' + curr_id).className = "selected_row_color";

			$('submission_cb_' + curr_id).checked = true;   
		}
	}
}


/*------------------------------------------------------------------------------------------------*\
  Function:   unselect_all
  Purpose:    unselects all submission rows on the page.
  Parameters: style_source - "CSS" / "JS". This indicates the source of where the selected / 
                              unselected row colour is, since it differs between client and admin 
                              pages. 
\*------------------------------------------------------------------------------------------------*/
function unselect_all(style_source)
{
  for (i=0; i<submission_arr.length; i++)
  {
    curr_id = submission_arr[i];

		if (style_source == "JS")
      $('submission_row_' + curr_id).style.backgroundColor = unselected_row_color;
		else
			$('submission_row_' + curr_id).className = "unselected_row_color";

    $('submission_cb_' + curr_id).checked = false;   
  }

  select_all_submissions_on_page = false;
	$("select_button").value = g_messages["phrase_select_all_on_page"];
	$("select_button").style.color = "#000000"; 
  $("select_button").disabled = false;

	document.hidden_form.action.value = "unselect_all_submissions";
	document.hidden_form.submit();
}


// used to hide/show the additional date search options
function change_search_field(choice)
{  
  if (choice == "submission_date")
    $("search_dropdown_section").style.display = "block";
  else
    $("search_dropdown_section").style.display = "none";  
}
