/*------------------------------------------------------------------------------------------------*\
  File:     general.js
  Abstract: contains general javascript functions for use throughout the application.
\*------------------------------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------------------------*\
  Function:    display_dhtml_page_nav
  Description: function to display DHTML page navigation for lists. This function hides/shows the 
               current page - all of which exist in the page but are hidden with CSS. It also 
               updates other aspects of the pagination: the "viewing X-Y" section, the >> and << 
               links and 
  Assumption:  the PHP counterpart function with the same name has been called in the calling page. 
               That function sets up the 
  Parameters:  page         - the current page number
               total_pages  - the total number of pages
               num_per_page - the number of items listed per page
\*------------------------------------------------------------------------------------------------*/
function display_dhtml_page_nav(num_results, num_per_page, current_page)
{
  total_pages = Math.ceil(num_results / num_per_page);

  // hide/show the appropriate pages
  for (i=1; i<=total_pages; i++)
  {
    if (current_page == i)
    {
      $("page_" + i).style.display = "block";
      $("nav_page_" + i).innerHTML = "<b>" + i + "</b> ";
    }
    else
    {
      $("page_" + i).style.display = "none";
      $("nav_page_" + i).innerHTML = "<a href='javascript:display_dhtml_page_nav("
        + num_results + ", " + num_per_page + ", " + i + ")'>" + i + "</a> ";
    }
  }
  
  // update the "Viewing X-Y" text 
  var tmp = (current_page - 1) * num_per_page;
  var max_end = tmp + num_per_page;
  var end = (max_end > num_results) ? num_results : max_end;
  var start = tmp + 1;
  
  $("nav_viewing_num_start").innerHTML = start;
  $("nav_viewing_num_end").innerHTML = end;
  
  
  // update the navigation links: <<
  if (current_page > 1)
  {
    previous_page = current_page - 1;
    $("nav_previous_page").innerHTML = "<a href='javascript:display_dhtml_page_nav("
      + num_results + ", " + num_per_page + ", " + previous_page + ")'>&lt;&lt;</a> ";
  }
  else
    $("nav_previous_page").innerHTML = "&lt;&lt;";

  // >>
  if (current_page < total_pages)
  {
    next_page = current_page + 1;
    $("nav_next_page").innerHTML = "<a href='javascript:display_dhtml_page_nav("
      + num_results + ", " + num_per_page + ", " + next_page + ")'>&gt;&gt;</a> ";  
  }
  else
    $("nav_next_page").innerHTML = "&gt;&gt;";
  
}



/*------------------------------------------------------------------------------------------------*\
  Function:    add_option
  Description: adds a new option to a select dropdown box.
  Parameters:  selectbox    - the select box object
               total_pages  - the display text of the new dropdown option
               value        - the value of the new dropdown option
\*------------------------------------------------------------------------------------------------*/
function add_option(selectbox, text_val, value)
{
  var new_option = new Option(text_val, value);
  var sel_length = selectbox.length;
  selectbox.options[sel_length] = new_option;
}

function delete_option(selectbox, ind)
{ 
  var sel_length = selectbox.length;
  if (sel_length > 0)
    selectbox.options[ind] = null;
}

function move_options(sel_from, sel_to)
{  
  var sel_length = sel_from.length;
  var sel_texts  = new Array();
  var sel_vals   = new Array();
  var sel_count = 0;

  var i;

  // find the selected Options in reverse order and delete them from the 'from' Select
  for (i=sel_length-1; i>=0; i--)
  {
    if (sel_from.options[i].selected)
    {
      // if there's no value, that means the lawyer is away. Don't move them.
      if (sel_from.options[i].value == "")
        continue;
      
      sel_texts[sel_count] = sel_from.options[i].text;
      sel_vals[sel_count]  = sel_from.options[i].value;
      delete_option(sel_from, i);
      sel_count++;
    }
  }

  // add the selected text/values in reverse order. This will add the Options to the 'to' Select
  // in the same order as they were in the 'from' Select
  for (i=sel_count-1; i>=0; i--)
    add_option(sel_to, sel_texts[i], sel_vals[i]);
}


// helper function used to select all options in a multi-select dropdown. This is used prior
// to submitting a form, to ensure the contents are passed along to the server. 
function select_all(el)
{
  // loop through each and select them (this passes them along to the server)
  for (i=0; i<el.length; i++)
    el[i].selected = true;

  return true;
}

