/*------------------------------------------------------------------------------------------------*\
  Function: add_filters
  Purpose:  used to add rows to the filters form. 
\*------------------------------------------------------------------------------------------------*/
function add_filters(num_rows)
{
  // check num_rows is an integer
  if (num_rows.match(/\D/) || num_rows == 0 || num_rows == "")
  {
    alert(g_messages["validation_num_rows_to_add"]);
    document.manage_filters_form.num_rows.focus();
    return;
  }

  // get the current table. If it doesn't exist, this client is not associated with any forms:
  // just return
  if (!$("filters_table"))
    return;
  var tbody = $("filters_table").getElementsByTagName("tbody")[0];

  for (var i=1; i<=num_rows; i++)
  {
    var currRow = ++g_num_rows;
     
    var row = document.createElement("tr");
    row.setAttribute("id", "row_" + currRow);

    // [1] first cell: form name dropdown
    var td1 = document.createElement("td");
    var dd1 = document.createElement("select");
    dd1.setAttribute("name", "filter_" + currRow + "_form_id");
    dd1.onchange = function (evt) { change_form(currRow, this.value); };
		var default_option = document.createElement("option");
		default_option.setAttribute("value", "");
		default_option.appendChild(document.createTextNode(g_messages["phrase_please_select"]));
    dd1.appendChild(default_option);

    // loop through all the forms and add them
    for (var form_id in g_form_info)
    {
      var form_name = g_form_info[form_id];
      var option = document.createElement("option");
      option.setAttribute("value", form_id);
      option.appendChild(document.createTextNode(form_name));
      dd1.appendChild(option);
    }
    td1.appendChild(dd1);

    // [2] second <td> cell: form field dropdown (defaulted to empty)
    var td2 = document.createElement("td");
    var dd2 = document.createElement("select");
    dd2.setAttribute("name", "filter_" + currRow + "_field_id");
    dd2.setAttribute("id", "filter_" + currRow + "_field_id");
    dd2.onchange = function (evt) { change_field(currRow, this.value); };

		var default_option = document.createElement("option");
		default_option.setAttribute("value", "");
		default_option.appendChild(document.createTextNode(g_messages["phrase_please_select_form"]));
    dd2.appendChild(default_option);
    td2.appendChild(dd2);

    // [3] third <td> cell: operator dropdown

    // TODO What if submission_date is first?     
    var td3 = document.createElement("td");
    
    // -- first section: DATE operators
    var first_div = document.createElement("div");
    first_div.setAttribute("id", "filter_" + currRow + "_operators_dates_div");
    first_div.style.cssText = "display: none";
    var operator_dd = document.createElement("select");
    operator_dd.setAttribute("name", "filter_" + currRow + "_operator_date");
    var option1 = document.createElement("option");
    option1.setAttribute("value", "before");
    option1.appendChild(document.createTextNode(g_messages["word_before"]));
    var option2 = document.createElement("option");
    option2.setAttribute("value", "after");
    option2.appendChild(document.createTextNode(g_messages["word_after"]));
    operator_dd.appendChild(option1);
    operator_dd.appendChild(option2);
    first_div.appendChild(operator_dd);

    // -- second section: REGULAR operators
    var second_div = document.createElement("div");
    second_div.setAttribute("id", "filter_" + currRow + "_operators_div");
    var operator_dd = document.createElement("select");
    operator_dd.setAttribute("name", "filter_" + currRow + "_operator");
    var option1 = document.createElement("option");
    option1.setAttribute("value", "equals");
    option1.appendChild(document.createTextNode(g_messages["word_equals"]));
    var option2 = document.createElement("option");
    option2.setAttribute("value", "not_equals");
    option2.appendChild(document.createTextNode(g_messages["phrase_not_equal"]));
    var option3 = document.createElement("option");
    option3.setAttribute("value", "like");
    option3.appendChild(document.createTextNode(g_messages["word_like"]));
    var option4 = document.createElement("option");
    option4.setAttribute("value", "not_like");
    option4.appendChild(document.createTextNode(g_messages["phrase_not_like"]));
    operator_dd.appendChild(option1);
    operator_dd.appendChild(option2);
    operator_dd.appendChild(option3);
    operator_dd.appendChild(option4);
    second_div.appendChild(operator_dd);    
    td3.appendChild(first_div);
    td3.appendChild(second_div);

    // [4] fourth <td> cell: user defined values textbox
    var td4 = document.createElement("td");

    // -- first section: DATE textbox & select image
    var first_div = document.createElement("div");
    first_div.setAttribute("id", "filter_" + currRow + "_values_dates_div");
    first_div.style.cssText = "display: none";
    var inp = document.createElement("input");
    inp.setAttribute("type", "text");
    inp.setAttribute("name", "filter_" + currRow + "_filter_date_values");
    inp.setAttribute("id", "date_" + currRow);
    inp.style.cssText = "width: 100px";
    var img = document.createElement("img");
    img.setAttribute("src", "../../images/calendar_icon.gif");
    img.setAttribute("id", "date_image_" + currRow);
    img.setAttribute("border", "0");
    img.style.cssText = "float: right";
    first_div.appendChild(img);
    first_div.appendChild(inp);
   
    // -- second section: REGULAR textbox
    var second_div = document.createElement("div");
    second_div.setAttribute("id", "filter_" + currRow + "_values_div");
    var inp2 = document.createElement("input");
    inp2.setAttribute("type", "text");
    inp2.setAttribute("name", "filter_" + currRow + "_filter_values");
    inp2.setAttribute("style", "width: 120px;");
    second_div.appendChild(inp2);
    td4.appendChild(first_div);
    td4.appendChild(second_div);

    // [5] a delete column
    var td5 = document.createElement("td");
    td5.setAttribute("align", "center");
    td5.setAttribute("class", "del"); // for Mozilla
    td5.className = "del"; // for IE
    var delete_link = document.createElement("a");
    delete_link.setAttribute("href", "#");
    delete_link.onclick = function (evt) { delete_row(currRow); };
    delete_link.appendChild(document.createTextNode(g_messages["word_delete_uc"]));
    td5.appendChild(delete_link);

    // add the table data cells to the row
    row.appendChild(td1);
    row.appendChild(td2);
    row.appendChild(td3);
    row.appendChild(td4);
    row.appendChild(td5);

    // add the row to the table
    tbody.appendChild(row);
    
    // init a Calendar for this row
	  Calendar.setup({
	     inputField     :    "date_" + currRow,
	     showsTime      :    true,
	     timeFormat     :    "24",
	     ifFormat       :    "%Y-%m-%d %H:%M:00",
	     button         :    "date_image_" + currRow,
       align          :    "Bl",
	     singleClick    :    true
	  });
  } 
    
  // update the number of columns
  document.manage_filters_form.num_filters.value = g_num_rows;
}


/*------------------------------------------------------------------------------------------------*\
  Function: change_form
  Purpose:  called by the form dropdown onchange handler; updates the corresponding form's form
            fields dropdown. 
\*------------------------------------------------------------------------------------------------*/
function change_form(row, form_id)
{  
  form_field = $("filter_" + row + "_field_id");
  
  // add all the form field options
  var form_fields = eval("form_" + form_id);

  form_field.options.length = 0;
  
  var index = 0;
  for (var option in form_fields)
  {
    form_field.options[index] = new Option(form_fields[option], option);
    index++;
  }
}


/*------------------------------------------------------------------------------------------------*\
  Function: change_field
  Purpose:  called by the form field dropdown onchange handler; shows the appropriate operators and
            values section.
\*------------------------------------------------------------------------------------------------*/
function change_field(row, field_id)
{  
  if (field_id.match("date"))
  {
    $("filter_" + row + "_operators_div").style.display = "none";
    $("filter_" + row + "_operators_dates_div").style.display = "block";
    $("filter_" + row + "_values_div").style.display = "none";
    $("filter_" + row + "_values_dates_div").style.display = "block";
  }
  else
  {
    $("filter_" + row + "_operators_div").style.display = "block";
    $("filter_" + row + "_operators_dates_div").style.display = "none";
    $("filter_" + row + "_values_div").style.display = "block";
    $("filter_" + row + "_values_dates_div").style.display = "none";
  }
}


/*------------------------------------------------------------------------------------------------*\
  Function: delete_row
  Purpose:  deletes an individual row. Note that this does NOT re-id all the other fields (e.g.
            after deleting row 5, row 6 still has an id of row_6) nor does it decrement the global  
            row counter "g_num_rows". This is done for simplicity. The PHP function that handles the 
            update discards any rows without a FORM specified, so the absent row is not important.
            The num_filters hidden field (which is based on the g_num_rows value) IS important,
            though - that lets the PHP function know how many rows (or the MAX rows) that the form 
            is sending. So again, it's fine that the actual number of rows passed is less.             
\*------------------------------------------------------------------------------------------------*/
function delete_row(row)
{
  // get the current table
  var tbody = $("filters_table").getElementsByTagName("tbody")[0];

  for (i=tbody.childNodes.length-1; i>0; i--)
  {
    if (tbody.childNodes[i].id == "row_" + row)
      tbody.removeChild(tbody.childNodes[i]);
  }
}
