<?php

/**
 * Form Tools - generic form processing, storage and access script
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License included in this zipfile for more details.
 *
 * This file defines all global variables for Form Tools and imports all functions used throughout
 * the script. DO NOT CHANGE ANY OF THESE VALUES. As of version 1.4.6, all custom settings
 * for your installation of Form Tools should be stored in a separate config.php file, stored in the
 * same folder as this one. The config.php is NEVER overwritten, which greatly simplifies
 * upgrading.
 *
 * @author Benjamin Keen <ben.keen@gmail.com>
 * @version 1.5.1
 * @package 1-5-1
 */

// -------------------------------------------------------------------------------------------------

/**
 * This is the base URL of the Form Tools installation on your server. e.g.
 * http://www.yoursite.com/form_tools. You can either supply an absolute or relative URL. Note: if
 * you include the full URL, make sure that the "www." part is either included or removed
 * consistently; if you try to log in at http://www.yoursite.com/admin but your $g_root_url is set to
 * http://yoursite.com/admin it will not work! (and vice versa).
 * @global string $g_root_url
 */
$g_root_url = "";

/**
 * The server directory path to your Form Tools folder.
 * @global string $g_root_dir
 */
$g_root_dir = "";

/**
 * The database hostname (most often 'localhost').
 * @global string $g_db_hostname
 */
$g_db_hostname = "";

/**
 * The name of the database. Most often, hosting providers provide you with some sort of user
 * interface for creating databases and assigning user accounts to them. If you are creating a new
 * database for Form Tools, I would recommend "form_tools" for clarity. Enter the database name
 * here.
 * @global string $g_db_name
 */
$g_db_name     = "";

/**
 * The MySQL username. Note: this user account must have privileges for creating new tables, in
 * addition to adding and removing records.
 * @global string $g_db_username
 */
$g_db_username = "";

/**
 * The MySQL password.
 * @global string $g_db_password
 */
$g_db_password = "";


// -------------------------------------------------------------------------------------------------

/**
 * This value lets you define a custom database prefix for your Form Tools tables. This is handy if
 * Form Tools will be added to an existing database and you want to avoid table naming conflicts.
 * @global string $g_table_prefix
 */
$g_table_prefix = "ft_";

/**
 * This controls the maximum number of pagination links that appear in the Form Tools UI (e.g. for
 * viewing the submission listings page).
 * @global string $g_max_nav_pages
 */
$g_max_nav_pages = 20;

/**
 * This offers minimal support for unicode. Namely (a) all form submissions will be sent as UTF-8
 * and (b) UTF-8 HTML headers will be supplied for Excel downloads. Note, you will need to set this
 * value to true before installing, since it needs to know initially to create the tables as
 * unicode.
 * @global string $g_unicode
 */
$g_unicode = false;


/**
 * This is set to 1 by default (genuine errors only). Crank it up to 2047 to list every
 * error/warning that occurs.
 * @global string $g_default_error_reporting
 */
$g_default_error_reporting = 1;

/**
 * This feature currently has limited support in the code, but will be implemented more fully at a
 * later stage. When set to true it provides detailed, technical reasons for errors that occur.
 * @global string $g_debug
 */
$g_debug = false;

/**
 * This determines the value used in the database to separate multiple field values (checkboxes and
 * multi-select boxes). It's strongly recommended that unless you have a programmatical reason, you
 * should leave it to the default comma-space value.
 * @global string $g_multi_val_delimiter
 */
$g_multi_val_delimiter = ", ";

/**
 * This determines the value used to separate the content of array form submissions (e.g. checkboxes
 * in your form that have the same name, or multi-select dropdowns) when submitted via a query
 * string for "direct" form submissions (added in version 1.4.2).
 * @global string $g_query_str_multi_val_separator
 */
$g_query_str_multi_val_separator = ",";

// -------------------------------------------------------------------------------------------------

// include all code libraries
if (is_file(dirname(__FILE__) . "/config.php"))
  include_once(dirname(__FILE__) . "/config.php");

// explicitly set the error reporting value
error_reporting($g_default_error_reporting);

// just in case, add the current path to the include path
set_include_path(get_include_path() . PATH_SEPARATOR . dirname(__FILE__));

require_once("code/accounts.php");
require_once("code/emails.php");
require_once("code/forms.php");
require_once("code/general.php");
require_once("code/languages.php");
require_once("code/submissions.php");
require_once("code/upgrade.php");

// load the appropriate language file
$g_language = ft_get_ui_language();
include_once("lang/{$g_language}.php");
