<?php

/**
 * This file contains all code relating to upgrading Form Tools.
 *
 * @copyright Benjamin Keen 2007
 * @author Benjamin Keen <ben.keen@gmail.com>
 * @package 1-5-1
 * @subpackage Upgrade
 */

// -------------------------------------------------------------------------------------------------


/**
 * A handy function to upgrade ANY old version to the latest. It works by simply processing each
 * upgrade in turn from 1.1.0 to the most recent. It is called when logging in for the first time
 * after an upgrade.
 *
 * @return boolean is_upgraded A boolean indicating whether or not the program was just upgraded.
 */
function ft_upgrade_form_tools()
{
	global $g_table_prefix;

	$is_upgraded = false;

	$current_version = _ft_get_version_as_number();

	// if there's no current version, just return
	if (empty($current_version))
		return;

	// ---------------------------- update to 1.1.0 --------------------------------
	if ($current_version < 101)
	{
		$link = ft_db_connect();

		// add printer_friendly_format option to all forms
		mysql_query("
			ALTER TABLE {$g_table_prefix}forms
			ADD `printer_friendly_format` ENUM('table', 'one_per_page', 'one_by_one')
			DEFAULT 'table' NOT NULL
								");

		// rename field_type to field_size
		mysql_query("
			ALTER TABLE {$g_table_prefix}form_templates
			CHANGE `field_type` `field_size` ENUM('tiny', 'small', 'medium', 'large', 'very_large')
			DEFAULT 'small'
								");

		// add field_type field after field_size
		mysql_query("
			ALTER TABLE {$g_table_prefix}form_templates
			ADD `field_type` ENUM('select', 'multi-select', 'radio-buttons', 'checkboxes', 'other')
			DEFAULT 'other' NOT NULL AFTER `field_size`
								");

		// add option_orientation field to form_templates
		mysql_query("
			ALTER TABLE {$g_table_prefix}form_templates
			ADD `option_orientation` ENUM('vertical', 'horizontal')
			NOT NULL DEFAULT 'vertical'
								");

		// create the field options table
		mysql_query("
			CREATE TABLE `{$g_table_prefix}field_options` (
				`option_id` mediumint(9) NOT NULL auto_increment,
				`field_id` mediumint(8) unsigned NOT NULL,
				`option_value` varchar(255) NOT NULL,
				`option_name` varchar(255) NOT NULL,
				`option_order` smallint(6) NOT NULL,
				PRIMARY KEY  (`option_id`)
			) TYPE=MyISAM AUTO_INCREMENT=1
								");

		// add date_format record to settings
		mysql_query("
			INSERT INTO `{$g_table_prefix}settings` (setting_name, setting_value)
			VALUES ('date_format', 'M jS, g:i A')
								");

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.1.0'
			WHERE  setting_name = 'program_version'
								");

		ft_db_disconnect($link);
	}


	// ---------------------------- update to 1.2.0 --------------------------------
	$current_version = _ft_get_version_as_number();
	if ($current_version < 120)
	{
		$link = ft_db_connect();

		mysql_query("
			ALTER TABLE {$g_table_prefix}forms
			CHANGE `auto_email` `auto_email_admin` ENUM('yes', 'no') NOT NULL DEFAULT 'no',
			ADD `auto_email_user` ENUM('yes', 'no') NOT NULL DEFAULT 'no' AFTER `auto_email_admin`,
			CHANGE `email_recipients` `admin_email_recipients` TEXT NULL DEFAULT NULL,
			ADD `user_email_field` VARCHAR(255) NULL AFTER `admin_email_recipients`,
			ADD `user_first_name_field` VARCHAR( 255 ) NULL AFTER `user_email_field`,
			ADD `user_last_name_field` VARCHAR( 255 ) NULL AFTER `user_first_name_field`,
			ADD `admin_email_from` ENUM('admin_email','users_name') NULL AFTER `user_last_name_field`,
			ADD `admin_email_reply_to` ENUM('admin_email','users_name','none') NULL AFTER `admin_email_from`,
			ADD `user_email_from` ENUM('admin_email', 'users_name') NULL AFTER `admin_email_reply_to`,
			ADD `user_email_reply_to` ENUM('admin_email', 'users_name', 'none') NULL AFTER `user_email_from`,
			ADD `email_format` ENUM('text', 'html', 'both') NOT NULL DEFAULT 'both' AFTER `user_email_reply_to`,
			ADD `admin_text_email_template` MEDIUMTEXT NULL AFTER `email_format`,
			ADD `admin_html_email_template` MEDIUMTEXT NULL AFTER `admin_text_email_template`,
			ADD `user_text_email_template` MEDIUMTEXT NULL AFTER `admin_html_email_template`,
			ADD `user_html_email_template` MEDIUMTEXT NULL AFTER `user_text_email_template`,
			ADD `hide_printer_friendly_empty_fields` ENUM('yes', 'no') NOT NULL DEFAULT 'no'
								 ");

		mysql_query("
			ALTER TABLE {$g_table_prefix}form_templates ADD `is_sortable` ENUM('yes', 'no') DEFAULT 'yes' NOT NULL AFTER `admin_display`
								");

		// now set all existing forms to use the 'text' email_format option by default (since that was
		// all that was previously offered)
		mysql_query("UPDATE {$g_table_prefix}forms SET email_format='text'");

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.2.0'
			WHERE  setting_name = 'program_version'
								");

		ft_db_disconnect($link);
	}


	// ---------------------------- update to 1.3.1 --------------------------------
	$current_version = _ft_get_version_as_number();
	if ($current_version < 131)
	{
		$link = ft_db_connect();

		// add the "file" field type options
		mysql_query("
			ALTER TABLE `{$g_table_prefix}form_templates`
			CHANGE `field_type` `field_type` ENUM('select', 'multi-select', 'radio-buttons', 'checkboxes', 'file', 'other') DEFAULT 'other' NOT NULL,
			ADD `file_upload_dir` VARCHAR(255),
			ADD `file_upload_url` VARCHAR(255),
			ADD `file_upload_max_size` VARCHAR(10) DEFAULT '1000000',
			ADD `file_upload_types` VARCHAR(255),
								");

		// add the auto-delete submission files options
		mysql_query("
			ALTER TABLE `{$g_table_prefix}forms` ADD `auto_delete_submission_files` ENUM('yes', 'no') DEFAULT 'yes' NOT NULL
								");

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.3.1'
			WHERE  setting_name = 'program_version'
								");

		ft_db_disconnect($link);
	}

	// ---------------------------- update to 1.4.0 --------------------------------
	$current_version = _ft_get_version_as_number();
	if ($current_version < 140)
	{
		$link = ft_db_connect();

		// add new client-forms cross table
		mysql_query("
			CREATE TABLE `{$g_table_prefix}client_forms` (
				`user_id` MEDIUMINT UNSIGNED NOT NULL,
				`form_id` MEDIUMINT UNSIGNED NOT NULL,
				PRIMARY KEY (`user_id`, `form_id`)
			) TYPE=MyISAM
							");

		// add new settings
		mysql_query("
			INSERT INTO {$g_table_prefix}settings (setting_name, setting_value) VALUES ('num_forms_per_page', '10')
				");

		// add new fields to forms table
		mysql_query("
			ALTER TABLE {$g_table_prefix}forms
				ADD `display_submission_id` ENUM('yes', 'no') NOT NULL DEFAULT 'no',
				CHANGE `admin_email_from` `admin_email_from` ENUM('admin_email', 'users_name', 'custom') DEFAULT NULL,
				CHANGE `admin_email_reply_to` `admin_email_reply_to` ENUM('admin_email', 'users_name', 'custom', 'none') DEFAULT NULL,
				CHANGE `user_email_from` `user_email_from` ENUM('admin_email', 'users_name', 'custom') DEFAULT NULL,
				CHANGE `user_email_reply_to` `user_email_reply_to` ENUM('admin_email', 'users_name', 'custom', 'none') DEFAULT NULL,
				ADD `admin_email_from_custom` VARCHAR(100) NULL AFTER `admin_email_from`,
				ADD `admin_email_reply_to_custom` VARCHAR(100) NULL AFTER `admin_email_reply_to`,
				ADD `user_email_from_custom` VARCHAR(100) NULL AFTER `user_email_from`,
				ADD `user_email_reply_to_custom` VARCHAR(100) NULL AFTER `user_email_reply_to`,
				ADD `include_admin_email` ENUM('yes', 'no') DEFAULT 'no' NOT NULL AFTER `user_email_reply_to_custom`
								");

		// port over old user_ids
		$old_form_info = mysql_query("
			SELECT user_id, form_id
			FROM {$g_table_prefix}forms
								");
		while ($old_info = mysql_fetch_assoc($old_form_info))
		{
			mysql_query("
				INSERT INTO {$g_table_prefix}client_forms (user_id, form_id)
				VALUES ({$old_info['user_id']}, {$old_info['form_id']})
									");
		}

		// remove old user_id and admin_email_recipients fields
		mysql_query("
			ALTER TABLE {$g_table_prefix}forms
				DROP `user_id`,
				DROP `admin_email_recipients`
								");

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.4.0'
			WHERE  setting_name = 'program_version'
								");

		ft_db_disconnect($link);
	}

	// ---------------------------- update to 1.4.1 --------------------------------
	$current_version = _ft_get_version_as_number();
	if ($current_version < 141)
	{
		$link = ft_db_connect();

		// if upgrading, set the emailing method to "advanced" for compatibility. All new installations
		// will be set to "basic"
		mysql_query("
			INSERT INTO {$g_table_prefix}settings (setting_name, setting_value)
			VALUES ('emailing_method', 'advanced')
								");

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.4.1'
			WHERE  setting_name = 'program_version'
								");

		ft_db_disconnect($link);
	}

	// ---------------------------- update to 1.4.2 --------------------------------
	$current_version = _ft_get_version_as_number();
	if ($current_version < 142)
	{
		$link = ft_db_connect();

		// add the new client account settings
		mysql_query("
			ALTER TABLE {$g_table_prefix}user_accounts
				ADD may_delete_submissions ENUM('yes','no') NOT NULL DEFAULT 'yes',
				ADD may_edit_submissions ENUM('yes','no') NOT NULL DEFAULT 'yes',
				ADD may_download_excel ENUM('yes','no') NOT NULL DEFAULT 'yes',
				ADD may_view_printer_friendly_page ENUM('yes','no') NOT NULL DEFAULT 'yes',
				ADD include_have_a_question_page ENUM('yes','no') NOT NULL DEFAULT 'yes'
			");

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.4.2'
			WHERE  setting_name = 'program_version'
								");

		ft_db_disconnect($link);
	}

	// ---------------------------- update to 1.4.3 --------------------------------
	$current_version = _ft_get_version_as_number();
	if ($current_version < 143)
	{
		$link = ft_db_connect();

		// add the fields for storing email subjects and deprecate "display_submission_id" field,
		// replaced with "show_ip_address"
		mysql_query("
			ALTER TABLE {$g_table_prefix}forms
				ADD admin_email_subject VARCHAR(200) NULL DEFAULT '%FORMNAME%: Submission' AFTER `user_last_name_field`,
				ADD user_email_subject VARCHAR(200) NULL DEFAULT '%FORMNAME%: Submission' AFTER `admin_email_reply_to_custom`,
				CHANGE `display_submission_id` `show_ip_address` ENUM( 'yes', 'no' ) NOT NULL DEFAULT 'no'
			");

		// add system field
		mysql_query("
			ALTER TABLE `{$g_table_prefix}form_templates` CHANGE `field_type` `field_type` ENUM('select','multi-select','radio-buttons','checkboxes','file','other','system') NOT NULL DEFAULT 'other'
				");

		ft_db_disconnect($link);

		// get a list of all forms and add the new 3 system fields (submission ID, submission date and IP address) to each.
		// Order them at the END of the rest. This is necessary because the form fields in the email templates are ordered;
		// if we inserted the new fields at the start, the ordering would be thrown off and (potentially) email submission
		// content will become invalid. The drawback to adding it to the end is that if the person had the "show submission ID
		// in listings page" option set to "yes", it will now appear as a column at the end instead of the start. This will
		// be mentioned in the upgrade instructions!
		$forms = ft_get_client_forms();
		if (is_array($forms) && !empty($forms))
		{
			foreach ($forms as $form)
			{
				$form_id = $form[0]["form_id"];

				// find out how many fields are currently associated to this form
				$form_template = ft_get_form_template($form_id);
				$count = mysql_num_rows($form_template);
				$count++;

				$link = ft_db_connect();
				mysql_query("
					INSERT INTO {$g_table_prefix}form_templates (form_id, field_name, field_test_value, field_type, field_title, col_name, list_order, admin_display, is_sortable)
					VALUES ('$form_id', 'Submission ID', '', 'system', 'ID', 'submission_id', '$count', 'no', 'yes')
						");
				$count++;

				mysql_query("
					INSERT INTO {$g_table_prefix}form_templates (form_id, field_name, field_test_value, field_type, field_title, col_name, list_order, admin_display, is_sortable)
					VALUES ('$form_id', 'Date', '', 'system', 'Date', 'submission_date', '$count', 'yes', 'yes')
						");
				$count++;

				mysql_query("
					INSERT INTO {$g_table_prefix}form_templates (form_id, field_name, field_test_value, field_type, field_title, col_name, list_order, admin_display, is_sortable)
					VALUES ('$form_id', 'IP Address', '', 'system', 'IP Address', 'ip_address', '$count', 'no', 'yes')
						");
				ft_db_disconnect($link);
			}
		}

		$link = ft_db_connect();

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.4.3'
			WHERE  setting_name = 'program_version'
								");

		ft_db_disconnect($link);

		$is_upgraded = true;
	}

	// ---------------------------- update to 1.4.4 --------------------------------
	$current_version = _ft_get_version_as_number();
	if ($current_version < 144)
	{
		$link = ft_db_connect();

		// add the date_created fields to the forms table
		mysql_query("
			ALTER TABLE {$g_table_prefix}forms
			ADD `date_created` DATETIME NOT NULL AFTER `form_type`
				");

		// add the new permission fields
		mysql_query("
			ALTER TABLE {$g_table_prefix}user_accounts
			ADD may_take_forms_offline ENUM('yes', 'no') NOT NULL DEFAULT 'no',
			ADD may_change_email_settings ENUM('yes', 'no') NOT NULL DEFAULT 'no',
			ADD may_change_num_submissions ENUM('yes', 'no') NOT NULL DEFAULT 'no',
			ADD may_change_default_printer_friendly_format ENUM('yes', 'no') NOT NULL DEFAULT 'no',
			ADD may_change_default_hide_empty_fields ENUM('yes', 'no') NOT NULL DEFAULT 'no'
								");

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.4.4'
			WHERE  setting_name = 'program_version'
								");

		ft_db_disconnect($link);

		$is_upgraded = true;
	}

	// ---------------------------- update to 1.4.5 --------------------------------
	$current_version = _ft_get_version_as_number();
	if ($current_version < 144)
	{
		$link = ft_db_connect();

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.4.5'
			WHERE  setting_name = 'program_version'
								");

		ft_db_disconnect($link);

		$is_upgraded = true;
	}

	// ---------------------------- update to 1.4.6 --------------------------------
	$current_version = _ft_get_version_as_number();
	if ($current_version < 146)
	{
		$link = ft_db_connect();

		// create the new client_filters table
		mysql_query("
			CREATE TABLE {$g_table_prefix}client_filters (
				filter_id mediumint(8) unsigned NOT NULL auto_increment,
				user_id mediumint(8) unsigned NOT NULL,
				form_id mediumint(8) unsigned NOT NULL,
				field_id mediumint(8) unsigned NOT NULL,
				operator enum('equals','not_equals','like','before','after') NOT NULL default 'equals',
				filter_values mediumtext NOT NULL,
				filter_sql mediumtext NOT NULL,
				PRIMARY KEY  (filter_id)
			) ENGINE=InnoDB AUTO_INCREMENT=1
		 ");

		// add the data type
		mysql_query("ALTER TABLE {$g_table_prefix}form_templates ADD data_type ENUM( 'string', 'number', 'date' ) NOT NULL DEFAULT 'string' AFTER field_type");

		// add the new beta-related fields
		mysql_query("INSERT INTO {$g_table_prefix}settings VALUES (NULL, 'is_beta', 'no')");
		mysql_query("INSERT INTO {$g_table_prefix}settings VALUES (NULL, 'beta_version', '')");

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.4.6'
			WHERE  setting_name = 'program_version'
								");

		ft_db_disconnect($link);

		$is_upgraded = true;
	}


	// ---------------------------- update to 1.4.7 --------------------------------
	$current_version = _ft_get_version_as_number();
	if ($current_version < 147)
	{
		$link = ft_db_connect();

		// add the new fields: the options to enable / disable strip_tags for form submissions and an optional validation file
		// for "direct" form types.
		mysql_query("ALTER TABLE {$g_table_prefix}forms ADD submission_strip_tags ENUM('yes', 'no') NOT NULL DEFAULT 'yes'");

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.4.7'
			WHERE  setting_name = 'program_version'
								");

		ft_db_disconnect($link);

		$is_upgraded = true;
	}


	// ---------------------------- update to 1.5.0 --------------------------------
	$current_version = _ft_get_version_as_number();
	if ($current_version < 150)
	{
		$link = ft_db_connect();

		// add the new field for storing the user's language
		mysql_query("ALTER TABLE {$g_table_prefix}user_accounts ADD `ui_language` VARCHAR( 50 ) NOT NULL DEFAULT 'en_us' AFTER `active`");

		// add the language settings
		mysql_query("INSERT INTO {$g_table_prefix}settings (setting_name, setting_value) VALUES ('default_language', 'en_us')");
		mysql_query("INSERT INTO {$g_table_prefix}settings (setting_name, setting_value) VALUES ('available_languages', 'en_us,English (US)')");

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.5.0'
			WHERE  setting_name = 'program_version'
								");

		ft_db_disconnect($link);

		$is_upgraded = true;
	}

	// ---------------------------- update to 1.5.1 --------------------------------
	$current_version = _ft_get_version_as_number();
	if ($current_version < 151)
	{
		$link = ft_db_connect();

		// update the version number
		mysql_query("
			UPDATE {$g_table_prefix}settings
			SET    setting_value = '1.5.1'
			WHERE  setting_name = 'program_version'
								");
		ft_db_disconnect($link);
		$is_upgraded = true;
	}

	
	$link = ft_db_connect();
	mysql_query("UPDATE {$g_table_prefix}settings SET setting_value = 'no' WHERE setting_name = 'is_beta'");
	mysql_query("UPDATE {$g_table_prefix}settings SET setting_value = '' WHERE setting_name = 'beta_version'");
	ft_db_disconnect($link);

	return $is_upgraded;
}


/**
 * Helper function to return the current version of Form Tools as a number.
 *
 * @return integer The current Form Tools version as a number (e.g. 145 -> 1.4.5)
 */
function _ft_get_version_as_number()
{
	$settings = ft_get_settings();
	$version = $settings['program_version'];
	$version = preg_replace("/\D/", "", $version);

	return $version;
}

