<?php

/**
 * This file defines all language/translation-related functions used in Form Tools. Note: the
 * ft_get_date function also permits localization of dates, but the general.php file seemed a
 * better location for it.
 *
 * @copyright Benjamin Keen 2007
 * @author Benjamin Keen <ben.keen@gmail.com>
 * @package 1-5-1
 * @subpackage Languages
 */


// -------------------------------------------------------------------------------------------------


/**
 * This special function is called on every page load within library.php, and is used to determine
 * the language for the current user.
 *
 * @return string $language the language string, e.g. "en_us", corresponding to the appropriate
 *          language file that will be loaded.
 */
function ft_get_ui_language()
{
	global $g_table_prefix, $g_root_dir, $g_root_url;


	// always set the default language to en_us
	$language = "en_us";

	// if the user isn't logged in, retrieve whatever language is most appropriate. Note that this
    // doesn't store the language ID in sessions: it keeps getting checked for as long as they're not
    // logged in
	if (!isset($_SESSION["ft"]["login_user_id"]))
	{
		if (!empty($g_root_url))
		{
			$link = ft_db_connect();

			// this may fail if the DB isn't set up (i.e. during installation)
			$default_lang_result = @mysql_query("
				SELECT setting_value as lang
				FROM {$g_table_prefix}settings
				WHERE setting_name = 'default_language'
					");

			if ($default_lang_result)
			{
				$query_info = mysql_fetch_assoc($default_lang_result);

        if (!empty($query_info))
				  $language = $query_info["lang"];
			}

			ft_db_disconnect($link);
		}
	}
  
  // here they're logged in
	else
	{
		if (isset($_SESSION["ft"]["ui_language"]) && !empty($_SESSION["ft"]["ui_language"]))
    {
      // final check: check the language is a valid language file
      if (is_file("$g_root_dir/global/lang/{$_SESSION["ft"]["ui_language"]}.php"))
        $language = $_SESSION["ft"]["ui_language"];
    }
		else
		{
			// we check to see $g_root_url is defined for the very rare case where a person attempted
			// a previous installation and $_SESSION["ft"]["login_user_id"] is set, but the config.php file
			// no longer exists. This wards against an error occurring in that scenario
			if (!empty($g_root_url))
			{
				$link = ft_db_connect();

				// this may fail if the DB isn't set up (i.e. during upgrading)
				$lang_result = @mysql_query("
					SELECT ui_language
					FROM   {$g_table_prefix}user_accounts
					WHERE  user_id = {$_SESSION["ft"]["login_user_id"]}
						");

				if ($lang_result)
				{
					$query_info = mysql_fetch_assoc($lang_result);

					// see comment on previous if-statement
					if (!empty($query_info))
          {
						$language = $query_info["ui_language"];
            $_SESSION["ft"]["ui_language"] = $language;
          }
				}
				ft_db_disconnect($link);
			}
		}
	}

	return $language;
}


/**
 * Refreshes the list of available language files found in the /global/lang folder. This
 * function parses the folder and stores the language info in the "available_languages"
 * settings in the settings table.
 *
 * @return array [0]: true/false (success / failure)
 *               [1]: message string
 */
function ft_refresh_language_list()
{
	global $g_root_dir, $g_table_prefix, $LANG;

	$language_folder_dir = "$g_root_dir/global/lang";

	$available_language_info = array();
	if ($handle = opendir($language_folder_dir))
	{
		while (false !== ($filename = readdir($handle)))
		{
			if ($filename != '.' && $filename != '..' && $filename != "index.php")
			{
				list($lang_file, $lang_display) = _ft_get_language_file_info("$language_folder_dir/$filename");
				$available_language_info[$lang_file] = $lang_display;
			}
		}
		closedir($handle);
	}

	// sort the languages alphabetically
	ksort($available_language_info);

	// now piece everything together in a single string for storing in the database
	$available_languages = array();
	while (list($key,$val) = each($available_language_info))
		$available_languages[] = "$key,$val";
	$available_language_str = join("|", $available_languages);

	$link = ft_db_connect();
	mysql_query("
		UPDATE {$g_table_prefix}settings
		SET    setting_value = '$available_language_str'
		WHERE  setting_name = 'available_languages'
			");
	ft_db_disconnect($link);

	return array(true, $LANG["notify_lang_list_updated"]);
}


/**
 * A simple search and replace function, used to replace any placeholders in language strings.
 * This function lets us define strings that can be translated to any language, since the position
 * of the placeholders can be juggled around, regardless of the language syntax. e.g.
 *
 *     "My name is %%name%%. It is %%date%%"          - English
 *     "%%name%% ist mein name. %%date%% ist le date" - Gobbledegook
 *
 * Okay, I admit it, I don't speak anything but English. But you get the point. :-)
 *
 * @param string $string the string containing one or more placeholders
 * @param string $replacement_info a hash, whose keys are the name of the placeholders and whose
 *       values are the replacement strings. Language placeholders (the ones in the language strings)
 *       are of the form %%placeholder_name%%, but to cut down redundancy do NOT include the %% and %%
 *       characters in the replacement_info keys.
 */
function ft_replace_placeholders($string, $replacement_info)
{
	if (empty($replacement_info))
		return $string;

	// extract the placeholders (keys) and format them, ready for the reg exp
	$placeholders = array_keys($replacement_info);
	$patterns = array();
	foreach ($placeholders as $p)
		$patterns[] = "/%%" . $p . "%%/";

	$replacements = array_values($replacement_info);

	return preg_replace($patterns, $replacements, $string);
}


/**
 * Helper function which examines a particular language file and returns the language
 * filename (en_us, fr_ca, etc) and the display name ("English (US), French (CA), etc).
 *
 * TODO: modify this function to check the file is valid PHP.
 *
 * @param string $file the full path of the language file
 * @return array [0] the language file name<br />
 *               [1] the language display name
 */
function _ft_get_language_file_info($file)
{
	@include($file);

	$defined_vars = get_defined_vars();
	$language_display = $defined_vars["LANG"]["special_language_locale"];

	// now return the filename component, minus the .php
	$pathinfo = pathinfo($file);
	$lang_file = preg_replace("/\.php$/", "", $pathinfo["basename"]);

	return array($lang_file, $language_display);
}

