<?php

/**
 * Form Tools: generic form processing, storage and access script
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License included in this zipfile for more details.
 */


// -------------------------------------------------------------------------------------------------


session_start();
header("Cache-control: private");

require("../library.php");

// the action to take and the ID of the page where it will be displayed (allows for
// multiple calls on same page to load content in unique areas)
$request = array_merge($_GET, $_POST);
$action   = $request['action'];
$returnid = $request['returnid'];

?>
<html>
<head>
	<script type="text/javascript">
	<!--

	// returns whatever content has been requested into the page ID specified through "returnid"
	window.onload = function()
	{
		var return_id = "<?php echo $returnid; ?>";
		if (return_id != "")
			parent.handleIframeReturnValue(document.getElementById("return_value").innerHTML, return_id);
	}

	-->
	</script>
</head>
<body>

<div id="return_value"><?php

switch ($action)
{
	case "test_email":
		list($success, $message) = ft_send_test_email($request);
		if ($success)
			echo "<div class='notify' style='width: 470px'>$message</div>";
		else
			echo "<div class='error' style='width: 470px'><span>Error</span><br /><br />$message</div>";
		break;

	case "test_permissions":
		list($success, $message) = ft_check_upload_folder($_POST['file_upload_dir']);
		if ($success)
			echo "<div class='notify' style='width: 460px'>$message</div>";
		else
			echo "<div class='error2' style='width: 460px'>$message</div>";
		break;

	case "test_folder_url_match":
		list($success, $message) = ft_check_folder_url_match($_POST['file_upload_dir'], $_POST['file_upload_url']);
		if ($success)
			echo "<div class='notify' style='width: 460px'>$message</div>";
		else
			echo "<div class='error2' style='width: 460px'>$message</div>";
		break;

	case "remember_email_tab":
		$form_id = $request['form_id'];
		$tab     = $request['tab'];
		$_SESSION["ft"]["form_{$form_id}_email_tab"] = $tab;
		break;

	case "select_all_submissions":
		$form_id = $request['form_id'];
		$_SESSION["ft"]["form_{$form_id}_select_all_submissions"] = "1";
		break;

	case "unselect_all_submissions":
		$form_id = $request['form_id'];
		unset($_SESSION["ft"]["form_{$form_id}_select_all_submissions"]);
		break;
}

?></div>

</body>
</html>
