<?php

/**
 * This file defines all functions relating to user accounts: both administrators and clients.
 *
 * @copyright Benjamin Keen 2007
 * @author Benjamin Keen <ben.keen@gmail.com>
 * @package 1-5-1
 * @subpackage Accounts
 */


// -------------------------------------------------------------------------------------------------


/**
 * The login procedure for both administrators and clients in. If successful, redirects them to the
 * appropriate page, otherwise returns an error.
 *
 * @param array $infohash This parameter should be a hash (e.g. $_POST or $_GET) containing both
 *                "username" and "password" keys, containing that information for the user trying
 *                to log in.
 * @param boolean $login_as_client [optional] This optional parameter is used by administrators
 *                to log in as a particular client, allowing them to view how the account looks,
 *                even if it is disabled.
 * @return string error message string (if error occurs). Otherwise it redirects the user to the
 *                appropriate page, based on account type.
 */
function ft_login($infohash, $login_as_client = false)
{
	global $g_root_url, $g_table_prefix, $LANG;

	$form_vals = ft_clean_hash($infohash);

	// connect to db and extract info about this user's account
	$link = ft_db_connect();

	$query = mysql_query("
		SELECT account_type, active, user_id, password
		FROM   {$g_table_prefix}user_accounts
		WHERE  username = '{$form_vals['username']}'
			");
	$user_info = mysql_fetch_assoc($query);
	ft_db_disconnect($link);


	// error check user login info
	if (empty($form_vals['password']))                     return $LANG["validation_no_password"];
	if (!$login_as_client && $user_info['active'] == 'no') return $LANG["validation_account_disabled"];
	if (empty($user_info['password']))                     return $LANG["validation_account_not_recognized"];
	if ($form_vals['password'] != $user_info['password'])  return $LANG["validation_wrong_password"];

	// all checks out. Log them in
	$link = ft_db_connect();

	// store account-type specific values in sessions
	$_SESSION['ft']['login_user_id']      = $user_info['user_id'];
	$_SESSION['ft']['login_account_type'] = $user_info['account_type'];

	$settings = mysql_query("
		SELECT setting_name, setting_value
		FROM   {$g_table_prefix}settings
			");

	if ($user_info['account_type'] == "client")
	{
		// extract this client's settings and store them in sessions
		$query = mysql_query("
			SELECT logo, page_titles, footer_text, css, may_delete_submissions, may_edit_submissions,
					may_download_excel, may_view_printer_friendly_page, include_have_a_question_page,
					may_take_forms_offline, may_change_email_settings, may_change_num_submissions,
					may_change_default_printer_friendly_format, may_change_default_hide_empty_fields,
					ui_language
			FROM   {$g_table_prefix}user_accounts ua
			WHERE  user_id = '{$user_info['user_id']}'
				");
		$client_info = mysql_fetch_assoc($query);
		while (list($key, $value) = each($client_info))
			$_SESSION['ft'][$key] = $value;

		// store all the settings in sessions
		while ($row = mysql_fetch_assoc($settings))
		{
			if ($row['setting_name'] == "logout_url")
				$_SESSION['ft'][$row['setting_name']] = $row['setting_value'];
		}

		// now retrieve all filters for this user, and store in separate [ft]["form_{FORM ID}_filters"]
		$query = mysql_query("
			SELECT form_id, filter_sql
			FROM   {$g_table_prefix}client_filters
			WHERE  user_id = '{$user_info['user_id']}'
			ORDER BY form_id
				");
		while ($filter = mysql_fetch_assoc($query))
		{
			$form_id = $filter["form_id"];
			if (!isset($filters["form_{$form_id}_filters"]))
				$filters["form_{$form_id}_filters"] = array();

			$_SESSION["ft"]["form_{$form_id}_filters"][] = $filter["filter_sql"];
		}
	}

	// otherwise the user is an administrator
	else
	{
		// store all the settings in sessions
		while ($row = mysql_fetch_assoc($settings))
			$_SESSION['ft'][$row['setting_name']] = $row['setting_value'];
	}

	// depending on the account_type, redirect to the appropriate page
	if ($user_info['account_type'] == "client")
		header("Location: $g_root_url/main.php");
	else if ($user_info['account_type'] == "admin")
		header("Location: $g_root_url/admin/forms/");

	exit;
}


/**
 * Used by administrators to login as a client. One incidental side-effect of running this function
 * is that it moves the administrator's sessions to a temporary "admin" session key. This allows
 * the standard session-setting to work . When logging out as a client, it erases the old client
 * sessions and replaces them with the old administrator sessions, to enable a smooth transition
 * from one account to the next.
 *
 * @param integer $client_id the client ID
 */
function ft_login_as_client($client_id)
{
	// connect to db and extract info about this user's account
	$link = ft_db_connect();

	// extract the user's login info
	$client_info = ft_get_account_info($client_id);
	$infohash = array();
	$infohash['username'] = $client_info['username'];
	$infohash['password'] = $client_info['password'];

	// move the session values to separate $_SESSION['ft']['admin'] values, so that
	// once the administrator logs out we can reset the sessions appropriately
	$current_values = $_SESSION['ft'];
	$_SESSION['ft'] = array();
	$_SESSION['ft']['admin'] = $current_values;

	ft_db_disconnect($link);

	// now log in
	ft_login($infohash, true);
}


/**
 * Used by the administrator to logout from a client account. Resets appropriate
 * sessions values and redirects back to admin pages.
 */
function ft_logout_as_client()
{
	global $g_root_url;

	// empty old sessions and reload admin settings
	$admin_values = $_SESSION['ft']['admin'];
	$_SESSION["ft"] = array();

	foreach ($admin_values as $key => $value)
		$_SESSION['ft'][$key] = $value;

	unset($_SESSION['ft']['admin']);

	header("location: $g_root_url/admin/clients/");
	exit;
}


/**
 * Used by the "forget password?" page to have a client's login information sent to them.
 *
 * @param array $infohash This parameter should be a hash (e.g. $_POST or $_GET) containing a
 *                "username" keys. That value is used to find the user account information to
 *                email them.
 * @return array [0]: true/false (success / failure)
 *               [1]: message string
 */
function ft_send_password($infohash)
{
	global $g_root_url, $g_table_prefix, $LANG;

	$form_vals = ft_clean_hash($infohash);

	$success = true;
	$message = $LANG["notify_login_info_emailed"];

	// check all required fields were entered
	if (empty($form_vals['username']))
	{
		$success = false;
		$message = $LANG["validation_no_username_or_js"];
		return array($success, $message);
	}
	$username = $form_vals['username'];


	$link = ft_db_connect();
	$query = mysql_query("
		 SELECT *
		 FROM   {$g_table_prefix}user_accounts
		 WHERE  username = '$username'
					");

	// not found
	if (!mysql_num_rows($query))
	{
		$success = false;
		$message = $LANG["validation_account_not_recognized_info"];
		return array($success, $message);
	}

	$user_info = mysql_fetch_assoc($query);

	$email    = $user_info['email'];
	$password = $user_info['password'];
	$content  = "{$LANG["text_login_info"]}

{$LANG["phrase_login_panel_c"]} $g_root_url/
{$LANG["word_username_c"]} $username
{$LANG["word_password_c"]} $password";


	// send email [note: the double quotes around the email recipient and content are intentional:
	// some systems (oddly enough) fail without it]
	if (!mail("$email", $LANG["phrase_login_info_reminder"], "$content"))
	{
		$success = false;
		$message = $LANG["notify_email_not_sent"];
		return array($success, $message);
	}

	// all checks out.
	return array($success, $message);
}


/**
 * Creates a new client based on first and last name, and returns the new user id.
 *
 * @param array $infohash This parameter should be a hash (e.g. $_POST or $_GET) containing the
 *               following keys: first_name, last_name, user_name, password.
 * @return array [0]: true/false (success / failure)
 *               [1]: message string
 *               [2]: the new user ID (if successful)
 */
function ft_add_client($infohash)
{
	global $g_table_prefix, $LANG;

	$form_vals = ft_clean_hash($infohash);

	$success = true;
	$message = "";

	// validate POST fields
	$rules = array();
	$rules[] = "required,first_name,{$LANG["validation_no_client_first_name"]}";
	$rules[] = "required,last_name,{$LANG["validation_no_client_last_name"]}";
	$rules[] = "required,user_name,{$LANG["validation_no_client_username"]}";
	$rules[] = "is_alpha,user_name,{$LANG["validation_invalid_client_username"]}";
	$rules[] = "required,password,{$LANG["validation_no_client_password"]}";
	$rules[] = "is_alpha,password,{$LANG["validation_invalid_client_password"]}";
	$rules[] = "same_as,password,password_2,{$LANG["validation_passwords_different"]}";
	$errors = validate_fields($form_vals, $rules);

	if (!empty($errors))
	{
		$success = false;
		array_walk($errors, create_function('&$el','$el = "&bull;&nbsp; " . $el;'));
		$message = join("<br />", $errors);
		return array($success, $message);
	}

	$first_name = $form_vals['first_name'];
	$last_name  = $form_vals['last_name'];
	$user_name  = $form_vals['user_name'];
	$password   = $form_vals['password'];

	$settings = ft_get_settings();

	$link = ft_db_connect();
	$page_titles = mysql_real_escape_string($settings['program_name']);
	$footer_text = mysql_real_escape_string($settings['program_name']);
	$logo        = "logo_1.gif";
	$css         = mysql_real_escape_string($settings['default_css']);
	$language    = mysql_real_escape_string($settings["default_language"]);
	
	$query = "
		 INSERT INTO {$g_table_prefix}user_accounts
						(account_type, active, ui_language, first_name, last_name, username, password, page_titles,
						 footer_text, logo, css)
		 VALUES ('client', 'yes', '$language', '$first_name', '$last_name', '$user_name', '$password',
						 '$page_titles', '$footer_text', '$logo', '$css')";
	mysql_query($query)
		or ft_handle_error("Failed query in <b>" . __FUNCTION__ . "</b>: <i>$query</i>", mysql_error());

	$new_user_id = mysql_insert_id();

	ft_db_disconnect($link);

	return array($success, $message, $new_user_id);
}


/**
 * Administrator function used to update a client account.
 * It updates one tab at a time - determined by the second $tab_num parameter.
 *
 * @param array $infohash This parameter should be a hash (e.g. $_POST or $_GET) containing keys
 *               named the same as the database fields.
 * @param integer $tab_num the tab number (1-3: 1=main, 2=styles, 3=permissions)
 * @return array [0]: true/false (success / failure)
 *               [1]: message string
 */
function ft_admin_update_client($infohash, $tab_num)
{
	global $g_table_prefix, $g_debug, $LANG;

	$success = true;
	$message = $LANG["notify_client_account_updated"];
	$form_vals = ft_clean_hash($infohash);
	$user_id = $form_vals['client_id'];

	switch ($tab_num)
	{
		// MAIN tab
		case "1":
			$rules = array();
			$rules[] = "required,username,{$LANG["validation_no_client_username"]}";
			$rules[] = "required,password,{$LANG["validation_no_client_password"]}";
			$rules[] = "required,first_name,{$LANG["validation_no_client_first_name"]}";
			$rules[] = "required,last_name,{$LANG["validation_no_client_last_name"]}";
			$rules[] = "required,email,{$LANG["validation_no_client_email"]}";
			$rules[] = "valid_email,email,{$LANG["validation_valid_email"]}";
			$rules[] = "required,ui_language,{$LANG["validation_no_ui_language"]}";
			$errors = validate_fields($form_vals, $rules);

			// check the username isn't already taken
			$username   = $form_vals['username'];
			list($valid_username, $problem) = _ft_is_valid_username($username, $user_id);
			if (!$valid_username)
				$errors[] = $problem;

			if (!empty($errors))
			{
				$success = false;
				array_walk($errors, create_function('&$el','$el = "&bull;&nbsp; " . $el;'));
				$message = join("<br />", $errors);
				return array($success, $message);
			}

			// extract remaining values and update
			$ui_language = $form_vals['ui_language'];
			$first_name  = $form_vals['first_name'];
			$last_name   = $form_vals['last_name'];
			$company     = isset($form_vals['company']) ? $form_vals['company'] : "";
			$email       = $form_vals['email'];
			$password    = $form_vals['password'];

			$query = "
					UPDATE  {$g_table_prefix}user_accounts
					SET     ui_language = '$ui_language',
									first_name='$first_name',
									last_name='$last_name',
									username='$username',
									password='$password',
									email='$email',
									company='$company'
					WHERE   user_id='$user_id'
							 ";
			break;

		// STYLES tab
		case "2":
			$rules = array();
			$rules[] = "required,page_titles,{$LANG["validation_no_titles"]}";
			$rules[] = "required,footer_text,{$LANG["validation_no_footer_text"]}";
			$rules[] = "required,css,{$LANG["validation_no_css"]}";
			$errors = validate_fields($form_vals, $rules);

			if (!empty($errors))
			{
				$success = false;
				array_walk($errors, create_function('&$el','$el = "&bull;&nbsp; " . $el;'));
				$message = join("<br />", $errors);
				return array($success, $message);
			}

			$page_titles = $form_vals['page_titles'];
			$footer_text = $form_vals['footer_text'];
			$css         = $form_vals['css'];
			$logo_str    = "";

			// if preset, remove any old custom logos
			if ($form_vals['logo_type'] == "preset")
			{
				_ft_remove_old_logo($user_id);
				$logo_str = "logo='{$form_vals['preset_logo']}',";
			}
			else if ($form_vals['logo_type'] == "custom")
			{
				// if a logo has been uploaded, remove old logo and upload this one in its place
				if (!empty($_FILES['logo']['name']))
				{
					$logo = _ft_update_logo($user_id);
					$logo_str = "logo='$logo',";
				}
			}

			$query = "
					UPDATE  {$g_table_prefix}user_accounts
					SET     page_titles='$page_titles',
									footer_text='$footer_text',
									$logo_str
									css='$css'
					WHERE   user_id='$user_id'
							 ";
			break;


		// PERMISSIONS tab
		case "3":
			$active                 = $form_vals['active'];
			$may_delete_submissions = $form_vals['may_delete_submissions'];
			$may_edit_submissions   = $form_vals['may_edit_submissions'];
			$may_download_excel     = $form_vals['may_download_excel'];
			$may_view_printer_friendly_page = $form_vals['may_view_printer_friendly_page'];
			$include_have_a_question_page = $form_vals['include_have_a_question_page'];
			$may_take_forms_offline = $form_vals["may_take_forms_offline"];
			$may_change_email_settings = $form_vals["may_change_email_settings"];
			$may_change_num_submissions = $form_vals["may_change_num_submissions"];
			$may_change_default_printer_friendly_format = $form_vals["may_change_default_printer_friendly_format"];
			$may_change_default_hide_empty_fields = $form_vals["may_change_default_hide_empty_fields"];

			$query = "
					UPDATE  {$g_table_prefix}user_accounts
					SET     active = '$active',
									may_delete_submissions = '$may_delete_submissions',
									may_edit_submissions = '$may_edit_submissions',
									may_download_excel = '$may_download_excel',
									may_view_printer_friendly_page = '$may_view_printer_friendly_page',
									include_have_a_question_page = '$include_have_a_question_page',
									may_take_forms_offline = '$may_take_forms_offline',
									may_change_email_settings = '$may_change_email_settings',
									may_change_num_submissions = '$may_change_num_submissions',
									may_change_default_printer_friendly_format = '$may_change_default_printer_friendly_format',
									may_change_default_hide_empty_fields = '$may_change_default_hide_empty_fields'
					WHERE   user_id='$user_id'
							 ";
			 break;
	}

	// execute the query
	$link = ft_db_connect();
	$result = @mysql_query($query);
	if (!$result)
	{
		$success = false;
		$message = $LANG["notify_client_account_not_updated"];
		if ($g_debug) $message .= "<br/>Query: $query<br />Error: " . mysql_error();
		return array($success, $message);
	}
	ft_db_disconnect($link);

	return array($success, $message);
}


/**
 * Updates the administrator account. With the addition of the "UI Language" option, this gets
 * a little more complicated. The problem is that we can't just update the UI language in
 * sessions within this function, because by the time this function is called, the appropriate
 * language file is already in memory and being used. To solve this problem, the login information
 * form now passed along both the new and old UI languages. If it's different, AFTER this function
 * is called, you need to reset sessions and refresh the page. This is a necessary evil to avoid
 * the problem. So be aware that this problem is NOT handled by this function: see
 * /admin/accounts/_index.php to see how it's solved.
 *
 * @param array $infohash This parameter should be a hash (e.g. $_POST or $_GET) containing the
 *               following keys: first_name, last_name, user_name, password.
 * @param integer $user_id the administrator's user ID
 * @return array [0]: true/false (success / failure)
 *               [1]: message string
 */
function ft_update_admin_account($infohash, $user_id)
{
	global $g_table_prefix, $g_root_url, $LANG;

	$success = true;
	$message = $LANG["notify_account_updated"];
	$form_vals = ft_clean_hash($infohash);

	// check all required fields were entered
	if (empty($form_vals['username']) || empty($form_vals['password']))
	{
		$success = false;
		$message = $LANG["notify_account_not_updated"];
		return array($success, $message);
	}

	$username    = $form_vals['username'];
	$password    = $form_vals['password'];
	$ui_language = $form_vals['ui_language'];

	// extract user ID. If not defined, logout
	$user_id = $_SESSION['ft']['login_user_id'];
	if (empty($user_id))
	{
		header("Location: $g_root_url/logout.php");
		exit;
	}

	// check to see if username is already taken
	list($valid_username, $problem) = _ft_is_valid_username($username, $user_id);
	if (!$valid_username)
	{
		$success = false;
		$message = $problem;
		return array($success, $message);
	}

	$link = ft_db_connect();

	$query = "
			UPDATE  {$g_table_prefix}user_accounts
			SET     username='$username',
							password='$password',
							ui_language='$ui_language'
			WHERE   user_id='$user_id'
					 ";

	mysql_query($query)
		or ft_handle_error("Failed query in <b>" . __FUNCTION__ . "</b>: <i>$query</i>", mysql_error());

	ft_db_disconnect($link);

	return array($success, $message);
}


/**
 * Updates a client account. Used for whomever is currently logged in: pulls the user_id from
 * sessions.
 *
 * @param array $infohash This parameter should be a hash (e.g. $_POST or $_GET) containing keys
 *               named the same as the database fields.
 * @return array [0]: true/false (success / failure)
 *               [1]: message string
 */
function ft_update_client($infohash)
{
	global $g_table_prefix, $LANG;

	$success = true;
	$message = $LANG["notify_account_updated"];
	$form_vals = ft_clean_hash($infohash);

	// check all required fields were entered
	if (empty($form_vals['first_name']) || empty($form_vals['last_name']) ||
			empty($form_vals['email']) || empty($form_vals['username']) ||
			empty($form_vals['password']))
	{
		$success = false;
		$message = $LANG["notify_account_not_updated"];
		return array($success, $message);
	}

	$first_name   = $form_vals['first_name'];
	$last_name    = $form_vals['last_name'];
	$email        = $form_vals['email'];
	$username     = $form_vals['username'];
	$password     = $form_vals['password'];

	// extract user ID. If not defined, logout
	$user_id = $_SESSION['ft']['login_user_id'];
	if (empty($user_id))
	{
		header("Location: $g_root_url/logout.php");
		exit;
	}

	// check to see if username is already taken
	list($valid_username, $problem) = _ft_is_valid_username($username, $user_id);
	if (!$valid_username)
	{
		$success = false;
		$message = $problem;
		return array($success, $message);
	}


	$link = ft_db_connect();

	$query = "
			UPDATE  {$g_table_prefix}user_accounts
			SET     first_name = '$first_name',
							last_name = '$last_name',
							username = '$username',
							password = '$password',
							email = '$email'
			WHERE   user_id = $user_id
					 ";
	mysql_query($query)
		or ft_handle_error("Failed query in <b>" . __FUNCTION__ . "</b>: <i>$query</i>", mysql_error());

	ft_db_disconnect($link);

	return array($success, $message);
}


/**
 * Removes a client from the database and removes any custom logos associated with this user.
 *
 * @param integer $user_id The unique user ID to delete.
 * @return array [0]: true/false (success / failure)
 *               [1]: message string
 */
function ft_delete_client($user_id)
{
	global $g_table_prefix, $LANG;

	// if the account includes a custom logo, remove it
	_ft_remove_old_logo($user_id);

	$link = ft_db_connect();
	$query = mysql_query("DELETE FROM {$g_table_prefix}user_accounts WHERE user_id = '$user_id'");
	ft_db_disconnect($link);

	$success = true;
	$message = $LANG["notify_account_deleted"];

	return array($success, $message);
}


/**
 * Retrieves a list of all clients in the database ordered by last name.
 *
 * @return resource MySQL query resource
 */
function ft_get_client_list()
{
	global $g_table_prefix;

	$link = ft_db_connect();
	$query = "SELECT * FROM {$g_table_prefix}user_accounts WHERE account_type = 'client' ORDER BY last_name";

	$result = mysql_query($query)
		or ft_handle_error("Failed query in <b>" . __FUNCTION__ . "</b>: <i>$query</i>", mysql_error());

	ft_db_disconnect($link);

	return $result;
}


/**
 * Retrieves all information about a user account (adminstrator or client).
 *
 * @param integer $user_id The unique user ID.
 * @return array Returns a hash of all pertinent data.
 */
function ft_get_account_info($user_id)
{
	global $g_table_prefix;

	$link = ft_db_connect();
	$query = "
		SELECT  *
		FROM    {$g_table_prefix}user_accounts
		WHERE   user_id = $user_id
					 ";
	$result = mysql_query($query)
		or ft_handle_error("Failed query in <b>" . __FUNCTION__ . "</b>: <i>$query</i>", mysql_error());

	ft_db_disconnect($link);

	return mysql_fetch_assoc($result);
}


/**
 * Retrieves information about all forms associated with a particular client account.
 *
 * @param integer $user_id If blank, return all forms, otherwise returns the forms associated with
 *              this particular client.
 * @param boolean $is_admin Whether or not the user retrieving the data is an administrator or not.
 *              If it is, ALL forms are retrieved.
 * @return array Returns a hash of all pertinent data.
 */
function ft_get_client_forms($user_id = "", $is_admin = false)
{
	global $g_table_prefix;

	$link = ft_db_connect();

	$where_clause = "";
	$form_clause  = "";
	$admin_clause = "";

	// if a user ID has been specified, find out which forms have been assigned to this client
	// so we can limit our query. Retrieve whatever submission filters this account has, too.
	if (!empty($user_id))
	{
		$query = mysql_query("
			SELECT *
			FROM   {$g_table_prefix}client_forms
			WHERE  user_id = $user_id
				");

		$form_clauses = array();
		while ($result = mysql_fetch_assoc($query))
			$form_clauses[] = "form_id = {$result['form_id']}";

		if (count($form_clauses) > 1)
			$form_clause = "(" . join(" OR ", $form_clauses) . ")";
		else
			$form_clause = isset($form_clauses[0]) ? $form_clauses[0] : "";

		// if no forms were found, just return
		if (empty($form_clauses))
			return;
/*
		// now check submission filters
		$query = mysql_query("
			SELECT filter_sql
			FROM   {$g_table_prefix}client_filters
			WHERE  user_id = $user_id
				");

		$filters_arr = array();
		while ($result = mysql_fetch_assoc($query))
			$filters_arr[] = "({$result["filter_sql"]})";

		if (!empty($filters_arr))
			$filters = join(" AND ", $filters_arr);
*/
	}

	if (!$is_admin)
		$admin_clause = "is_complete = 'yes' AND is_initialized = 'yes'";

	// now build our WHERE clause based on what we need to return
	if (!empty($form_clause) && !empty($admin_clause))
		$where_clause = "$form_clause AND $admin_clause";
	else
		$where_clause = "$form_clause $admin_clause";

	if (trim($where_clause) != "")
		$where_clause = "WHERE $where_clause";

	// get form info
	$form_query_result = mysql_query("
		SELECT form_id, is_active, is_initialized, is_complete, form_name, form_url, redirect_url
		FROM   {$g_table_prefix}forms
		$where_clause
		ORDER BY form_id DESC
					 ");

	// now retrieve some information (id, first and last name) about all users assigned to this form
	$full_info = array();
	while ($current_form = mysql_fetch_assoc($form_query_result))
	{
		$form_info = $current_form;
		$user_info = array();

		$result = mysql_query("
			SELECT cf.user_id, ua.first_name, ua.last_name
			FROM   {$g_table_prefix}client_forms cf, {$g_table_prefix}user_accounts ua
			WHERE  cf.form_id = {$current_form['form_id']}
			AND    cf.user_id = ua.user_id
													 ");
		while ($user_info_result = mysql_fetch_assoc($result))
			$user_info[] = $user_info_result;

		$full_info[] = array($form_info, $user_info);
	}

	ft_db_disconnect($link);

	return $full_info;
}


// ------------------------------------------------------------------------------------------


/**
 * Retrieves all filters for a client - or all client if the user_id isn't specified.
 *
 * @param integer $client_id The unique user ID
 * @return array This function returns an array of multi-dimensional arrays of hashes.
 * Each index of the main array contains the filters for
 */
function ft_get_client_filters($client_id = "")
{
	global $g_table_prefix;

	$where_clause = "";
	if (!empty($client_id))
		$where_clause = "WHERE user_id = $client_id";

	$link = ft_db_connect();
	$result = mysql_query("
		SELECT *
		FROM   {$g_table_prefix}client_filters
		$where_clause
		ORDER BY user_id, filter_id
			");
	ft_db_disconnect($link);

	$infohash = array();
	while ($filter = mysql_fetch_assoc($result))
		$infohash[] = $filter;

	return $infohash;
}


/**
 * Updates the filters for a particular client.
 *
 * @param integer $infohash The POST form submission for the Edit Client -> Filters admin page.
 * @param integer $client_id The unique user ID
 * @return array [0]: true/false (success / failure)
 *               [1]: message string
 */
function ft_update_client_filters($infohash, $client_id)
{
	global $g_table_prefix, $g_debug, $LANG;

	if (empty($client_id))
		return array(false, $LANG["notify_filters_not_updated_no_client"]);

	$infohash = ft_clean_hash($infohash);
	$num_filters = $infohash["num_filters"];

	// delete all old filters
	$link = ft_db_connect();
	mysql_query("DELETE FROM {$g_table_prefix}client_filters WHERE user_id = $client_id");
	ft_db_disconnect($link);

	$errors = array();

	// loop through all filters and add each
	for ($i=1; $i<=$num_filters; $i++)
	{
		// if this row doesn't have a form associated with it, it either wasn't filled in or was deleted. Ignore it.
		if (!isset($infohash["filter_{$i}_form_id"]) || empty($infohash["filter_{$i}_form_id"]))
			continue;

		$form_id  = $infohash["filter_{$i}_form_id"];

		// get a hash of field_id => col name for use in building the SQL statements
		$form_template = ft_get_form_template($form_id);
		$field_columns = array();
		while ($field_info = mysql_fetch_assoc($form_template))
			$field_columns[$field_info["field_id"]] = $field_info["col_name"];

		$field_id = "";
		$values   = "";
		if (preg_match("/date/", $infohash["filter_{$i}_field_id"]))
		{
			$field_id = preg_replace("/date/", "", $infohash["filter_{$i}_field_id"]);
			$values   = $infohash["filter_{$i}_filter_date_values"];
			$operator = $infohash["filter_{$i}_operator_date"];

			// build the SQL statement
			$sql_operator = ($operator == "after") ? ">" : "<";
			$field_name = $field_columns[$field_id];
			$sql = "$field_name $sql_operator '$values'";
		}
		else
		{
			$field_id = $infohash["filter_{$i}_field_id"];
			$values   = $infohash["filter_{$i}_filter_values"];
			$operator = $infohash["filter_{$i}_operator"];

			// build the SQL statement(s)
			$sql_operator = "";
			switch ($operator)
			{
				case "equals":     $sql_operator = "LIKE ";    $join = " OR ";  break;
				case "not_equals": $sql_operator = "NOT LIKE"; $join = " AND "; break;
				case "like":       $sql_operator = "LIKE";     $join = " OR ";  break;
				case "not_like":   $sql_operator = "NOT LIKE"; $join = " AND "; break;
			}
			$sql_statements_arr = array();
			$values_arr = explode("|", $values);
			$field_name = $field_columns[$field_id];

			foreach ($values_arr as $value)
			{
				// if this is a LIKE operator (not_like, like), wrap the value in %..%
				if ($operator == "like" || $operator == "not_like")
					$value = "%$value%";
				$sql_statements_arr[] = "$field_name $sql_operator '$value'";
			}

			$sql = join($join, $sql_statements_arr);
		}
		$sql = "(" . addslashes($sql) . ")";

		$link = ft_db_connect();
		$query = mysql_query("
			INSERT INTO {$g_table_prefix}client_filters (user_id, form_id, field_id, operator, filter_values, filter_sql)
			VALUES      ($client_id, $form_id, $field_id, '$operator', '$values', '$sql')
				") or $errors[] = mysql_error();
		ft_db_disconnect($link);
	}

	if (empty($errors))
		return array(true, $LANG["notify_filters_updated"]);
	else
	{
		$success = false;
		$message = $LANG["notify_filters_not_updated"];

		if ($g_debug)
		{
			array_walk($errors, create_function('&$el','$el = "&bull;&nbsp; " . $el;'));
			$message .= "<br /><br />" . join("<br />", $errors);
		}

		return array($success, $message);
	}
}


/**
 * This function is called whenever a field column name is changed: it updates
 * all filter SQL statements based on this field. Note: for 1.4.6, the only "date" field
 * is the submission date, so it assumes that whatever field is changing is NOT a date
 * field (since the user can never delete or change the submission date)
 *
 * @param integer $field_id
 */
function ft_update_filter_sql($field_id, $new_col_name)
{
	global $g_table_prefix;

	// get all filters that use this field_id
	$link = ft_db_connect();
	$result = mysql_query("
		SELECT *
		FROM   {$g_table_prefix}client_filters
		WHERE  field_id = $field_id
			");
	ft_db_disconnect($link);


	// update the SQL for each filter
	while ($fields = mysql_fetch_assoc($result))
	{
		// build the SQL
		$filter_id     = $fields["filter_id"];
		$operator      = $fields["operator"];
		$filter_values = $fields["filter_values"];

		$sql_operator = "";
		$join = "";
		switch ($operator)
		{
			case "equals":     $sql_operator = "LIKE ";    $join = " OR ";  break;
			case "not_equals": $sql_operator = "NOT LIKE"; $join = " AND "; break;
			case "like":       $sql_operator = "LIKE";     $join = " OR ";  break;
		}

		// build the SQL statement(s)
		$sql_statements_arr = array();
		$values_arr = explode("|", $filter_values);
		foreach ($values_arr as $value)
		{
			// if this is a LIKE statement, wrap the value in %..%
			if ($sql_operator == "LIKE")
				$value = "%$value%";
			$sql_statements_arr[] = "$new_col_name $sql_operator '$value'";
		}

		$sql = join($join, $sql_statements_arr);
		$sql = "(" . addslashes($sql) . ")";

		$link = ft_db_connect();
		$query = "
			UPDATE {$g_table_prefix}client_filters
			SET    filter_sql = '$sql'
			WHERE  filter_id = $filter_id
				";
		mysql_query($query)
			or ft_handle_error("Failed query in <b>" . __FUNCTION__ . "</b>: <i>$query</i>", mysql_error());

		ft_db_disconnect($link);
	}
}


// ------------------------------------------------------------------------------------------


/**
 * Helper function which uploads a client's logo and removes any old logo in its place.
 *
 * @param integer $user_id The unique user ID
 * @return string the logo name, or empty string if no logo had been uploaded.
 */
function _ft_update_logo($user_id)
{
	global $g_root_dir;

	$logo_name = "";

	// if required, upload a logo for this client
	if (is_uploaded_file($_FILES['logo']['tmp_name']))
	{
		_ft_remove_old_logo($user_id);

		// determine the file extension
		if      ($_FILES['logo']['type'] == "image/gif")
			$extension = "gif";
		else if ($_FILES['logo']['type'] == "image/jpeg")
			$extension = "jpg";
		else if ($_FILES['logo']['type'] == "image/png")
			$extension = "png";

		// move file to appropriate folder, rename for this client and set permissions
		move_uploaded_file($_FILES['logo']['tmp_name'], "$g_root_dir/images/logos/client_{$user_id}.{$extension}");
		@chmod("$g_root_dir/images/logos/client_{$user_id}.{$extension}", 0777);

		$logo_name = "client_{$user_id}.{$extension}";
	}

	return $logo_name;
}


/**
 * Helper function which removes any old logo for a given user.
 *
 * @param integer $user_id The unique user ID
 * @return string the logo name, or empty string if no logo had been uploaded.
 */
function _ft_remove_old_logo($user_id)
{
	global $g_root_dir, $g_table_prefix;

	// find out if this client already had a logo specified (other than default: title.gif)
	$link = ft_db_connect();
	$query = "
			SELECT logo
			FROM   {$g_table_prefix}user_accounts
			WHERE  user_id = '$user_id'
					 ";
	$result = mysql_query($query)
		or ft_handle_error("Failed query in <b>" . __FUNCTION__ . "</b>: <i>$query</i>", mysql_error());

	$old_logo = mysql_fetch_row($result);
	ft_db_disconnect($link);

	// remove old files IF they are custom logos
	if (!empty($old_logo[0]) && preg_match("/^client_/", $old_logo[0]))
		@unlink("$g_root_dir/images/logos/{$old_logo[0]}");
}


/**
 * Helper function to determine if a username is valid or not.
 * Checks to see that it only contains alphanumeric chars and that it's not already taken.
 *
 * @param string $username A prospective username
 * @param integer $user_id Optional paramter used when editing the username for an account
 * @return array [0]: true/false (success / failure)
 *               [1]: message string
 */
function _ft_is_valid_username($username, $user_id = "")
{
	global $g_table_prefix, $LANG;

	// check the username is alphanumeric
	if (preg_match("/[^\w]/", $username))
	{
		$success = false;
		$message = $LANG["validation_invalid_client_username2"];
		return array($success, $message);
	}

	$clause = "";
	if (!empty($user_id))
		$clause = "AND user_id != '$user_id'";

	// now check the username isn't already taken
	$query = "
		SELECT count(*)
		FROM   {$g_table_prefix}user_accounts
		WHERE  username = '$username'
					 $clause
					 ";

	$link = ft_db_connect();
	$result = mysql_query($query);
	$info = mysql_fetch_row($result);

	if ($info[0] > 0)
		return array(false, $LANG["validation_username_taken"]);
	else
		return array(true, "");
}


/**
 * Helper function to determine if a submission passes through a set of filters. This is currently
 * used in only one place: when a form is initially submitted and we need to know whether or not a
 * notification email should be sent to the client. This accepts a hash of user_id=>filters and
 * returns a hash of user_id=>T/F. The T/F indicates whether or not a client may manage/view/edit
 * etc. the submission - or in other words, whether the submission was filtered out for each client.
 *
 * @param array $user_filters an hash of user filter info, where the KEY is the user_id and the VALUE
 *              is an array of filters for this particular form.
 * @param integer $submission_id The unique submission ID.
 * @return array Returns a hash where the KEY is the user_id again, and the value is TRUE or FALSE;
 *              true if the user CAN manage the submission (i.e. it hasn't been filtered out) and
 *              false if the user can't manage the submission.
 */
function _ft_check_clients_may_manage_submission($user_filters, $form_id, $submission_id)
{
	global $g_table_prefix;

	// if there are no filters, just return
	if (empty($user_filters))
		return;

	// loop through each user and figure out if this submission has been filtered out or not
	$clients_may_manage_submission_array = array();

	$link = ft_db_connect();
	while (list($user_id, $filters) = each($user_filters))
	{
		if (empty($filters))
		{
			$clients_may_manage_submission_array[$user_id] = true;
			continue;
		}

		$filter_clause = join(" AND ", $filters);
		$query = "
			SELECT count(*)
			FROM   {$g_table_prefix}form_{$form_id}
			WHERE  submission_id = $submission_id AND $filter_clause
				";
		$result = mysql_query($query)
			or ft_handle_error("Failed query in <b>" . __FUNCTION__ . "</b>: <i>$query</i>", mysql_error());

		$info = mysql_fetch_row($result);
		$count = $info[0];

		$clients_may_manage_submission_array[$user_id] = ($count == 0) ? false : true;
	}
	ft_db_disconnect($link);

	return $clients_may_manage_submission_array;
}
