<?php 
session_start();
header("Cache-control: private");
header("Content-Type: text/html; charset=utf-8");
require("_edit_submission.php");

require("../global/templates/client_page_open.php");
?>

  <p class="title"><?php echo $LANG["phrase_form_submission_uc"]; ?></p>

  <p>
    <table cellpadding="0" cellspacing="0">
    <tr>
      <td width="80"><?php echo $previous_link_html?></td>
      <td width="120"><?php echo $search_results_link_html?></td>
      <td><?php echo $next_link_html?></td>
    </tr>
    </table>
  </p>

  <table class="list_table" cellpadding="1" cellspacing="1" border="0">
  <tr height="20">
    <th width="150"><?php echo $LANG["word_field_uc"]; ?></th>
    <th width="450"><?php echo $LANG["word_value_uc"]; ?></th>
  </tr>

  <?php  
  // loop through $submission_info and display all the contents 
  for ($i=0; $i<count($submission_info); $i++)
  {
    if ($submission_info[$i]["col_name"] == "ip_address" && $form_info["show_ip_address"] == "no")
      continue;
  
    echo "<tr height='20'>
            <td>{$submission_info[$i]['field_title']}</td>
            <td>";

    switch ($submission_info[$i]['field_type'])
    {
      case "select":
      case "radio-buttons":
        $field_options = ft_get_field_options($submission_info[$i]['field_id']);
        while ($options = mysql_fetch_assoc($field_options))
        {
          if ($options['option_value'] == $submission_info[$i]["content"])
          {
            echo $options['option_name'];
            break;
          }
        }
        break;

      case "file":
        $file_upload_url = $submission_info[$i]['file_upload_url'];      
        echo "<a href='$file_upload_url/{$submission_info[$i]['content']}' target='_blank'>{$submission_info[$i]['content']}</a>";
        break;
        
      case "multi-select":
      case "checkboxes":
        $values = explode("$g_multi_val_delimiter", $submission_info[$i]['content']);
        $field_options = ft_get_field_options($submission_info[$i]['field_id']);
        $display_vals = array();
        while ($options = mysql_fetch_assoc($field_options))
        {
          if (in_array($options['option_value'], $values))
            $display_vals[] = $options['option_name'];
        }
        echo join(", ", $display_vals);
        break;

      case "system":
				switch ($submission_info[$i]["col_name"])
				{
					case "submission_id":
						echo $submission_id;
						break;
					case "submission_date":
						echo ft_get_date($settings['timezone_offset'], $submission_info[$i]['content'], $settings['date_format']);
						break;
					case "ip_address":
						echo $submission_info[$i]['content'];
						break;
				}
        break;

      default:
        echo nl2br($submission_info[$i]['content']);
        break;    
    }

     echo "</td>
         </tr>";
  }
  ?>
  </table>
  
  <br />

  <form action="edit_submission.php" method="GET">
    <input type="hidden" name="submission_id" value="<?php echo $submission_id?>" />
    <input type="hidden" name="form_id" value="<?php echo $form_id?>" />

    <?php if ($_SESSION['ft']['may_edit_submissions'] == "yes") { ?>
      <input type="submit" value="<?php echo $LANG['phrase_edit_submission_uc']?>" />
    <?php } ?>

    <?php if ($_SESSION['ft']['may_delete_submissions'] == "yes") { ?>
      <input type="button" name="delete" value="<?php echo $LANG['word_delete_uc']?>" class="red" 
        onclick="window.location='index.php?delete=1&submission_ids=<?php echo $submission_id?>&form_id=<?php echo $form_id?>'"/>
    <?php } ?>
  </form>

<?php require_once("../global/templates/footer.php"); ?>