<?php 
session_start();
header("Cache-control: private");
header("Content-Type: text/html; charset=utf-8");
require("_settings.php");

require("../global/templates/client_page_open.php");
?>

  <p class='title'><?php echo $LANG["phrase_form_settings_uc"]; ?></p>

  <?php echo ft_display_message($success, $message);?>

  <div><a href="../main.php"><?php echo $LANG["word_back_leftarrow"]; ?></a></div>
  <br />
  
  <form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" name="settings" onsubmit="return validateFields(this, rules)">
	  <input type="hidden" name="form_id" value="<?php echo $form_id; ?>" />
	  
	  <table class="list_table" cellpadding="1" cellspacing="1" border="0" width="400">
	  <?php if ($_SESSION["ft"]["may_take_forms_offline"] == "yes") { ?>
			<tr>
				<td >&nbsp;<?php echo $LANG["word_online"]; ?></td>
				<td width="330"> 
					<input type="radio" name="is_active" id="is_active1" value="yes" 
					  <?php if ($is_active == "yes") echo "checked"; ?> />
					  <label for="is_active1"><?php echo $LANG["word_yes"]; ?></label>
					<input type="radio" name="is_active" id="is_active2" value="no" 
					  <?php if ($is_active == "no") echo "checked"; ?> />
					  <label for="is_active2"><?php echo $LANG["word_no"]; ?></label>
				</td>
			</tr>
	  <?php } if ($_SESSION["ft"]["may_change_email_settings"] == "yes") { ?>
			<tr>
				<td>&nbsp;<?php echo $LANG["phrase_send_email_receipt_to_user"]; ?></td>
				<td width="330">
					<input type="radio" name="auto_email_user" id="auto_email_user1" value="yes" 
					  <?php if ($auto_email_user == "yes") echo "checked"; ?> />
					  <label for="auto_email_user1"><?php echo $LANG["word_yes"]; ?></label>
					<input type="radio" name="auto_email_user" id="auto_email_user2" value="no" 
					  <?php if ($auto_email_user == "no") echo "checked"; ?> />
					  <label for="auto_email_user2"><?php echo $LANG["word_no"]; ?></label>
				</td>
			</tr>
			<tr>
				<td>&nbsp;<?php echo $LANG["phrase_auto_email_administrator_sp"]; ?></td>
				<td width="330">
					<input type="radio" name="auto_email_admin" id="auto_email_admin1" value="yes" 
					  <?php if ($auto_email_admin == "yes") echo "checked"; ?> />
					  <label for="auto_email_admin1"><?php echo $LANG["word_yes"]; ?></label>
					<input type="radio" name="auto_email_admin" id="auto_email_admin2" value="no" 
					  <?php if ($auto_email_admin == "no") echo "checked"; ?> />
					  <label for="auto_email_admin2"><?php echo $LANG["word_no"]; ?></label>
				</td>
			</tr>
	  <?php } if ($_SESSION["ft"]["may_change_num_submissions"] == "yes") { ?>
			<tr>
				<td>&nbsp;<?php echo $LANG["phrase_num_submissions_per_page"]; ?></td>
				<td width="330"><input type="text" name="num_submissions_per_page" size="3" value="<?php echo $num_submissions_per_page; ?>" /></td>
			</tr>
	  <?php } if ($_SESSION["ft"]["may_change_default_printer_friendly_format"] == "yes") { ?>
			<tr>
				<td>&nbsp;<?php echo $LANG["phrase_default_printer_friendly_format"]; ?></td>
				<td width="330">
					<select name="printer_friendly_format">
						<option value="table" <?php if ($form_info['printer_friendly_format'] == "table") echo "selected"; ?>><?php echo $LANG["phrase_table_format"]; ?></option>
						<option value="one_by_one" <?php if ($form_info['printer_friendly_format'] == "one_by_one") echo "selected"; ?>><?php echo $LANG["phrase_one_by_one"]; ?></option>
						<option value="one_per_page" <?php if ($form_info['printer_friendly_format'] == "one_per_page") echo "selected"; ?>><?php echo $LANG["phrase_one_submission_per_page"]; ?></option>
					</select>
				</td>
			</tr>
	  <?php } if ($_SESSION["ft"]["may_change_default_hide_empty_fields"] == "yes") { ?>
			<tr>
				<td>&nbsp;<?php echo $LANG["phrase_hide_empty_fields"]; ?></td>
				<td width="330">
					<input type="radio" name="hide_empty_fields" id="hide_empty_fields1" value="yes" 
					  <?php if ($form_info['hide_printer_friendly_empty_fields'] == "yes") echo "checked"; ?> />
					  <label for="hide_empty_fields1"><?php echo $LANG["word_yes"]; ?></label>
					<input type="radio" name="hide_empty_fields" id="hide_empty_fields2" value="no" 
					  <?php if ($form_info['hide_printer_friendly_empty_fields'] == "no") echo "checked"; ?> />
					  <label for="hide_empty_fields2"><?php echo $LANG["word_no"]; ?></label>
				</td>
			</tr>
		<?php } ?>
	  </table>
	
	  <p>
	    <input type="submit" value="<?php echo $LANG["word_update_uc"]; ?>" />
	  </p>

  </form>
  
<?php require_once("../global/templates/footer.php"); ?>