<?php
session_start();
header("Cache-control: private");
header("Content-Type: text/html; charset=utf-8");
require("_edit_submission.php");

require("../global/templates/client_page_open.php");
?>

  <p class="title"><?php echo $LANG["phrase_edit_submission_uc"]; ?></p>

  <p>
    <table cellpadding="0" cellspacing="0">
    <tr>
      <td width="80"><?php echo $previous_link_html?></td>
      <td width="120"><?php echo $search_results_link_html?></td>
      <td><?php echo $next_link_html?></td>
    </tr>
    </table>
  </p>

  <?php echo ft_display_message($success, $message);?>

  <form action="edit_submission.php" method="post" name="edit_submission_form" enctype="multipart/form-data">
	  <input type="hidden" name="form_id" value="<?php echo $form_id?>" />
	  <input type="hidden" name="submission_id" value="<?php echo $submission_id?>" />
	  <input type="hidden" name="field_id" value="" />
	  <input type="hidden" name="delete_file" value="" />
	  <input type="hidden" name="email_user" value="" />
	  
	  <table class="list_table" cellpadding="1" cellspacing="1" border="0" width="600">
	  <tr height="20">
	    <th width="150"><?php echo $LANG["word_field_uc"]; ?></th>
	    <th width="450"><?php echo $LANG["word_value_uc"]; ?></th>
	  </tr>
	
	  <?php
	
	  // loop through $submission_info and display all the contents
	  for ($i=0; $i<count($submission_info); $i++)
	  {
	    if ($submission_info[$i]["col_name"] == "ip_address" && $form_info["show_ip_address"] == "no")
	      continue;
	
	    echo "<tr height='20'>
	            <td>&nbsp;{$submission_info[$i]['field_title']}</td>
	            <td>";
	
	    $id_num = 1;
	            
	    switch ($submission_info[$i]['field_type'])
	    {
	      case "select":
	        $option_info = ft_get_field_options($submission_info[$i]['field_id']);
	
	        echo "<select name='{$submission_info[$i]['col_name']}'>";        
	        while ($option = mysql_fetch_assoc($option_info))
	        {
	          echo "<option value='{$option['option_value']}'";
	          if ($option['option_value'] == $submission_info[$i]['content'])
	            echo " selected";
	          echo ">{$option['option_name']}</option>";
	        }
	        echo "</select>";
	        break;
	
	      case "radio-buttons":
	        $option_info = ft_get_field_options($submission_info[$i]['field_id']);
	        $pagebreak = ($submission_info[$i]['option_orientation'] == "vertical") ? "<br />" : "";
	
	        while ($option = mysql_fetch_assoc($option_info))
	        {
	          $id = "{$submission_info[$i]['field_id']}_$id_num";
	          echo "<input type='radio' name='{$submission_info[$i]['col_name']}' value='{$option['option_value']}' id='$id'";
	          if ($option['option_value'] == $submission_info[$i]['content'])
	            echo " checked";
	          echo "><label for='$id'>{$option['option_name']}</label>$pagebreak\n";
	          $id_num++;
	        }
	        break;
	
	      case "checkboxes":
	        $selected = explode($g_multi_val_delimiter, $submission_info[$i]['content']);                
	        $option_info = ft_get_field_options($submission_info[$i]['field_id']);
	        $pagebreak = ($submission_info[$i]['option_orientation'] == "vertical") ? "<br />" : "";
	
	        while ($option = mysql_fetch_assoc($option_info))
	        {
	          $id = "{$submission_info[$i]['field_id']}_$id_num";
	          echo "<input type='checkbox' name='{$submission_info[$i]['col_name']}[]' value='{$option['option_value']}' id='$id'";
	          if (in_array($option['option_value'], $selected))
	            echo " checked";
	          echo "><label for='$id'>{$option['option_name']}</label>$pagebreak\n";
	          $id_num++;
	        }
	        break;
	
	      case "multi-select":
	        $selected = explode($g_multi_val_delimiter, $submission_info[$i]['content']);                
	        $option_info = ft_get_field_options($submission_info[$i]['field_id']);
	
	        echo "<select name='{$submission_info[$i]['col_name']}[]' size='5' multiple>";
	        while ($option = mysql_fetch_assoc($option_info))
	        {
	          echo "<option value='{$option['option_value']}'";
	          if (in_array($option['option_value'], $selected))
	            echo " selected";
	          echo ">{$option['option_name']}</option>\n";
	          $id_num++;
	        }
	        echo "</select>";
	        break;

	      case "file":
	        $file_upload_url = $submission_info[$i]['file_upload_url'];
	
	        if (!empty($submission_info[$i]['content']))
	        {
	          $filename = ft_trim_string($submission_info[$i]['content'], 80, "page_break");
	          echo "<a href='$file_upload_url/{$submission_info[$i]['content']}' target='_blank'>$filename</a>";
	          echo "&nbsp;&nbsp;<input type='button' value='{$LANG['phrase_delete_file_uc']}' onclick='delete_submission_file({$submission_info[$i]['field_id']});' />";
	        }
	        else
	        {
	          echo "<input type='file' name='{$submission_info[$i]['col_name']}' />";
	        }
	        break;
	        
	      case "system":
					switch ($submission_info[$i]["col_name"])
					{
						case "submission_id":
							echo $submission_id;
							break;
						case "submission_date":
							echo ft_get_date($settings['timezone_offset'], $submission_info[$i]['content'], $settings['date_format']);
							break;
						case "ip_address":
							echo $submission_info[$i]['content'];
							break;
					}
	        break;
	
	      // textarea / textboxes
	      default:
	        $content = htmlspecialchars($submission_info[$i]['content'], ENT_QUOTES);
	
	        if ($submission_info[$i]['field_size'] == "tiny")
	          echo "<input type='text' name='{$submission_info[$i]['col_name']}' value='$content' style='width: 50px;' />";
	
	        else if ($submission_info[$i]['field_size'] == "small") 
	          echo "<input type='text' name='{$submission_info[$i]['col_name']}' value='$content' style='width: 150px;' />";
	    
	        else if ($submission_info[$i]['field_size'] == "medium")
	          echo "<input type='text' name='{$submission_info[$i]['col_name']}' value='$content' style='width: 100%;' />";
	        
	        else if (($submission_info[$i]['field_size'] == "large") || ($submission_info[$i]['field_size'] == "very_large"))
	          echo "<textarea name='{$submission_info[$i]['col_name']}' style='width: 100%; height: 80px'>$content</textarea>";
	        break;
	    }
	
	    echo "</td>\n</tr>\n";
	  }
	  ?>
	  </table>

	  <br />

	  <input type="submit" name="update" value="<?php echo $LANG["word_update_uc"]; ?>" />

		<?php if ($_SESSION['ft']['may_delete_submissions'] == "yes") { ?>
			<input type="button" name="delete" value="<?php echo $LANG['word_delete_uc']?>" class="red" onclick="window.location='index.php?delete=1&submission_ids=<?php echo $submission_id?>&form_id=<?php echo $form_id?>'"/>
		<?php } ?>
	
	  <?php
	  // if auto_email_user is selected, we have a corresponding email template for this form, 
	  // so provide a button to resend the email to the user  
	  if ($form_info['auto_email_user'] == "yes")
	  {
	    echo "<input type='button' value='{$LANG["phrase_email_user_uc"]}' onclick='send_user_email()' />";
	  }
	  ?>
  </form>
  
<?php require_once("../global/templates/footer.php"); ?>