<?php

require("../global/library.php");
ft_check_permission("client");

// blur the GET and POST variables into a single variable for easy reference
$request = array_merge($_POST, $_GET);
$form_id       = $request['form_id'];
$submission_id = $request['submission_id'];

// check that this client may manage (and view) this form submission
ft_check_may_manage_form($form_id, $_SESSION['ft']['login_user_id']);

$success = false;
$message = "";

// handle POST requests
if (isset($_POST) && !empty($_POST))
{
  // first, update this submission
  list($success, $message) = ft_update_submission($request);

  // if required, remove a file
  $file_deleted = false;
  if (isset($_POST['delete_file']) && !empty($_POST['delete_file']))
  {
    list($success, $message) = ft_delete_file_submission($form_id, $submission_id, $_POST['field_id']);
    $file_deleted = true;
  }
  else if (isset($_POST['email_user']) && !empty($_POST['email_user']))
  {
    $success = ft_send_email("user", $form_id, $submission_id);
    if ($success)
      $message = $LANG["notify_email_sent_to_user"];
  }
}

$submission_info = ft_get_submission($form_id, $submission_id);
$form_info       = ft_get_form($form_id);
$settings        = ft_get_settings();


// if we're just coming here from the search results page, get a fresh list of every submission ID in this 
// search result set. This is used to build the internal "<< previous   next >>" nav on this details page
if ($_SESSION["ft"]["new_search"])
{
  // extract the original search settings and get the list of IDs
	$search = $_SESSION["ft"]["current_search"];
	$_SESSION["ft"]["search_submission_settings"] = ft_get_search_submission_ids($search["form_id"], $search["results_per_page"], 
	                                                                             $search["order"], $search["search_fields"]);
  $_SESSION["ft"]["new_search"] = "no";
}

$previous_link_html       = "";
$search_results_link_html = "";
$next_link_html           = "";
if (isset($_SESSION["ft"]["search_submission_settings"]) && !empty($_SESSION["ft"]["search_submission_settings"]))
{
  $submission_ids = $_SESSION["ft"]["search_submission_settings"];
  $current_sub_id_index = array_search($submission_id, $submission_ids);
  
  // PREVIOUS link
  $previous_link_html = "";
  if ($submission_ids[0] == $submission_id)
    $previous_link_html = "<span class='light_grey'>{$LANG["word_previous_leftarrow"]}</span>";
  else
  {
    $previous_submission_id = $submission_ids[$current_sub_id_index - 1];
    $previous_link_html = "<a href='{$_SERVER['PHP_SELF']}?form_id=$form_id&submission_id=$previous_submission_id'>{$LANG["word_previous_leftarrow"]}</a>";
  }
  
  $results_per_page = $search["results_per_page"];
  $submission_ids_per_page = array_chunk($submission_ids, 10);
  
  $return_page = 1;
  for ($i=0; $i<count($submission_ids_per_page); $i++)
  {
    if (in_array($submission_id, $submission_ids_per_page[$i]))
    {
      $return_page = $i+1;
      break;
    }
  }

  $search_results_link_html = "<a href='index.php?form_id=$form_id&page=$return_page'>{$LANG["phrase_back_to_search_results"]}</a>";

  // NEXT link
  $next_link_html = "";
  if ($submission_ids[count($submission_ids) - 1] == $submission_id)
    $next_link_html = "<span class='light_grey'>{$LANG["word_next_rightarrow"]}</span>";
  else
  {
    $next_submission_id = $submission_ids[$current_sub_id_index + 1];
    $next_link_html = "<a href='{$_SERVER['PHP_SELF']}?form_id=$form_id&submission_id=$next_submission_id'>{$LANG["word_next_rightarrow"]}</a>";
  }  
}


// header information 
$g_nav_page   = "form";
$g_logo       = $_SESSION['ft']['logo'];
$g_head_title = "{$_SESSION['ft']['page_titles']} - {$LANG['word_submission']}";
$g_head_css   = $_SESSION['ft']['css'];
$g_head_js = "
	/* -----------------------------------------------------------------------------------------------*\
	  Function: delete_submission_file
	  Purpose:  called when the user clicks a DELETE FILE button. It sets the delete_file hidden 
	            field to 1 and stores the field ID in a hidden field. It then submits the form. This way
	            any changes they made to the form values won't be lost. 
	\* -----------------------------------------------------------------------------------------------*/
	function delete_submission_file(field_id)
	{
	  f = document.edit_submission_form;
	  f.field_id.value = field_id;
	  f.delete_file.value = 1;
	  f.submit(); 
	}
	
	/* -----------------------------------------------------------------------------------------------*\
	  Function: send_user_email
	  Purpose:  called when the user clicks the EMAIL USER button.  It sets the email_user hidden 
	            field to 1 and stores the field ID in a hidden field. It then submits the form. This way
	            any changes they made to the form values won't be lost. 
	\* -----------------------------------------------------------------------------------------------*/
	function send_user_email()
	{
	  f = document.edit_submission_form;
	  f.email_user.value = 1;
	  f.submit(); 
	}";


?>