<?php

require_once("../../global/library.php");
ft_check_permission("admin");
$success = true;
$message = "";

if (!empty($_POST))
  list($success, $message) = ft_update_settings($_POST);

// if required, update the list of available languages
if (isset($_GET["refresh_lang_list"]))
  list($success, $message) = ft_refresh_language_list();


$settings = ft_get_settings();

// get the list of available languages
$available_language_info = $settings["available_languages"];
$available_language_arr = explode("|", $available_language_info);


// escape all entries so no errors occur in the page
$g_program_name = htmlspecialchars($settings['program_name']);
$g_footer_text  = htmlspecialchars($settings['footer_text']);

// header information
$g_head_title = "{$_SESSION["ft"]["program_name"]} - {$LANG["phrase_setup_options"]}";
$g_nav_page = "program_settings";
$g_head_js = " 
	var rules = new Array();
	rules.push(\"required,program_name,{$LANG["validation_no_program_name"]}\");
	rules.push(\"required,footer_text,{$LANG["validation_no_footer_text"]}\");
	rules.push(\"required,administrator_email,{$LANG["validation_no_admin_email"]}\");
	rules.push(\"valid_email,administrator_email,{$LANG["validation_invalid_admin_email"]}\");
	rules.push(\"required,logout_url,{$LANG["validation_no_logout_url"]}\");
	rules.push(\"required,default_language,{$LANG["validation_no_default_language"]}\");
	rules.push(\"required,date_format,{$LANG["validation_no_date_format"]}\");
	rules.push(\"required,num_clients_per_page,{$LANG["validation_no_num_clients_per_page"]}\");
	rules.push(\"digits_only,num_clients_per_page,{$LANG["validation_invalid_num_clients_per_page"]}\");
	rules.push(\"required,num_forms_per_page,{$LANG["validation_no_num_forms_per_page"]}\");
	rules.push(\"digits_only,num_forms_per_page,{$LANG["validation_invalid_num_forms_per_page"]}\");
	rules.push(\"required,default_css,{$LANG["validation_no_default_css"]}\");
    ";

?>