<script type="text/javascript">

function process_form(frm)
{
  var rules = new Array();
  rules.push("required,form_name,<?php echo $LANG['validation_no_form_name']; ?>");
  rules.push("required,form_url,<?php echo $LANG['validation_no_form_url']; ?>");
  rules.push("if:form_type=direct,required,redirect_url,<?php echo $LANG['validation_no_redirect_url']; ?>");

  if (!validateFields(frm, rules))
    return false;
    
  // check at least one user was selected
  if (frm["selected_user_ids[]"].length == 0)
  { 
    alert("<?php echo $LANG['validation_no_client_assigned']; ?>");
    return false;
  }
    
  // select all clients
  select_all(frm["selected_user_ids[]"]);

  return true;
}

function verify_url(url)
{
  window.open(url, "verify_url", "width=700,height=500,menu=no,toolbar=no");
}

</script>

<table cellpadding="0" cellspacing="0" border="0" width="650">
<tr>
  <td>

    <?php
    $tab = "main";
    require("_edit_form_tabs.php");
    ?>

  </td>   
</tr>
<tr>
  <td colspan="2" class="tab_content">

    <div class="subtitle underline"><?php echo $LANG["phrase_form_settings_uc"]; ?></div>
    <br />    
      
    <form method="post" name="add_form" action="<?php echo $_SERVER['PHP_SELF']?>" onsubmit="return process_form(this)">
	    <input type="hidden" name="form_id" value="<?php echo $form_id?>" />
	    
	    <table class="list_table" width="100%" cellpadding='0' cellspacing='1'>
	    <tr height="20">
	      <td class="highlighted_cell">*</td>
	      <td>&nbsp;<?php echo $LANG["word_online"]; ?></td>
	      <td>
	        <input type="radio" name="active" id="active1" value="yes" <?php if ($form_info['is_active'] == "yes") echo "checked"; ?> />
	        <label for="active1"><?php echo $LANG["word_yes"]; ?></label>
	        <input type="radio" name="active" id="active2" value="no" <?php if ($form_info['is_active'] == "no") echo "checked"; ?> />
	        <label for="active2"><?php echo $LANG["word_no"]; ?></label>
	      </td>
	    </tr>
	    <tr height="20">
	      <td class="highlighted_cell">*</td>
	      <td>&nbsp;<?php echo $LANG["phrase_form_name"]; ?></td>
	      <td><input type="text" name="form_name" value="<?php echo htmlspecialchars($form_info['form_name']); ?>" style="width: 85%;" /></td>
	    </tr>
	    <tr height="20">
	      <td class="highlighted_cell">*</td>
	      <td>&nbsp;<?php echo $LANG["phrase_form_url"]; ?></td>
	      <td>
	        <input type="text" name="form_url" value="<?php echo $form_info['form_url']?>" style="width: 85%;" />
	        <a href="javascript:verify_url(document.add_form.form_url.value)"><?php echo $LANG["phrase_verify_url"]; ?></a>
	      </td>
	    </tr>
	    <tr height="20">
	      <td class="highlighted_cell" width="15">*</td>
	      <td width="160">&nbsp;<?php echo $LANG["word_client_sp"]; ?></td>
	      <td>
	    
	          <table cellpadding="0" cellspacing="0">
	          <tr>
	            <td class="grey_text"><?php echo $LANG["phrase_available_clients"]; ?></td>
	            <td></td>
	            <td class="grey_text"><?php echo $LANG["phrase_selected_clients"]; ?></td>
	          </tr>
	          <tr>
	            <td>
	
	              <select name="available_user_ids[]" multiple size="4" style="width: 140px">
	                <?php
	                $clients = ft_get_client_list();
	
	                for ($i=0; $i<count($form_info['user_info']); $i++)
	                  $selected_user_ids[] = $form_info['user_info'][$i]['user_id'];
	
	                while ($client = mysql_fetch_assoc($clients))
	                {
	                  $user_name = $client['first_name'] . " " . $client['last_name'];
	                  $user_id   = $client['user_id'];
	                  
	                  if (in_array($user_id, $selected_user_ids))
	                    continue;
	    
	                  echo "<option value='$user_id'>" . $user_name . "</option>";
	                }
	                ?>
	              </select>
	
	            </td>
	            <td align="center" valign="center" width="100">
	              <input type="button" value="<?php echo $LANG['word_add_uc_rightarrow']; ?>" 
	                onclick="move_options(this.form['available_user_ids[]'], this.form['selected_user_ids[]']);" /><br />
	              <input type="button" value="<?php echo $LANG['word_remove_uc_leftarrow']; ?>" 
	                onclick="move_options(this.form['selected_user_ids[]'], this.form['available_user_ids[]']);" />
	            </td>
	            <td>
	
	              <select name="selected_user_ids[]" multiple size="4" style="width: 140px">
	                <?php
	                
	                for ($i=0; $i<count($form_info['user_info']); $i++)
	                {                  
	                  $user_name = $form_info['user_info'][$i]['first_name'] . " " . $form_info['user_info'][$i]['last_name'];
	                  $user_id   = $form_info['user_info'][$i]['user_id'];
	                  
	                  echo "<option value='$user_id'>$user_name</option>\n";
	                }
	                ?>
	              </select>
	
	            </td>
	          </tr>
	          </table>
	    
	      </td>
	    </tr>
	    <tr height="20">
	      <td valign="top" class="highlighted_cell" rowspan="2">*</td>
	      <td valign="top">
	        <input type="radio" name="form_type" id="form_type1" value="direct" <?php if ($form_info['form_type'] == "direct") echo "checked"; ?> />
	        <label for="form_type1"><?php echo $LANG["phrase_direction_submission"]; ?></label>
	      </td>
	      <td>
	
	        <table width="100%" cellpadding="0" cellspacing="0">
	        <tr>
	          <td nowrap>&nbsp;<?php echo $LANG["phrase_redirect_url"]; ?>&nbsp;</td>
	          <td width="65%">
	            <input type="text" size="30" name="redirect_url" value="<?php echo $form_info['redirect_url']?>" style='width: 100%' />
	          </td>
	          <td nowrap>
	            &nbsp;<a href="javascript:verify_url(document.add_form.redirect_url.value)"><?php echo $LANG["phrase_verify_url"]; ?></a>
	          </td>
	        </tr>
	        </table>
	 
	      </td>
	    </tr>
	    <tr height="20">
	      <td>
	        <input type="radio" name="form_type" id="form_type2" value="code" <?php if ($form_info['form_type'] == "code") echo "checked"; ?> />
	        <label for="form_type2"><?php echo $LANG["phrase_code_submission"]; ?></label>
	      </td>
	      <td>
	        <input type="radio" name="finalized_submissions" id="finalized_submissions1" value="yes" 
	          <?php if ($form_info['finalized_submissions'] == 'yes') echo "checked"; ?> />
	          <label for="finalized_submissions1"><?php echo $LANG["phrase_submissions_automatically_finalized"]; ?></label>
	        <input type="radio" name="finalized_submissions" id="finalized_submissions2" value="no" 
	          <?php if ($form_info['finalized_submissions'] == 'no') echo "checked"; ?> />
	          <label for="finalized_submissions2"><?php echo $LANG["phrase_submissions_need_finalizing"]; ?></label>
	      </td>
	    </tr>
	    <tr height="20">
	      <td class="highlighted_cell">*</td>
	      <td>&nbsp;<?php echo $LANG["phrase_default_printer_friendly_format"]; ?></td>
	      <td>
	        <select name="printer_friendly_format">
	          <option value="table" <?php if ($form_info['printer_friendly_format'] == "table") echo "selected"; ?>><?php echo $LANG["phrase_table_format"]; ?></option>
	          <option value="one_by_one" <?php if ($form_info['printer_friendly_format'] == "one_by_one") echo "selected"; ?>><?php echo $LANG["phrase_one_by_one"]; ?></option>
	          <option value="one_per_page" <?php if ($form_info['printer_friendly_format'] == "one_per_page") echo "selected"; ?>><?php echo $LANG["phrase_one_submission_per_page"]; ?></option>
	        </select>
	      </td>
	    </tr>
	    <tr height="20">
	      <td class="highlighted_cell">*</td>
	      <td>&nbsp;<?php echo $LANG["phrase_hide_empty_fields"]; ?></td>
	      <td>      
	        <input type="radio" name="hide_empty_fields" id="hide_empty_fields1" value="yes" 
	          <?php if ($form_info['hide_printer_friendly_empty_fields'] == "yes") echo "checked"; ?> />
	          <label for="hide_empty_fields1"><?php echo $LANG["word_yes"]; ?></label>
	        <input type="radio" name="hide_empty_fields" id="hide_empty_fields2" value="no" 
	          <?php if ($form_info['hide_printer_friendly_empty_fields'] == "no") echo "checked"; ?> />
	          <label for="hide_empty_fields2"><?php echo $LANG["word_no"]; ?></label>
	      </td>
	    </tr>
	    <tr height="20">
	      <td class="highlighted_cell">*</td>
	      <td>&nbsp;<?php echo $LANG["phrase_delete_uploaded_fields_with_submission"]; ?></td>
	      <td>
	        <input type="radio" name="auto_delete_submission_files" id="auto_delete_submission_files1" value="yes" 
	          <?php if ($form_info['auto_delete_submission_files'] == "yes") echo "checked"; ?> />
	          <label for="auto_delete_submission_files1"><?php echo $LANG["word_yes"]; ?></label>
	        <input type="radio" name="auto_delete_submission_files" id="auto_delete_submission_files2" value="no" 
	          <?php if ($form_info['auto_delete_submission_files'] == "no") echo "checked"; ?> />
	          <label for="auto_delete_submission_files2"><?php echo $LANG["word_no"]; ?></label>
	      </td>
	    </tr>
	    <tr height="20">
	      <td class="highlighted_cell">*</td>
	      <td>&nbsp;<?php echo $LANG["phrase_strip_tags_in_submissions"]; ?></td>
	      <td>
	        <input type="radio" name="submission_strip_tags" id="sst1" value="yes" 
	          <?php if ($form_info['submission_strip_tags'] == "yes") echo "checked"; ?> />
	          <label for="sst1"><?php echo $LANG["word_yes"]; ?></label>
	        <input type="radio" name="submission_strip_tags" id="sst2" value="no" 
	          <?php if ($form_info['submission_strip_tags'] == "no") echo "checked"; ?> />
	          <label for="sst2"><?php echo $LANG["word_no"]; ?></label>
	      </td>
	    </tr>
	    </table>
	    
	    <p>
	      <input type="submit" name="update_main" value="<?php echo $LANG['word_update_uc']; ?>" />
	    </p>
	    
    </form>
 
  </td>
</tr>
</table>
